/*
  $Id: bio.h,v 1.6 1997/01/12 22:50:57 luik Exp $

  bio.h - buffered input/output function definitions for omirrd.
  Copyright (C) 1996, Andreas Luik, <luik@pharao.s.bawue.de>.

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 1, or (at your option)
  any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

#ifndef BIO_H_INCLUDED
#define BIO_H_INCLUDED

#if HAVE_SYS_TIME_H
#include <sys/time.h>
#endif /* HAVE_SYS_TIME_H */
#include <sys/types.h>

#include "mp.h"

#ifdef	__cplusplus
extern "C" {
#endif

#define BIO_BUF_SIZE 2048	/* inital buffer size for buffered I/O buffer */

typedef struct BioBuffer_ {
    void *buf;
    int buf_size;		/* allocated size of buffer */
    int buf_start;		/* current read position in buffer */
    int buf_end;		/* current buffer end position */
    int fd_flags;		/* saved fd flags returned by fcntl(F_GETFL) */
    MpContext mp_context;	/* associated mp context */
} *BioBuffer, BioBufferRec;

typedef struct BioContext_ {
    BioBufferRec writebufs[FD_SETSIZE];
} *BioContext, BioContextRec;

/* bio.c */
extern BioContext bioAlloc(void);
extern void bioFree(BioContext context);
extern BioContext bioAddWriteBuffer(BioContext context, int fd, MpContext mp_context);
extern BioContext bioRemoveWriteBuffer(BioContext context, int fd);
extern int bioMpWriteFunc(int fd, void *data);
extern void bioWrite(BioContext context, int fd, const void *buf, size_t len);

#ifdef	__cplusplus
}
#endif

#endif /* defined(BIO_H_INCLUDED) */
