!**************************************************************************
!*
!* Boot-ROM-Code to load an operating system across a TCP/IP network.
!*
!* Module:  utility.S
!* Purpose: Various functions for the network library, which are
!*          better written in assembler
!* Entries: __htons, __htonl, _ipchksum
!*
!**************************************************************************
!*
!* Copyright (C) 1995-1998 Gero Kuhlmann <gero@gkminix.han.de>
!*
!*  This program is free software; you can redistribute it and/or modify
!*  it under the terms of the GNU General Public License as published by
!*  the Free Software Foundation; either version 2 of the License, or
!*  any later version.
!*
!*  This program is distributed in the hope that it will be useful,
!*  but WITHOUT ANY WARRANTY; without even the implied warranty of
!*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
!*  GNU General Public License for more details.
!*
!*  You should have received a copy of the GNU General Public License
!*  along with this program; if not, write to the Free Software
!*  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
!*


!
!**************************************************************************
!
! Include assembler macros:
!
#include <macros.inc>
#include <memory.inc>


!
!**************************************************************************
!
! Start code segment.
!
	.text

#ifndef OPT386
	public	__htons
#endif
	public	__htonl			! define entry points
	public	_ipchksum


!
!**************************************************************************
!
! Convert host byte order into network byte oder for int. This is only
! necessary if the C code is not getting optimized, because otherwise
! this gets optimized away.
! Input:  1. arg  -  host value
! Output: network value
!
#ifndef OPT386
__htons:

	penter				! setup standard stack frame
	getcarg	(ax,0)			! get host value
	xchg	al,ah			! just swap bytes
	pleave
	ret
#endif


!
!**************************************************************************
!
! Convert host byte order into network byte order for long int.
! Input:  1. arg  -  host value
! Output: network value
!
__htonl:

	penter				! setup standard stack frame
#ifdef OPT386
	getcarg	(ax,0)
	xchg	al,ah			! swap byte in low order word
	shl	eax,#16			! get low order word into high order pos
	getcarg	(ax,1)
	xchg	al,ah			! swap bytes in high order word
#else
	getcarg	(dx,0)			! get low order word into high order reg
	getcarg	(ax,1)			! get high order word into low order reg
	xchg	dl,dh
	xchg	al,ah			! swap bytes in each word
#endif
	pleave
	ret


!
!**************************************************************************
!
! Compute IP header checksum.
! Input:  1. arg  -  pointer to buffer
!         2. arg  -  length of header
! Output: checksum
!
_ipchksum:

	penter				! setup standard stack frame
	push	si
	getcarg	(si,0)			! get header address
	getcarg	(cx,1)			! get header length
	shr	cx,#1

	cld
	clc
	xor	bx,bx			! add checksum in BX
ipchk1:	lodsw
	adc	bx,ax			! add checksum
	loop	ipchk1
	adc	bx,#0			! add carry
	not	bx
	mov	ax,bx			! prepare return value
	pop	si
	pleave
	ret


!
!**************************************************************************
!
	end

