/* LinPopUp - A Linux enhanced port of Winpopup, running over Samba.
 * By Jean-Marc Jacquet <littleigloo@chez.com> 
 * Copyright (C) 1998 Little Igloo Org  http://www.chez.com/littleigloo
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <stdio.h>
#include <string.h>
#include <ctype.h>


char *
strexpand (char *string, char *search_string, char *replace_string)
{
  int string_index = 0, sub_index, string_len;
  char sub_string[50], new_string[2048];

  string_len = strlen (string);
  strcpy (new_string, "");
  do
    {
      sub_index = 0;
      strcpy (sub_string, "");
      while ((string[string_index]) && (string[string_index] != 32))
	sub_string[sub_index++] = string[string_index++];
      sub_string[sub_index] = 0;
      if (!strcmp (sub_string, search_string))
	strcpy (sub_string, replace_string);
      strcat (new_string, sub_string);
      strcat (new_string, " ");
    }
  while (++string_index < string_len);

  strcpy (string, new_string);
  string[strlen (string) - 1] = 0;
  return string;
}

char *
strupr (char *string)
{
  register int f;

  for (f = 0; f < strlen (string); f++)
    if (islower (string[f]))
      string[f] = toupper (string[f]);
  return string;
}
