/*
 * Routines within this files are Copyright Colten Edwards 1996
 * Aka panasync on irc.
 * Thanks to Shiek and Flier for helpful hints and suggestions. As well 
 * as code in some cases.
 */
 
#include "irc.h"
#include "struct.h"
#include <sys/stat.h>

#if defined(_ALL_SOURCE) || defined(__EMX__)
#include <termios.h>
#else
#include <sys/termios.h>
#endif
#include <sys/ioctl.h>


#ifdef HAVE_UNAME
#include <sys/utsname.h>
#endif

#include "parse.h"
#include "server.h"
#include "chelp.h"
#include "commands.h"
#include "crypt.h"
#include "vars.h"
#include "ircaux.h"
#include "lastlog.h"
#include "log.h"
#include "window.h"
#include "screen.h"
#include "ircterm.h"
#include "who.h"
#include "hook.h"
#include "input.h"
#include "ignore.h"
#include "keys.h"
#include "names.h"
#include "alias.h"
#include "history.h"
#include "funny.h"
#include "ctcp.h"
#include "dcc.h"
#include "output.h"
#include "exec.h"
#include "notify.h"
#include "numbers.h"
#include "status.h"
#include "if.h"
#include "help.h"
#include "stack.h"
#include "queue.h"
#include "timer.h"
#include "list.h"
#include "misc.h"
#include "userlist.h"
#include "whowas.h"
#include "window.h"
#include "flood.h"
#include "hash2.h"
#include "notice.h"
#include "who.h"


void    toggle_reverse_status(Window *, char *, int);

#ifdef __EMXPM__

	void font_dialog(HWND hwnd);
#endif

MenuStruct *morigin = NULL;
int globalmenuid=5000;

#define         PMBXSUBMENU     0
#define         PMBXMENUITEM    1
#define         PMBXIAMENUITEM  2
#define		PMBXSEPARATOR	3





char *org_nick = NULL;

static int delay_gain_nick (void *);
extern int	MODE_TOPIC, MODE_MODERATED, MODE_ANONYMOUS, MODE_INVITE, 
		MODE_MSGS, MODE_SECRET, MODE_PRIVATE, MODE_KEY, MODE_LIMIT;

BUILT_IN_COMMAND(nwhois)
{
ChannelList *tmp;
NickList *user = NULL;
int once = 0;
char *nick = NULL;
int mem_use = 0, max_mem = 0;
int server = from_server;
char *arg = NULL, *t = NULL;
int all = 0;
int to_chan = 0;

	if (server == -1 || !(tmp = server_list[server].chan_list))
	{
		bitchsay("No Channel or no server");
		return;
	}

	if (args && *args)
		t = arg = m_strdup(args);
	else
	{
		all = 1;
		nick = get_current_channel_by_refnum(0);
	}		
	
	while (all || (nick = next_arg(arg, &arg)))
	{
		tmp = server_list[server].chan_list;
		while (tmp)
		{
			if ((all || (nick && (to_chan = is_channel(nick)))) && my_stricmp(tmp->channel, nick))
			{
				tmp = tmp->next;
				continue;
			} 
			for (user = next_nicklist(tmp, NULL); user; user = next_nicklist(tmp, user))
			{
				if (all || to_chan || wild_match(nick, user->nick))
				{
					if (!once)
					{
						put_it("%s", convert_output_format("%G$[7]0    @ v  UL: l   a  p  SL: l      +o   -o   +b   -b  kicks  nicks   pub", "%s", (all || to_chan)?/*"Channel"*/tmp->channel:"Nick"));
#ifdef ONLY_STD_CHARS
						put_it("%s", convert_output_format("------------------------------------------------------------------------------", NULL, NULL));
#else
						put_it("%s", convert_output_format("", NULL, NULL));
#endif
						once++;
					}
					put_it("%s", convert_output_format("$[10]0 %C$1 $2%w      %B$[3]3 $[2]4 $[2]5     %R$[6]6  %M$[4]7 $[4]8 $[4]9 $[4]10$[-4]11  $[-4]12 $[-6]13", 
						"%s %c %c %d %d %d %d %d %d %d %d %d %d %d",
						to_chan ? tmp->channel: user->nick, user->chanop? '@':'',user->voice?'v':'',
						0,0,0, user->shitlist?user->shitlist->level: 0,
						user->stat_ops,user->stat_dops, user->stat_bans, user->stat_unbans, 
						user->stat_kicks, user->stat_nicks, user->stat_pub));
					mem_use += sizeof(NickList) + (user->userlist ? sizeof(UserList) : 0) + (user->shitlist ? sizeof(ShitList):0);
					if (max_mem < mem_use)
						max_mem = mem_use;
					if (!all)
						break;
				}
			}				
			tmp = tmp->next;
		}
		if (once && nick)
			put_it("%s", convert_output_format("$G End /NWhoIs list for $1- [Mem Usage: $0 bytes per chan]", "%d %s", max_mem, (all||to_chan) ? "All":nick));
		if (all)
			break;
	}
	if (!all && !once)
		put_it("%s", convert_output_format("$G No such nick or channel", NULL, NULL));
	new_free(&t);
}

BUILT_IN_COMMAND(whowas)
{
	
	if (!command)
		show_whowas();
	else
		show_wholeft(NULL);
}

BUILT_IN_COMMAND(add_ban_word)
{
char *word = NULL;
char *chan = NULL;
WordKickList *new;

	
	if (args && *args)
	{
		chan = next_arg(args, &args);
		if ((!is_channel(chan) && (chan && *chan != '*')) || !args || !*args)
		{
			userage(command ? command : "BanWords", helparg);
			return;
		}
		if (!command)
		{
			new = (WordKickList *)find_in_list((List **)&ban_words, args, 0);
			if (!ban_words || !new || (new && !wild_match(new->channel, chan)))
			{
				new = (WordKickList *) new_malloc(sizeof(WordKickList));
				malloc_strcpy(&new->channel, chan);
				malloc_strcpy(&new->string, args);
				add_to_list((List **)&ban_words, (List *)new);
				bitchsay("Added %s to %s Banned Word List", new->string, new->channel);
			} else bitchsay("[%s] is already in the list for channel %s", args, chan);
		}
		else
		{
			malloc_strcpy(&word, args);
			if ((new = (WordKickList *) remove_from_list((List **)&ban_words, word)))
			{
				bitchsay("Removed %s Banned Word [%s]", new->channel, new->string);
				new_free(&new->channel);
				new_free(&new->string);
				new_free((char **)&new);
			} else 
				bitchsay("Banned Word %s not found.", word);
			new_free(&word);
		}
	} else
		userage(command ? command : "BanWords", helparg);
}

BUILT_IN_COMMAND(show_word_kick)
{
WordKickList *new;

	
	if (ban_words) 
	{
		put_it("%14s %40s", "Channel", "Banned Word(s)");
		for (new = ban_words; new; new = new->next)
			put_it("%-14s %40s", new->channel, new->string);
	} else
		bitchsay("No Banned Words on list");
}

void save_banwords(FILE *outfile)
{
	int count = 0;
	WordKickList *new;

	
	if (ban_words)
	{
		fprintf(outfile, "# %s Banned Words\n", version);
		for (new = ban_words; new; new = new->next)
		{
			fprintf(outfile, "BANWORD %s %s\n", new->channel, new->string);
			count++;
		}
	}
	if (count && do_hook(SAVEFILE_LIST,"BanWords %d", count))
		bitchsay("Saved %d Banned Words List", count);
}

#if 0
static char *recreate_saymode(ChannelList *chan)
{
static char mode_str[] = "iklmnpsta";
static char buffer[BIG_BUFFER_SIZE/4+1];
int mode_pos = 0;
int mode;
char *s;

	
        buffer[0] = '\0';
        s = buffer;
        mode = chan->modelock_val;
	while (mode)
	{
		if (mode % 2)
			*s++ = mode_str[mode_pos];
		mode /= 2;
		mode_pos++;
	}
	if (chan->key && *chan->key)
	{
		*s++ = ' ';
		strcpy(s, chan->key);
		s += strlen(chan->key);
	}
	if (chan->limit)
		sprintf(s, " %d", chan->limit);
	else
		*s = '\0';
	return buffer;
}
#endif

int check_mode_lock(char *channel, char *mode_list, int server)
{
ChannelList *chan;
char buffer[BIG_BUFFER_SIZE+1];
	
	if ((chan = lookup_channel(channel, server, 0)) && chan->modelock_key)
	{
		char *newmode;
		char *modelock = NULL;
		char *new_mode_list = NULL;
		char *save, *save1;
		char *args = NULL, *args1 = NULL;
		int add = 0;
		memset(buffer, 0, sizeof(buffer));
		
		
		malloc_strcpy(&modelock, chan->modelock_key);
		malloc_strcpy(&new_mode_list, mode_list);
		save1 = new_mode_list;
		save = modelock;
		new_mode_list = next_arg(new_mode_list, &args1);
		modelock = next_arg(modelock, &args);		

		while (*modelock)
		{
			newmode = strchr(mode_list, *modelock);
			switch(*modelock)
			{
				case '+':
					add = 1;
					break;
				case '-':
					add = 0;
					break;
				case 'k':
					if (newmode)
					{
						if (add)
						{
							char *key;
							key = next_arg(args1, &args1);
							if (chan->key)
							{
								strcat(buffer, "-k " );
								strcat(buffer, chan->key);
							}
							key = next_arg(args, &args);
							if (key)
							{
								strcat(buffer, " +k ");
								strcat(buffer, key);
								strcat(buffer, " ");
							}
						}
						else
						{
							if (!chan->key)
								break;
							strcat(buffer, "-k ");
							strcat(buffer, chan->key);
						}
						strcat(buffer, " ");
					}
					break;
				case 'l':
					if (newmode)
					{
						if (add)
						{
							int limit = 0;
							if (args && *args)
								limit = strtoul(args, &args, 10);
							if (limit > 0)
							{
								strcat(buffer, "+l ");
								strcat(buffer, ltoa(limit));
								strcat(buffer, " ");
							}
						}
						else
						{
							chan->limit = 0;
							strcat(buffer, "-l");
						}
					}
					break;
				default:
					if (newmode)
					{
						if (add)
						{
							strcat(buffer, "+");
						}
						else
						{
							strcat(buffer, "-");
						}
						buffer[strlen(buffer)] = *modelock;
						strcat(buffer, " ");
					}
					break;
			}
			modelock++;
		}
		if (chan && chan->chop && buffer)
			send_to_server("MODE %s %s", chan->channel, buffer);
		new_free(&save);
		new_free(&save1);
		return 1;
	}
	return 0;
}

BUILT_IN_COMMAND(mode_lock)
{
ChannelList *chan;
int i = 0;
char *channel = NULL;
u_long mode = 0;
int value = 0;

char *t = NULL;
char *key = NULL;

	
	if (command && *command && !strcmp(command, "ModeLock"))
	{
		if (!args || !*args)
		{
			userage(command, helparg);
			return;
		}
		t = next_arg(args, &args);
		if (is_channel(t))
		{
			channel = t;		
			t = next_arg(args, &args);
		} else
			channel = get_current_channel_by_refnum(0);
		if (!t || !*t)
		{
			bitchsay("No Mode Specified");
			return;
		}
		if ((chan = lookup_channel(channel, from_server, 0)))
		{
			char valid_mode[BIG_BUFFER_SIZE + 1];
			char *buffer = NULL;
			int limit = -1;
			int add = 0;
			memset(valid_mode, 0, sizeof(valid_mode));
			while (*t && i < BIG_BUFFER_SIZE)
			{
				switch(*t)
				{
					case '+':
						add = 1;
						valid_mode[i++] = '+';
						break;
					case '-':
						add = 0;
						valid_mode[i++] = '-';
						break;
					case 'm':
						value = MODE_MODERATED;
						valid_mode[i++] = *t;
						break;
					case 'a':
						value = MODE_ANONYMOUS;
						valid_mode[i++] = *t;
						break;
					case 'i':
						value = MODE_INVITE;
						valid_mode[i++] = *t;
						break;
					case 'n':
						value = MODE_MSGS;
						valid_mode[i++] = *t;
						break;
					case 's':
						value = MODE_SECRET;
						valid_mode[i++] = *t;
						break;
					case 't':
						value = MODE_TOPIC;
						valid_mode[i++] = *t;
						break;
					case 'p':
						value = MODE_PRIVATE;
						valid_mode[i++] = *t;
						break;
					case 'k':
						value = MODE_KEY;
						valid_mode[i++] = *t;
						if (add)
							key = next_arg(args, &args);
						else
							key = NULL;
						break;
						
					case 'l':
						valid_mode[i++] = *t;
						value = MODE_LIMIT;
						if (add)
						{
							if (args && *args)
								limit = strtoul(args, &args, 10);
						}
						else
							limit = 0;
						break;
					default:
						break;
				}
				if (add)
					mode |= value;
				else
					mode &= ~value;
		
				t++;
			}
			chan->modelock_val = mode;
			malloc_strcpy(&buffer, valid_mode);
			if (key && *key)
			{
				malloc_strcat(&buffer, " ");
				malloc_strcat(&buffer, key);
			}
			if (limit > 0)
			{
				malloc_strcat(&buffer, " ");
				malloc_strcat(&buffer, ltoa(limit));
			}
			if (*buffer)
			{
				malloc_strcpy(&chan->modelock_key, buffer);
				bitchsay("%s Mode Locked at: [%s] %s", chan->channel, buffer, (chan->limit > 0) ? "Users":"");
			} else
				bitchsay("Invalid Mode for [%s]", chan->channel);
		} else
			bitchsay("No Such Channel");
	}
	else if (command && *command && !my_stricmp(command, "ClearLock"))
	{

		if (!args || !*args)
		{
			userage(command, helparg);
			return;
		}
		t = next_arg(args, &args);
		if (t && *t && *t != '*')
		{
			if ((chan = lookup_channel(t, from_server, 0)))
			{
				new_free(&chan->modelock_key);
				chan->modelock_val = 0;
				bitchsay("Cleared %s Mode Lock", chan->channel);
			} else
				bitchsay("No such Channel [%s]", t);
		} 
		else if (t && *t && *t == '*')
		{
			for (chan = server_list[from_server].chan_list; chan; chan = chan->next)
			{
				new_free(&chan->modelock_key);
				chan->modelock_val = 0;
			}
			bitchsay("Cleared All Channel Mode Locks");
		} else
			userage(command, helparg);
	}
	else
	{
		for (i = 0; i < number_of_servers; i++ )
		{
			for (chan = server_list[i].chan_list; chan; chan = chan->next)
				bitchsay("Lock on %s: %s", chan->channel, chan->modelock_key ? chan->modelock_key : "none");
		}
	}
}

BUILT_IN_COMMAND(randomnick)
{
char *prefix = NULL, *p;
int count = 1;
int len = 0;

	
	while ((p = next_arg(args, &args)))
	{
		if (isdigit(*p))
			count = atol(p);
		else
			prefix = p;
	}
	if (prefix && (len = strlen(prefix)))
	{
		if (len > 5)
			*(prefix + 6) = 0;
	}
	while (count > 0)
	{
		send_to_server("NICK %s%s", prefix?prefix:"", random_str(3,9-len));
		count--;
	}
}

BUILT_IN_COMMAND(topic_lock)
{
ChannelList *chan;
char *t, *channel;

	
	if (!args || !*args)
	{
		userage(command, helparg);
		return;
	}
	t = next_arg(args, &args);
	if (args && *args)
	{
		channel = make_channel(t);
		if (!is_channel(channel))
			return;
		t = next_arg(args, &args);
	} else 
		channel = get_current_channel_by_refnum(0);
		
	if ((chan = lookup_channel(channel, from_server, 0)))
	{
		if (t && *t && !my_stricmp(t, "ON"))
		{
			chan->topic_lock = 1;
		}
		else if (t && *t && !my_strnicmp(t, "OF", 2))
			chan->topic_lock = 0;
		else
			userage(command, helparg);
		bitchsay("Topic lock for [%s] - %s", chan->channel, on_off(chan->topic_lock));
	}
}

BUILT_IN_COMMAND(sping)
{
	char *servern = next_arg(args, &args);
#ifdef HAVE_GETTIMEOFDAY
	struct timeval in_sping = {0};
#else
	time_t in_sping = 0;
#endif


	
	if (!servern || !*servern)
		if (!(servern = get_server_itsname(from_server)))
			servern = get_server_name(from_server);
	if (servern && *servern && wild_match("*.*", servern))
	{
		bitchsay("Sent server ping to [\002%s\002]", servern);
		if (!my_stricmp(servern, get_server_name(from_server)) || !my_stricmp(servern, get_server_itsname(from_server)))
		{
#ifdef HAVE_GETTIMEOFDAY
			gettimeofday(&in_sping, NULL);
			send_to_server("PING LAG%ld.%ld :%s", in_sping.tv_sec, in_sping.tv_usec, servern);
#else
			in_sping = time(NULL);
			send_to_server("PING LAG%ld :%s", in_sping, servern);
#endif
		}
		else
		{
#ifdef HAVE_GETTIMEOFDAY
			gettimeofday(&server_list[from_server].in_sping, NULL);
#else
			server_list[from_server].in_sping = time(NULL);
#endif
			send_to_server("PING %s :%s", get_server_itsname(from_server), servern);
		}
	}
	else
		userage(command, helparg);
}

BUILT_IN_COMMAND(tog_fprot)
{
static int here = 0;

	
	if (args && *args)
	{
		if (!my_stricmp(args, "ON"))
			here = 0;
		else if (!my_stricmp(args, "OFF"))
			here = 1;
		else
		{
			userage(command, helparg);
			return;
		}
	}		

	if (here)
	{
		set_int_var(CTCP_FLOOD_PROTECTION_VAR, 0);
		set_int_var(FLOOD_PROTECTION_VAR, 0);
		here = 0;
	} else
	{
		set_int_var(CTCP_FLOOD_PROTECTION_VAR, 1);
		set_int_var(FLOOD_PROTECTION_VAR, 1);
		here = 1;
	}
	bitchsay("Toggled flood protection - [%s]", on_off(here));
}

BUILT_IN_COMMAND(do_toggle)
{
#ifndef BITCHX_LITE
if (!args || !*args)
{
#ifdef ONLY_STD_CHARS

put_it("%s", convert_output_format("%G-----------%K[ %WBitchX %wToggles %K]%G----------------------------------------------", NULL));
put_it("%s", convert_output_format("%G|   %Cauto_ns%clookup %K[%W$[-3]0%K]    %Cctcp_f%clood_protection %K[%W$[-3]1%K]    %Cbeep%c        %K[%W$[-3]2%K]", "%s %s %s", on_off(get_int_var(AUTO_NSLOOKUP_VAR)), on_off(get_int_var(CTCP_FLOOD_PROTECTION_VAR)), on_off(get_int_var(BEEP_VAR))));
put_it("%s", convert_output_format("%G|   %Cpub%cflood      %K[%W$[-3]0%K]    %Cflood_p%crotection      %K[%W$[-3]1%K]    %Ckickf%clood   %K[%W$[-3]2%K]", "%s %s %s", on_off(get_int_var(PUBFLOOD_VAR)), on_off(get_int_var(FLOOD_PROTECTION_VAR)), on_off(get_int_var(KICKFLOOD_VAR))));
put_it("%s", convert_output_format("%G|   %Cdcc_a%cutoget   %K[%W$[-3]0%K]    %Cflood_k%cick            %K[%W$[-3]1%K]    %Cmsg%clog      %K[%W$[-3]2%K]", "%s %s %s", on_off(get_int_var(DCC_AUTOGET_VAR)), on_off(get_int_var(FLOOD_KICK_VAR)), on_off(get_int_var(MSGLOG_VAR))));
put_it("%s", convert_output_format("%G|   %Cll%cook         %K[%W$[-3]0%K]    %Cdeop%cflood             %K[%W$[-3]1%K]    %Cjoin%cflood   %K[%W$[-3]2%K]", "%s %s %s", on_off(get_int_var(LLOOK_VAR)), on_off(get_int_var(DEOPFLOOD_VAR)), on_off(get_int_var(JOINFLOOD_VAR))));
put_it("%s", convert_output_format("%G|   %Cauto_w%chowas   %K[%W$[-3]0%K]    %Cverb%cose_ctcp          %K[%W$[-3]1%K]    %Cnickfl%cood   %K[%W$[-3]2%K]", "%s %s %s", on_off(get_int_var(AUTO_WHOWAS_VAR)), on_off(get_int_var(CTCP_VERBOSE_VAR)), on_off(get_int_var(NICKFLOOD_VAR))));
put_it("%s", convert_output_format("%G|   %Ccl%coak         %K[%W$[-3]0%K]    %Coper%cview              %K[%W$[-3]1%K]    %Cshit%clist    %K[%W$[-3]2%K]", "%s %s %s", on_off(get_int_var(CLOAK_VAR)), on_off(get_int_var(OV_VAR)), on_off(get_int_var(SHITLIST_VAR))));
put_it("%s", convert_output_format("%G|   %Ckick_o%cps      %K[%W$[-3]0%K]    %Cannoy%c_kick            %K[%W$[-3]1%K]    %Cuser%clist    %K[%W$[-3]2%K]", "%s %s %s", on_off(get_int_var(KICK_OPS_VAR)), on_off(get_int_var(ANNOY_KICK_VAR)), on_off(get_int_var(USERLIST_VAR))));
put_it("%s", convert_output_format("%G|   %Chack%cing       %K[%W$[-3]0%K]    %Cnick_c%completion       %K[%W$[-3]1%K]    %Cauto_r%cejoin %K[%W$[-3]2%K]","%s %s %s", on_off(get_int_var(HACKING_VAR)),on_off(get_int_var(NICK_COMPLETION_VAR)), on_off((get_int_var(AUTO_REJOIN_VAR)?1:0)) ));
put_it("%s", convert_output_format("%K|   %Caop           %K[%W$[-3]0%K]    %Cauto_aw%cay             %K[%W$[-3]1%K]    %Cauto_rec%conn %K[%W$[-3]2%K]", "%s %s %s", on_off((get_int_var(AOP_VAR))),on_off((get_int_var(AUTO_AWAY_VAR))), on_off(get_int_var(AUTO_RECONNECT_VAR))));
put_it("%s", convert_output_format("%K|   %Cbitch         %K[%W$[-3]0%K]    %Cdcc_f%cast              %K[%W$[-3]1%K]    %Ckick_if_ban %K[%W$[-3]2%K]", "%s %s %s", on_off((get_int_var(BITCH_VAR))),on_off((get_int_var(DCC_FAST_VAR))), on_off(get_int_var(KICK_IF_BANNED_VAR))));
put_it("%s", convert_output_format("%g|   %Cftp_g%crab      %K[%W$[-3]0%K]    %Cmircs                 %K[%W$[-3]1%K]    %Chttp%c_grab   %K[%W$[-3]2%K]", "%s %s", on_off((get_int_var(FTP_GRAB_VAR))),on_off((get_int_var(MIRCS_VAR))),on_off((get_int_var(HTTP_GRAB_VAR))) ));
put_it("%s", convert_output_format("%G|   %Cdisp%clay_ansi  %K[%W$[-3]0%K]    %Wtype /toggle <setting>         %Clog         %K[%W$[-3]1%K]", "%s %s", on_off((get_int_var(DISPLAY_ANSI_VAR))),on_off((get_int_var(LOG_VAR))) ));

#else

put_it("%s", convert_output_format("%G---%g%G-%K[ %WBitchX %wToggles %K]-%g%G-%g---%K%g--%K%g-%K--- --  - --- -- -", NULL));
put_it("%s", convert_output_format("%G   %Cauto_ns%clookup %K[%W$[-3]0%K]    %Cctcp_f%clood_protection %K[%W$[-3]1%K]    %Cbeep%c        %K[%W$[-3]2%K]", "%s %s %s", on_off(get_int_var(AUTO_NSLOOKUP_VAR)), on_off(get_int_var(CTCP_FLOOD_PROTECTION_VAR)), on_off(get_int_var(BEEP_VAR))));
put_it("%s", convert_output_format("%G   %Cpub%cflood      %K[%W$[-3]0%K]    %Cflood_p%crotection      %K[%W$[-3]1%K]    %Ckickf%clood   %K[%W$[-3]2%K]", "%s %s %s", on_off(get_int_var(PUBFLOOD_VAR)), on_off(get_int_var(FLOOD_PROTECTION_VAR)), on_off(get_int_var(KICKFLOOD_VAR))));
put_it("%s", convert_output_format("%g   %Cdcc_a%cutoget   %K[%W$[-3]0%K]    %Cflood_k%cick            %K[%W$[-3]1%K]    %Cmsg%clog      %K[%W$[-3]2%K]", "%s %s %s", on_off(get_int_var(DCC_AUTOGET_VAR)), on_off(get_int_var(FLOOD_KICK_VAR)), on_off(get_int_var(MSGLOG_VAR))));
put_it("%s", convert_output_format("%G   %Cll%cook         %K[%W$[-3]0%K]    %Cdeop%cflood             %K[%W$[-3]1%K]    %Cjoin%cflood   %K[%W$[-3]2%K]", "%s %s %s", on_off(get_int_var(LLOOK_VAR)), on_off(get_int_var(DEOPFLOOD_VAR)), on_off(get_int_var(JOINFLOOD_VAR))));
put_it("%s", convert_output_format("%g|   %Cauto_w%chowas   %K[%W$[-3]0%K]    %Cverb%cose_ctcp          %K[%W$[-3]1%K]    %Cnickfl%cood   %K[%W$[-3]2%K]", "%s %s %s", on_off(get_int_var(AUTO_WHOWAS_VAR)), on_off(get_int_var(CTCP_VERBOSE_VAR)), on_off(get_int_var(NICKFLOOD_VAR))));
put_it("%s", convert_output_format("%G:   %Ccl%coak         %K[%W$[-3]0%K]    %Coper%cview              %K[%W$[-3]1%K]    %Cshit%clist    %K[%W$[-3]2%K]", "%s %s %s", on_off(get_int_var(CLOAK_VAR)), on_off(get_int_var(OV_VAR)), on_off(get_int_var(SHITLIST_VAR))));
put_it("%s", convert_output_format("%G:   %Ckick_o%cps      %K[%W$[-3]0%K]    %Cannoy%c_kick            %K[%W$[-3]1%K]    %Cuser%clist    %K[%W$[-3]2%K]", "%s %s %s", on_off(get_int_var(KICK_OPS_VAR)), on_off(get_int_var(ANNOY_KICK_VAR)), on_off(get_int_var(USERLIST_VAR))));
put_it("%s", convert_output_format("%K|   %Chack%cing       %K[%W$[-3]0%K]    %Cnick_c%completion       %K[%W$[-3]1%K]    %Cauto_rej%coin %K[%W$[-3]2%K]", "%s %s %s", on_off(get_int_var(HACKING_VAR)),on_off(get_int_var(NICK_COMPLETION_VAR)), on_off((get_int_var(AUTO_REJOIN_VAR)?1:0)) ));
put_it("%s", convert_output_format("%K:   %Caop           %K[%W$[-3]0%K]    %Cauto_aw%cay             %K[%W$[-3]1%K]    %Cauto_rec%conn %K[%W$[-3]2%K]", "%s %s %s", on_off((get_int_var(AOP_VAR)?1:0)),on_off((get_int_var(AUTO_AWAY_VAR))), on_off(get_int_var(AUTO_RECONNECT_VAR))));
put_it("%s", convert_output_format("%K:   %Cbitch         %K[%W$[-3]0%K]    %Cdcc_f%cast              %K[%W$[-3]1%K]    %Ckick_if_ban %K[%W$[-3]2%K]", "%s %s %s", on_off((get_int_var(BITCH_VAR))),on_off((get_int_var(DCC_FAST_VAR))), on_off(get_int_var(KICK_IF_BANNED_VAR))));
put_it("%s", convert_output_format("%g:   %Cftp_g%crab      %K[%W$[-3]0%K]    %Cmircs                 %K[%W$[-3]1%K]    %Chttp%c_grab   %K[%W$[-3]2%K]", "%s %s %s", on_off((get_int_var(FTP_GRAB_VAR))),on_off((get_int_var(MIRCS_VAR))),on_off((get_int_var(HTTP_GRAB_VAR))) ));
put_it("%s", convert_output_format("%K:   %Cdisp%clay_ansi  %K[%W$[-3]0%K]    %Wtype /toggle <setting>         %Clog         %K[%W$[-3]1%K]", "%s %s", on_off((get_int_var(DISPLAY_ANSI_VAR))),on_off((get_int_var(LOG_VAR))) ));

#endif
} 
else
{
	char *arg;
	while ((arg = next_arg(args, &args)))
	{
		int var = -1;
		char *str = NULL;
		upper(arg);
		
		if (!my_strnicmp(arg, "auto_nslookup", 7))
		{
			var = AUTO_NSLOOKUP_VAR;
			str = "$G %cToggled %GAuto-NSlookup %K[%W$[-3]0%K]";
		} else if (!my_strnicmp(arg, "pubflood", 3))
		{
			var = PUBFLOOD_VAR;
			str = "$G %cToggled %GPub Flood %K[%W$[-3]0%K]";
		} else if (!my_strnicmp(arg, "dcc_autoget", 5))
		{
			var = DCC_AUTOGET_VAR;
			str = "$G %cToggled %GDCC Auto Get %K[%W$[-3]0%K]";
		} else if (!my_strnicmp(arg, "llook", 2))
		{
			var = LLOOK_VAR;
			str = "$G %cToggled %GLink Look %K[%W$[-3]0%K]";
		} else if (!my_strnicmp(arg, "auto_whowas", 6))
		{
			var = AUTO_WHOWAS_VAR;
			str = "$G %cToggled %GAuto-WhoWas %K[%W$[-3]0%K]";
		} else if (!my_strnicmp(arg, "cloak", 2))
		{
			var = CLOAK_VAR;
			str = "$G %cToggled %GCloaking %K[%W$[-3]0%K]";
		} else if (!my_strnicmp(arg, "kick_ops", 6))
		{
			var = KICK_OPS_VAR;
			str = "$G %cToggled %GKick Ops %K[%W$[-3]0%K]";
		} else if (!my_strnicmp(arg, "ctcp_flood_protection", 6))
		{
			var = CTCP_FLOOD_PROTECTION_VAR;
			str = "$G %cToggled %GCtcp Flood Protection %K[%W$[-3]0%K]","%s";
		} else if (!my_strnicmp(arg, "flood_protection",7))
		{
			var = FLOOD_PROTECTION_VAR;
			str = "$G %cToggled %GFlood Protection %K[%W$[-3]0%K]";
		} else if (!my_strnicmp(arg, "flood_kick", 7))
		{
			var = FLOOD_KICK_VAR;
			str = "$G %cToggled %GFlood Kicks %K[%W$[-3]0%K]";
		} else if (!my_strnicmp(arg, "deopflood",4))
		{
			var = DEOPFLOOD_VAR;
			str = "$G %cToggled %GDeOp Flood %K[%W$[-3]0%K]";
		} else if (!my_strnicmp(arg, "verbose_ctcp",4))
		{
			var = CTCP_VERBOSE_VAR;
			str = "$G %cToggled %GVerbose CTCP %K[%W$[-3]0%K]";
		} else if (!my_strnicmp(arg, "operview", 4))
		{
			int ov_mode = get_int_var(OV_VAR);
			var = OV_VAR;
			setup_ov_mode(ov_mode, 0);
			str = "$G %cToggled %GOper View %K[%W$[-3]0%K]";
		} else if (!my_strnicmp(arg, "annoy_kick",4))
		{
			var = ANNOY_KICK_VAR;
			str = "$G %cToggled %GAnnoy Kicks %K[%W$[-3]0%K]";
		} else if (!my_strnicmp(arg, "beep",4))
		{
			var = BEEP_VAR;
			str = "$G %cToggled %GBeep %K[%W$[-3]0%K]";

		} else if (!my_strnicmp(arg, "kickflood",5))
		{
			var = KICKFLOOD_VAR;
			str = "$G %cToggled %GKick Flood %K[%W$[-3]0%K]","%s";
		} else if (!my_strnicmp(arg, "msglog", 3))
		{
			var = MSGLOG_VAR;
			str = "$G %cToggled %GMSG log %K[%W$[-3]0%K]";
		} else if (!my_strnicmp(arg, "joinflood", 4))
		{
			var = JOINFLOOD_VAR;
			str = "$G %cToggled %GJoin Flood %K[%W$[-3]0%K]";
		} else if (!my_strnicmp(arg, "nickflood", 6))
		{
			var = NICKFLOOD_VAR;
			str = "$G %cToggled %GNick Flood %K[%W$[-3]0%K]";
		} else if (!my_strnicmp(arg, "shitlist", 4))
		{
			var = SHITLIST_VAR;
			str = "$G %cToggled %GShitList %K[%W$[-3]0%K]";
		} else if (!my_strnicmp(arg, "userlist", 4))
		{
			var = USERLIST_VAR;
			str = "$G %cToggled %GUserList %K[%W$[-3]0%K]";
		} else if (!my_strnicmp(arg, "hacking", 4))
		{
			var = HACKING_VAR;
			str = "$G %cToggled %GHacking %K[%W$[-3]0%K]";
		} else if (!my_strnicmp(arg, "auto_rejoin", 8))
		{
			var = AUTO_REJOIN_VAR;
			str = "$G %cToggled %GAuto_Rejoin %K[%W$[-3]0%K]","%s";
		} else if (!my_strnicmp(arg, "nick_completion", 6))
		{
			var = NICK_COMPLETION_VAR;
			str = "$G %cToggled %GNick Completion %K[%W$[-3]0%K]","%s";
		} else if (!my_strnicmp(arg, "aop", 3))
		{
			var = AOP_VAR;
			str = "$G %cToggled %GAOP %K[%W$[-3]0%K]";
		} else if (!my_strnicmp(arg, "auto_away", 7))
		{
			var = AUTO_AWAY_VAR;
			str = "$G %cToggled %GAuto Away %K[%W$[-3]0%K]";
		} else if (!my_strnicmp(arg, "auto_reconnect", 8))
		{
			var = AUTO_RECONNECT_VAR;
			str = "$G %cToggled %GAuto Reconnect %K[%W$[-3]0%K]";
		} else if (!my_strnicmp(arg, "mircs", 5))
		{
			var = MIRCS_VAR;
			str = "$G %cToggled %GmIRC Color %K[%W$[-3]0%K]";
		} else if (!my_strnicmp(arg, "bitch", 5))
		{
			var = BITCH_VAR;
			str = "$G %cToggled %GBitch %K[%W$[-3]0%K]";
		} else if (!my_strnicmp(arg, "dcc_fast", 5))
		{
			var = DCC_FAST_VAR;
			str = "$G %cToggled %GDCC fast %K[%W$[-3]0%K]";
		} else if (!my_strnicmp(arg, "kick_if_banned", 5))
		{
			var = KICK_IF_BANNED_VAR;
			str = "$G %cToggled %GKick banned Users %K[%W$[-3]0%K]";
		} else if (!my_strnicmp(arg, "ftp_grab", 5))
		{
			var = FTP_GRAB_VAR;
			str = "$G %cToggled %GFTP grab %K[%W$[-3]0%K]";
		} else if (!my_strnicmp(arg, "http_grab", 4))
		{
			var = HTTP_GRAB_VAR;
			str = "$G %cToggled %GHTTP grab %K[%W$[-3]0%K]";
		} else if (!my_strnicmp(arg, "display_ansi", 4))
		{
			set_int_var(DISPLAY_ANSI_VAR, get_int_var(DISPLAY_ANSI_VAR)?0:1);
			toggle_reverse_status(current_window, NULL, get_int_var(DISPLAY_ANSI_VAR));
			if (do_hook(SET_LIST, "%s %s", arg, on_off(get_int_var(DISPLAY_ANSI_VAR))))
				put_it("%s", convert_output_format("$G %cToggled %GAnsi Display %K[%W$[-3]0%K]", "%s", on_off(get_int_var(DISPLAY_ANSI_VAR)) ));
			set_input_prompt(current_window, empty_string, 0);
			set_input_prompt(current_window, get_string_var(INPUT_PROMPT_VAR), 0);
			status_update(1);
			continue;
		} else if (!my_strnicmp(arg, "log", 3))
		{
			int old_window_display = window_display;
			var = LOG_VAR;
			str = "$G %cToggled %GLogging %K[%W$[-3]0%K]";
			window_display = 0;
			logger(current_window, NULL, get_int_var(LOG_VAR)?0:1);
			window_display = old_window_display;
		}
		if (var != -1)
			set_int_var(var, get_int_var(var)?0:1);
		if (str)
		{
			if (do_hook(SET_LIST, "%s %s", arg, on_off(get_int_var(var))))
				put_it("%s", convert_output_format(str, "%s", on_off(get_int_var(var)) ));
		}
		if (var == -1)
			bitchsay("Unknown /toggle [%s]", arg);
			
#if 0
		if (!my_strnicmp(arg, "auto_nslookup", 7))
		{
			set_int_var(AUTO_NSLOOKUP_VAR, (get_int_var(AUTO_NSLOOKUP_VAR)?0:1));
			if (do_hook(SET_LIST, "%s %s", arg, on_off(get_int_var(AUTO_NSLOOKUP_VAR))))
				put_it("%s", convert_output_format("%cToggled %GAuto-NSlookup %K[%W$[-3]0%K]","%s", on_off(get_int_var(AUTO_NSLOOKUP_VAR)) ));
		} else if (!my_strnicmp(arg, "pubflood", 3))
		{
			set_int_var(PUBFLOOD_VAR, (get_int_var(PUBFLOOD_VAR)?0:1));
			if (do_hook(SET_LIST, "%s %s", arg, on_off(get_int_var(PUBFLOOD_VAR))))
				put_it("%s", convert_output_format("%cToggled %GPub Flood %K[%W$[-3]0%K]","%s", on_off(get_int_var(PUBFLOOD_VAR))));
		} else if (!my_strnicmp(arg, "dcc_autoget", 5))
		{
			set_int_var(DCC_AUTOGET_VAR, (get_int_var(DCC_AUTOGET_VAR)?0:1));
			if (do_hook(SET_LIST, "%s %s", arg, on_off(get_int_var(DCC_AUTOGET_VAR))))
				put_it("%s", convert_output_format("%cToggled %GDCC Auto Get %K[%W$[-3]0%K]","%s", on_off(get_int_var(DCC_AUTOGET_VAR))));
		} else if (!my_strnicmp(arg, "llook", 2))
		{
			set_int_var(LLOOK_VAR, (get_int_var(LLOOK_VAR)?0:1));
			if (do_hook(SET_LIST, "%s %s", arg, on_off(get_int_var(LLOOK_VAR))))
				put_it("%s", convert_output_format("%cToggled %GLink Look %K[%W$[-3]0%K]","%s", on_off(get_int_var(LLOOK_VAR))));
		} else if (!my_strnicmp(arg, "auto_whowas", 6))
		{
			set_int_var(AUTO_WHOWAS_VAR, (get_int_var(AUTO_WHOWAS_VAR)?0:1));
			if (do_hook(SET_LIST, "%s %s", arg, on_off(get_int_var(AUTO_WHOWAS_VAR))))
				put_it("%s", convert_output_format("%cToggled %GAuto-WhoWas %K[%W$[-3]0%K]","%s", on_off(get_int_var(AUTO_WHOWAS_VAR))));
		} else if (!my_strnicmp(arg, "cloak", 2))
		{
			set_int_var(CLOAK_VAR, (get_int_var(CLOAK_VAR)?0:1));
			if (do_hook(SET_LIST, "%s %s", arg, on_off(get_int_var(CLOAK_VAR))))
				put_it("%s", convert_output_format("%cToggled %GCloaking %K[%W$[-3]0%K]","%s", on_off(get_int_var(CLOAK_VAR))));
		} else if (!my_strnicmp(arg, "kick_ops", 6))
		{
			set_int_var(KICK_OPS_VAR, (get_int_var(KICK_OPS_VAR)?0:1));
			if (do_hook(SET_LIST, "%s %s", arg, on_off(get_int_var(KICK_OPS_VAR))))
				put_it("%s", convert_output_format("%cToggled %GKick Ops %K[%W$[-3]0%K]","%s", on_off(get_int_var(KICK_OPS_VAR))));
		} else if (!my_strnicmp(arg, "ctcp_flood_protection", 6))
		{
			set_int_var(CTCP_FLOOD_PROTECTION_VAR, (get_int_var(CTCP_FLOOD_PROTECTION_VAR)?0:1));
			if (do_hook(SET_LIST, "%s %s", arg, on_off(get_int_var(CTCP_FLOOD_PROTECTION_VAR))))
				put_it("%s", convert_output_format("%cToggled %GCtcp Flood Protection %K[%W$[-3]0%K]","%s", on_off(get_int_var(CTCP_FLOOD_PROTECTION_VAR))));
		} else if (!my_strnicmp(arg, "flood_protection",7))
		{
			set_int_var(FLOOD_PROTECTION_VAR, (get_int_var(FLOOD_PROTECTION_VAR)?0:1));
			if (do_hook(SET_LIST, "%s %s", arg, on_off(get_int_var(FLOOD_PROTECTION_VAR))))
				put_it("%s", convert_output_format("%cToggled %GFlood Protection %K[%W$[-3]0%K]","%s", on_off(get_int_var(FLOOD_PROTECTION_VAR))));
		} else if (!my_strnicmp(arg, "flood_kick", 7))
		{
			set_int_var(FLOOD_KICK_VAR, (get_int_var(FLOOD_KICK_VAR)?0:1));
			if (do_hook(SET_LIST, "%s %s", arg, on_off(get_int_var(FLOOD_KICK_VAR))))
				put_it("%s", convert_output_format("%cToggled %GFlood Kicks %K[%W$[-3]0%K]","%s", on_off(get_int_var(FLOOD_KICK_VAR))));
		} else if (!my_strnicmp(arg, "deopflood",4))
		{
			set_int_var(DEOPFLOOD_VAR, (get_int_var(DEOPFLOOD_VAR)?0:1));
			if (do_hook(SET_LIST, "%s %s", arg, on_off(get_int_var(DEOPFLOOD_VAR))))
				put_it("%s", convert_output_format("%cToggled %GDeOp Flood %K[%W$[-3]0%K]","%s", on_off(get_int_var(DEOPFLOOD_VAR))));
		} else if (!my_strnicmp(arg, "verbose_ctcp",4))
		{
			set_int_var(CTCP_VERBOSE_VAR, (get_int_var(CTCP_VERBOSE_VAR)?0:1));
			if (do_hook(SET_LIST, "%s %s", arg, on_off(get_int_var(CTCP_VERBOSE_VAR))))
				put_it("%s", convert_output_format("%cToggled %GVerbose CTCP %K[%W$[-3]0%K]","%s", on_off(get_int_var(CTCP_VERBOSE_VAR))));
		} else if (!my_strnicmp(arg, "operview", 4))
		{
			int ov_mode = get_int_var(OV_VAR);
			setup_ov_mode(ov_mode, 0);
			set_int_var(OV_VAR, ov_mode ? 0 : 1);
			if (do_hook(SET_LIST, "%s %s", arg, on_off(get_int_var(OV_VAR))))
				put_it("%s", convert_output_format("%cToggled %GOper View %K[%W$[-3]0%K]","%s", on_off(get_int_var(OV_VAR))));
		} else if (!my_strnicmp(arg, "annoy_kick",4))
		{
			set_int_var(ANNOY_KICK_VAR, (get_int_var(ANNOY_KICK_VAR)?0:1));
			if (do_hook(SET_LIST, "%s %s", arg, on_off(get_int_var(ANNOY_KICK_VAR))))
				put_it("%s", convert_output_format("%cToggled %GAnnoy Kicks %K[%W$[-3]0%K]","%s", on_off(get_int_var(ANNOY_KICK_VAR))));
		} else if (!my_strnicmp(arg, "beep",4))
		{
			set_int_var(BEEP_VAR, (get_int_var(BEEP_VAR)?0:1));
			if (do_hook(SET_LIST, "%s %s", arg, on_off(get_int_var(BEEP_VAR))))
				put_it("%s", convert_output_format("%cToggled %GBeep %K[%W$[-3]0%K]","%s", on_off(get_int_var(BEEP_VAR))));

		} else if (!my_strnicmp(arg, "kickflood",5))
		{
			set_int_var(KICKFLOOD_VAR, (get_int_var(KICKFLOOD_VAR)?0:1));
			if (do_hook(SET_LIST, "%s %s", arg, on_off(get_int_var(KICKFLOOD_VAR))))
				put_it("%s", convert_output_format("%cToggled %GKick Flood %K[%W$[-3]0%K]","%s", on_off(get_int_var(KICKFLOOD_VAR))));
		} else if (!my_strnicmp(arg, "msglog", 3))
		{
			set_int_var(MSGLOG_VAR, (get_int_var(MSGLOG_VAR)?0:1));
			if (do_hook(SET_LIST, "%s %s", arg, on_off(get_int_var(MSGLOG_VAR))))
				put_it("%s", convert_output_format("%cToggled %GMSG log %K[%W$[-3]0%K]","%s", on_off(get_int_var(MSGLOG_VAR))));
		} else if (!my_strnicmp(arg, "joinflood", 4))
		{
			set_int_var(JOINFLOOD_VAR, (get_int_var(JOINFLOOD_VAR)?0:1));
			if (do_hook(SET_LIST, "%s %s", arg, on_off(get_int_var(JOINFLOOD_VAR))))
				put_it("%s", convert_output_format("%cToggled %GJoin Flood %K[%W$[-3]0%K]","%s", on_off(get_int_var(JOINFLOOD_VAR))));
		} else if (!my_strnicmp(arg, "nickflood", 6))
		{
			set_int_var(NICKFLOOD_VAR, (get_int_var(NICKFLOOD_VAR)?0:1));
			if (do_hook(SET_LIST, "%s %s", arg, on_off(get_int_var(NICKFLOOD_VAR))))
				put_it("%s", convert_output_format("%cToggled %GNick Flood %K[%W$[-3]0%K]","%s", on_off(get_int_var(NICKFLOOD_VAR))));
		} else if (!my_strnicmp(arg, "shitlist", 4))
		{
			set_int_var(SHITLIST_VAR, (get_int_var(SHITLIST_VAR)?0:1));
			if (do_hook(SET_LIST, "%s %s", arg, on_off(get_int_var(SHITLIST_VAR))))
				put_it("%s", convert_output_format("%cToggled %GShitList %K[%W$[-3]0%K]","%s", on_off(get_int_var(SHITLIST_VAR))));
		} else if (!my_strnicmp(arg, "userlist", 4))
		{
			set_int_var(USERLIST_VAR, (get_int_var(USERLIST_VAR)?0:1));
			if (do_hook(SET_LIST, "%s %s", arg, on_off(get_int_var(USERLIST_VAR))))
				put_it("%s", convert_output_format("%cToggled %GUserList %K[%W$[-3]0%K]","%s", on_off(get_int_var(USERLIST_VAR))));
		} else if (!my_strnicmp(arg, "hacking", 4))
		{
			set_int_var(HACKING_VAR, (get_int_var(HACKING_VAR)?0:1));
			if (do_hook(SET_LIST, "%s %s", arg, on_off(get_int_var(HACKING_VAR))))
				put_it("%s", convert_output_format("%cToggled %GHacking %K[%W$[-3]0%K]","%s", on_off(get_int_var(HACKING_VAR))));
		} else if (!my_strnicmp(arg, "auto_rejoin", 8))
		{
			set_int_var(AUTO_REJOIN_VAR, (get_int_var(AUTO_REJOIN_VAR)?0:1));
			if (do_hook(SET_LIST, "%s %s", arg, on_off(get_int_var(AUTO_REJOIN_VAR))))
				put_it("%s", convert_output_format("%cToggled %GAuto_Rejoin %K[%W$[-3]0%K]","%s", on_off(get_int_var(AUTO_REJOIN_VAR))));
		} else if (!my_strnicmp(arg, "nick_completion", 6))
		{
			set_int_var(NICK_COMPLETION_VAR, (get_int_var(NICK_COMPLETION_VAR)?0:1));
			if (do_hook(SET_LIST, "%s %s", arg, on_off(get_int_var(NICK_COMPLETION_VAR))))
				put_it("%s", convert_output_format("%cToggled %GNick Completion %K[%W$[-3]0%K]","%s", on_off(get_int_var(NICK_COMPLETION_VAR))));
		} else if (!my_strnicmp(arg, "aop", 3))
		{
			set_int_var(AOP_VAR, (get_int_var(AOP_VAR)?0:1));
			if (do_hook(SET_LIST, "%s %s", arg, on_off(get_int_var(AOP_VAR))))
				put_it("%s", convert_output_format("%cToggled %GAOP %K[%W$[-3]0%K]","%s", on_off(get_int_var(AOP_VAR))));
		} else if (!my_strnicmp(arg, "auto_away", 7))
		{
			set_int_var(AUTO_AWAY_VAR, (get_int_var(AUTO_AWAY_VAR)?0:1));
			if (do_hook(SET_LIST, "%s %s", arg, on_off(get_int_var(AUTO_AWAY_VAR))))
				put_it("%s", convert_output_format("%cToggled %GAuto Away %K[%W$[-3]0%K]","%s", on_off(get_int_var(AUTO_AWAY_VAR))));
		} else if (!my_strnicmp(arg, "auto_reconnect", 8))
		{
			set_int_var(AUTO_RECONNECT_VAR, (get_int_var(AUTO_RECONNECT_VAR)?0:1));
			if (do_hook(SET_LIST, "%s %s", arg, on_off(get_int_var(AUTO_RECONNECT_VAR))))
				put_it("%s", convert_output_format("%cToggled %GAuto Reconnect %K[%W$[-3]0%K]","%s", on_off(get_int_var(AUTO_RECONNECT_VAR))));
		} else if (!my_strnicmp(arg, "mircs", 5))
		{
			set_int_var(MIRCS_VAR, (get_int_var(MIRCS_VAR)?0:1));
			if (do_hook(SET_LIST, "%s %s", arg, on_off(get_int_var(MIRCS_VAR))))
				put_it("%s", convert_output_format("%cToggled %GmIRC Color %K[%W$[-3]0%K]","%s", on_off(get_int_var(MIRCS_VAR))));
		} else if (!my_strnicmp(arg, "bitch", 5))
		{
			set_int_var(BITCH_VAR, (get_int_var(BITCH_VAR)?0:1));
			if (do_hook(SET_LIST, "%s %s", arg, on_off(get_int_var(BITCH_VAR))))
				put_it("%s", convert_output_format("%cToggled %GBitch %K[%W$[-3]0%K]","%s", on_off(get_int_var(BITCH_VAR))));
		} else if (!my_strnicmp(arg, "dcc_fast", 5))
		{
			set_int_var(DCC_FAST_VAR, (get_int_var(DCC_FAST_VAR)?0:1));
			if (do_hook(SET_LIST, "%s %s", arg, on_off(get_int_var(DCC_FAST_VAR))))
				put_it("%s", convert_output_format("%cToggled %GDCC fast %K[%W$[-3]0%K]","%s", on_off(get_int_var(DCC_FAST_VAR))));
		} else if (!my_strnicmp(arg, "kick_if_banned", 5))
		{
			set_int_var(KICK_IF_BANNED_VAR, (get_int_var(KICK_IF_BANNED_VAR)?0:1));
			if (do_hook(SET_LIST, "%s %s", arg, on_off(get_int_var(KICK_IF_BANNED_VAR))))
				put_it("%s", convert_output_format("%cToggled %GKick banned Users %K[%W$[-3]0%K]","%s", on_off(get_int_var(KICK_IF_BANNED_VAR))));
		} else if (!my_strnicmp(arg, "ftp_grab", 5))
		{
			set_int_var(FTP_GRAB_VAR, (get_int_var(FTP_GRAB_VAR)?0:1));
			if (do_hook(SET_LIST, "%s %s", arg, on_off(get_int_var(FTP_GRAB_VAR))))
				put_it("%s", convert_output_format("%cToggled %GFTP grab %K[%W$[-3]0%K]","%s", on_off(get_int_var(FTP_GRAB_VAR))));
		} else if (!my_strnicmp(arg, "http_grab", 4))
		{
			set_int_var(HTTP_GRAB_VAR, (get_int_var(HTTP_GRAB_VAR)?0:1));
			if (do_hook(SET_LIST, "%s %s", arg, on_off(get_int_var(HTTP_GRAB_VAR))))
				put_it("%s", convert_output_format("%cToggled %GHTTP grab %K[%W$[-3]0%K]","%s", on_off(get_int_var(HTTP_GRAB_VAR))));
		} else if (!my_strnicmp(arg, "display_ansi", 4))
		{
			set_int_var(DISPLAY_ANSI_VAR, (get_int_var(DISPLAY_ANSI_VAR)?0:1));
			toggle_reverse_status(current_window, NULL, get_int_var(DISPLAY_ANSI_VAR));
			if (do_hook(SET_LIST, "%s %s", arg, on_off(get_int_var(DISPLAY_ANSI_VAR))))
				put_it("%s", convert_output_format("%cToggled %GAnsi Display %K[%W$[-3]0%K]","%s", on_off(get_int_var(DISPLAY_ANSI_VAR))));
			set_input_prompt(current_window, empty_string, 0);
			set_input_prompt(current_window, get_string_var(INPUT_PROMPT_VAR), 0);
			status_update(1);
		} else if (!my_strnicmp(arg, "log", 3))
		{
			int old_window_display = window_display;
			set_int_var(LOG_VAR, (get_int_var(LOG_VAR)?0:1));
			if (do_hook(SET_LIST, "%s %s", arg, on_off(get_int_var(LOG_VAR))))
				put_it("%s", convert_output_format("%cToggled %GLogging %K[%W$[-3]0%K]","%s", on_off(get_int_var(LOG_VAR))));
			window_display = 0;
			logger(current_window, NULL, get_int_var(LOG_VAR));
			window_display = old_window_display;
		} else
			bitchsay("Unknown /toggle [%s]", arg);
#endif
	}
}
#endif
}


BUILT_IN_COMMAND(show_version)
{
char *nick;
char *version_buf = NULL;
extern char tcl_versionstr[];

#ifdef HAVE_UNAME
struct utsname buf;
	
	uname(&buf);
	malloc_strcpy(&version_buf, stripansicodes(convert_output_format(fget_string_var(FORMAT_VERSION_FSET), "%s %s %s %s %s", irc_version, internal_version, buf.sysname, buf.release?buf.release:"", tcl_versionstr)));
#else
	malloc_strcpy(&version_buf, stripansicodes(convert_output_format(fget_string_var(FORMAT_VERSION_FSET), "%s %s %s %s %s", irc_version, internal_version, "unknown", tcl_versionstr, "")));
#endif
	if (args && *args)
		nick = next_arg(args, &args);
	else
		nick = get_current_channel_by_refnum(0);
	send_text(nick, version_buf, "PRIVMSG", 1, 0);
	new_free(&version_buf);
}


static char *tnick_arg = NULL;
static char *treason = NULL;

#if 0
void who_handlekill(char *nick, char *user, char *host)
{
static int count = 0;
	char *match_arg = NULL;
	
	if (!nick)
	{
		if (count == 0)
			bitchsay("No Match for kill of [%s]", nick_arg);
		new_free(&reason);
		new_free(&nick_arg);
		server_list[from_server].in_who_kill = 0;   
		count = 0;
		return;
        }
	if (!my_stricmp(nick, get_server_nickname(from_server)))
		return;
	match_arg = m_sprintf("*!%s@%s", user, host);
	if (wild_match(nick_arg, match_arg))
	{
		bitchsay("Killing %s!%s@%s[%s] %d", nick, user, host, nick_arg, ++count);
		if (!reason)
			malloc_strcpy(&reason, get_reason(nick, NULL));
		send_to_server("KILL %s :%s (%d)", nick, reason, count);
	}
	new_free(&match_arg);
}
#endif

void who_user_kill(WhoEntry *w, char *from, char **ArgList)
{
char *match_arg;
char *arg = NULL;
int len = strlen(ArgList[1])+strlen(ArgList[2])+10;
int count = 0;
char *nick_arg = NULL;
char *reason = NULL;

	if (isme(ArgList[3]))
		return;
	match_arg = alloca(strlen(ArgList[1])+strlen(ArgList[2])+10);
	*match_arg = 0;
	
	arg = alloca(strlen(w->who_buff)+1);
	strcpy(arg, w->who_buff);

	strmopencat(match_arg, len - 1, "*!", ArgList[1], "@", ArgList[2], NULL);
	count = atol(next_arg(arg, &arg));
	nick_arg = next_arg(arg, &arg);

	if (wild_match(nick_arg, match_arg))
	{
		if (arg && *arg)
			reason = arg;
		bitchsay("Killing %s!%s@%s[%s] %d", ArgList[4], ArgList[1], ArgList[2], nick_arg, ++count);
		if (!reason)
			malloc_strcpy(&reason, get_reason(ArgList[4], NULL));
		send_to_server("KILL %s :%s (%d)", ArgList[4], reason, count);
		malloc_sprintf(&w->who_buff, "%d %s %s", count, nick_arg, reason);
	}
}

void who_user_killend()
{
}

BUILT_IN_COMMAND(whokill)
{
	char *pattern;
	char *p = NULL;	
	char *nick_arg = NULL;
#if 0	
	if (nick_arg && server_list[from_server].in_who_kill)
	{
		bitchsay("Already doing %s", command);
		return;
	}
#endif

        if (!(pattern=next_arg(args, &args)))
	{
		userage(command, helparg);
		return;
	}

	malloc_sprintf(&nick_arg, "%s%s%s", *pattern != '*'?"*":empty_string, pattern, *(pattern+strlen(pattern)-1) != '*'?"*":empty_string);
	if ((p = strchr(nick_arg, '@')))
		p++;
	whobase(p ? p : nick_arg, who_user_kill, who_user_killend, "0 %s %s", nick_arg, (args && *args) ? args : empty_string);
	new_free(&nick_arg);
}

void trace_handlekill(int comm, char *nick)
{
static int count = 0;

	
	if (!nick)
	{
		if (comm == 262)
		{
			server_list[from_server].in_trace_kill = 0;
			return;	
		}
		if (count == 0 && server_list[from_server].in_trace_kill != 2)
			bitchsay("No Match for trace kill of [%s]", tnick_arg);
		new_free(&treason);
		new_free(&tnick_arg);
		count = 0;
		return;
        }
	if (!my_stricmp(nick, get_server_nickname(from_server)))
		return;
	bitchsay("Killing %s[%s] %d", nick, tnick_arg, ++count);
	if (!treason)
		malloc_strcpy(&treason, get_reason(nick, NULL));
	send_to_server("KILL %s :%s (%d)", nick, treason, count);
}

void handle_tracekill(int comm, char *nick, char *user, char *host)
{
	char temp[20];
	if (!nick)
	{
		trace_handlekill(comm, NULL);
		return;
	}
	if (wild_match(tnick_arg, nick))
	{
		if (server_list[from_server].in_trace_kill == 2)
			bitchsay("User: %s", nick);
		else
		{
			char *q;
			strncpy(temp, nick, 15);
			temp[15] = '\0';
			if (!(q = strrchr(temp, '[')))
				return;
			*q = 0;
			if (!my_stricmp(temp, get_server_nickname(from_server)))
				return;
			trace_handlekill(comm, temp);
		}
	}
}

BUILT_IN_COMMAND(tracekill)
{
	char *pattern;

	
	if (server_list[from_server].in_trace_kill)
	{
		bitchsay("Already in %s", command);
		return;
	}
	if (!(pattern = next_arg(args, &args)))
	{
		userage(command, helparg);
		return;
	}
	if (args && *args)
		malloc_strcpy(&treason, args);
	else
		new_free(&treason);

	malloc_sprintf(&tnick_arg, "%s%s%s", *pattern != '*'?"*":empty_string, pattern, *(pattern+strlen(pattern)-1) != '*'?"*":empty_string);

	if (treason && *treason == '-')
		server_list[from_server].in_trace_kill = 2;
	else
		server_list[from_server].in_trace_kill = 1;

	send_to_server("TRACE");
}

BUILT_IN_COMMAND(traceserv)
{
	char *server, *pattern;

	
	if (server_list[from_server].in_trace_kill)
	{
		bitchsay("Already in %s", command);
		return;
	}
	if (!(server = next_arg(args, &args)) ||
		!(pattern = next_arg(args, &args)))
	{
		userage(command, helparg);
		return;
	}
	if (args && *args)
	        malloc_strcpy(&treason, args);
	else
		new_free(&treason);

	malloc_sprintf(&tnick_arg, "%s%s%s", *pattern != '*'?"*":empty_string, pattern, *(pattern+strlen(pattern)-1) != '*'?"*":empty_string);

	if (treason && *treason == '-') 
		server_list[from_server].in_trace_kill = 2;
	else
		server_list[from_server].in_trace_kill = 1;
        send_to_server("TRACE %s", server);
}

#if 0
BUILT_IN_COMMAND(ftp)
{
Window *window, *tmp;
char name[40];
char *pgm = NULL;
int direct = 0;

	
	sprintf(name, "%%%s", command);
	if (command && !my_stricmp(command, "shell"))
	{
		pgm = get_string_var(SHELL_VAR);
		direct = 1;
	}
	else
		pgm = command;
		
	if (!args || !*args)
	{
		if (!is_window_name_unique(name+1))
		{
			int logic = -1;
			if ((tmp = get_window_by_name(name+1)))
			{
				delete_window(tmp);
				if ((logic = logical_to_index(name+1)) > -1)
					kill_process(logic, 15);
				else bitchsay("No such process [%s]", name+1);
			}
			recalculate_windows(tmp->screen);
			update_all_windows();
			return;
		}
	}
	if ((tmp = new_window(current_window->screen)))
	{
		int refnum;
		char *p = NULL;
		window = tmp;
		if (is_window_name_unique(name+1))
		{
			malloc_strcpy(&window->name, name+1);
			window->update |= UPDATE_STATUS;
		}

		window->screen = main_screen;
		set_screens_current_window(window->screen, window);
		recalculate_windows(tmp->screen);
		hide_window(window);
		refnum = window->refnum;
		
/*		update_all_windows();*/
		malloc_sprintf(&p, "-NAME %s %s %s", name, pgm, args);
/*		start_process(p, name+1, NULL, NULL, refnum, direct);*/
		execcmd(NULL, p, NULL, NULL);
		if (is_valid_process(name))
		{
			NickList *tmp_nick = NULL;
			malloc_strcpy(&window->query_nick, name);
			tmp_nick = (NickList *)new_malloc(sizeof(NickList));
			malloc_strcpy(&tmp_nick->nick, name);
			add_to_list((List **)&window->nicks, (List *)tmp_nick);
		}
		new_free(&p);
	} else bitchsay("Unable to create a new window");	
}
#endif

BUILT_IN_COMMAND(lkw)
{
	delete_window(current_window);
	update_all_windows();
}

BUILT_IN_COMMAND(jnw)
{
char *channel;
int hidden = 0;
	
	if ((channel = next_arg(args, &args)))
	{
		Window *tmp;
		if (*channel == '-' && !my_stricmp(channel, "-hide"))
		{
			if (!(channel = next_arg(args, &args)))
			{
				userage(command, helparg);
				return;
			}
			hidden = 1;
		}
		if ((tmp = new_window(current_window->screen)))
		{
			int     server;
			server = from_server;
			from_server = tmp->server;
			channel = make_channel(channel);
			send_to_server("JOIN %s%s%s", channel, args?" ":"", args?args:"");
			malloc_strcpy(&tmp->waiting_channel, channel);
			from_server = server;
			build_status(tmp, NULL, 0);
			if (hidden)
				hide_window(tmp);
			update_all_windows();
		}
	} else
		userage(command, helparg);
}

void change_orig_nick(void)
{
	change_server_nickname(from_server, org_nick);
	bitchsay("Regained nick [%s]", org_nick);
	new_free(&org_nick);
	update_all_status(current_window, NULL, 0);
	update_input(UPDATE_ALL);
}

static int delay_gain_nick(void *);

static void gain_nick (UserhostItem *stuff, char *nick, char *args)
{
	if (!org_nick)
		return;
	if (!stuff || (stuff->nick  && !strcmp(stuff->user, "<UNKNOWN>") && !strcmp(stuff->host, "<UNKNOWN>")))
	{
		change_orig_nick();
		return;
	}
	if (get_int_var(ORIGNICK_TIME_VAR) > 0)
		add_timer(0, "", get_int_var(ORIGNICK_TIME_VAR), 1, delay_gain_nick, NULL, NULL, NULL);
}

static int delay_gain_nick(void *arg)
{
	if (org_nick)
		userhostbase(org_nick, gain_nick, 1, "%s", org_nick);
	return 0;
}

void check_orig_nick(char *nick)
{
	if (org_nick && !my_stricmp(nick, org_nick))
		change_orig_nick();
}

BUILT_IN_COMMAND(orig_nick)
{
char *nick;
	if (!args || !*args)
	{
		userage("OrigNick", helparg);
		return;
	}
	nick = next_arg(args, &args);
	if (nick && *nick == '-')
	{
		if (!org_nick)
			bitchsay("Not trying to gain a nick");
		else
		{
			bitchsay("Removing gain nick [%s]", org_nick);
			new_free(&org_nick);
		}
	}
	else
	{
		if ((nick = check_nickname(nick)))
		{
			malloc_strcpy(&org_nick, nick);
			userhostbase(org_nick, gain_nick, 1, "%s", org_nick);
			bitchsay("Trying to regain nick [%s]", org_nick);
		}
		else
			bitchsay("Nickname was all bad chars");
	}
}

BUILT_IN_COMMAND(add_bad_nick)
{
char *buffer = NULL;
LameList *lame_nick = NULL;
char *nick = NULL;
extern LameList *lame_list;
int add = 0;
	if (!args || !*args || !command)
	{
		if (!command)
		{
			int i = 0;
			if (!lame_list)
			{
				bitchsay("There are no nicks on your lame nick list");
				return;
			}
			bitchsay("Lame Nick list:");
			for (lame_nick = lame_list; lame_nick; lame_nick = lame_nick->next)
			{
				if (buffer)
					m_s3cat(&buffer, lame_nick->nick, "\t");
				else
					buffer = m_sprintf("%s\t", lame_nick->nick);
				i++;
				if (i == 6)
				{
					i = 0;
					put_it("%s", buffer);
					new_free(&buffer);
				}	
			}
			if (buffer)
				put_it("%s", buffer);
			new_free(&buffer);
		}
		else
			userage(command, helparg);
		return;
	}
	add = !my_stricmp(command, "addlamenick") ? 1 : 0;
	bitchsay("%s %s LameNick list", add ? "Added":"Removed", add?"to":"from");
	while (args && *args)
	{
		nick = next_arg(args, &args);
		if (add && nick)
		{
			
			lame_nick = (LameList *)new_malloc(sizeof(LameList));
			malloc_strcpy(&lame_nick->nick, nick);
			add_to_list((List **)&lame_list, (List *)lame_nick);
		}
		else if (!add && nick)
		{
			lame_nick = (LameList *)remove_from_list((List **)&lame_list, nick);
			if (lame_nick)
			{
				new_free(&lame_nick->nick);
				new_free((char **)&lame_nick);
			}
			else
				nick = NULL;
		}
		if (nick && *nick)
		{
			if (buffer)
				m_s3cat(&buffer, nick, "\t");
			else
				buffer = m_sprintf("%s\t", nick);
		}
	}
	if (buffer)
		put_it("%s", buffer);
	new_free(&buffer);
}


List url_list[DEFAULT_MAX_URL] = {{0}};
static int url_count = 0;

int grab_http(char *from, char *to, char *text) 
{
static int count = 0;
int i;
char *q = NULL;
	if ((get_int_var(HTTP_GRAB_VAR) && stristr(text, "HTTP:")) || (get_int_var(FTP_GRAB_VAR) && stristr(text, "FTP:")))
	{
#ifdef PUBLIC_ACCESS
	bitchsay("This command has been disabled on a public access system");
	return;
#endif
		malloc_sprintf(&q, "%s %s -- %s", from, to, text);
		for (i = 0; i < DEFAULT_MAX_URL; i++)
		{
			if (url_list[i].name && !my_stricmp(url_list[i].name, q))
			{
				new_free(&q);
				return 0;
			}
		}
		if (url_count == DEFAULT_MAX_URL)
			new_free(&url_list[url_count-1].name);
		else
			url_count++;
		memmove(&url_list[1], &url_list[0], (DEFAULT_MAX_URL-1) * sizeof(List));
		url_list[0].name = q;
		count++; 
		bitchsay("Added HTTP/FTP grab [%d]", count);
		return 1;
	}
	return 0;
}

BUILT_IN_COMMAND(url_grabber)
{
int i;
char *p;
	if (args && *args)
	{
		while ((p = next_arg(args, &args)))
		{
			if (!my_stricmp(p, "SAVE"))
			{
				char *filename = NULL;
				FILE *file;
				char buffer[BIG_BUFFER_SIZE];
				char *number = "*";

				i = 1;
				sprintf(buffer, "%s/BitchX.url", get_string_var(CTOOLZ_DIR_VAR));
				filename = expand_twiddle(buffer);
				if (!filename || !(file = fopen(filename, "a")))
					return;
				if (args && *args && (isdigit(*args) || *args == '-'))
					number = next_arg(args, &args);
				while (i <= DEFAULT_MAX_URL)
				{
					if (matchmcommand(number, i) && url_list[i-1].name)
						fprintf(file, "%s\n", url_list[i-1].name);
					i++;
				}
				new_free(&filename);
				fclose(file);
				url_count = 0;
				for (i = 0; i < DEFAULT_MAX_URL; i++)
					new_free(&url_list[i].name);
			}
			else if (!my_stricmp("HTTP", p))
			{
				int on = get_int_var(HTTP_GRAB_VAR);
				char *ans = next_arg(args, &args);
				if (ans && !my_stricmp(ans, "ON"))
					on = 1;
				else
					on = 0;
				set_int_var(HTTP_GRAB_VAR, on);
			}
			else if (!my_stricmp("FTP", p))
			{
				int on = get_int_var(FTP_GRAB_VAR);
				char *ans = next_arg(args, &args);
				if (ans && !my_stricmp(ans, "ON"))
					on = 1;
				else
					on = 0;
				set_int_var(FTP_GRAB_VAR, on);
			}
			else if (!my_stricmp("CLEAR", p))
			{
				url_count = 0;
				for (i = 0; i < DEFAULT_MAX_URL; i++)
					new_free(&url_list[i].name);
			}
			else if (!my_stricmp("LIST", p))
			{
				for (i = 0; i < DEFAULT_MAX_URL; i++)
				{
					if (!url_list[i].name)
						break;
					put_it("%s", convert_output_format("$G HTTP[$0] $1-", "%d %s", i+1, url_list[i].name));
				}
			}
		}
	}
	else
		put_it("%s", convert_output_format("$G HTTP grab %K[%W$0%K]%n FTP grab %K[%W$1%K]", "%s %s", on_off(get_int_var(HTTP_GRAB_VAR)), on_off(get_int_var(FTP_GRAB_VAR))));
}

BUILT_IN_COMMAND(serv_stat)
{
extern long nick_collisions, oper_kills, serv_fakes, serv_unauth, serv_split;
extern long serv_rejoin, client_connects, serv_rehash, client_exits,serv_klines;
extern long client_floods, client_invalid, stats_req, client_bot, client_bot_alarm;
extern long oper_requests, serv_squits, serv_connects;
#ifdef ONLY_STD_CHARS

put_it("%s", convert_output_format("%G-----------%K[ %WServer %wStats %K]%G----------------------------------------------", NULL));
put_it("%s", convert_output_format("%G| %CN%cick Collisions %K[%W$[-4]0%K]    %CO%cper Kills   %K[%W$[-4]1%K]", "%d %d", nick_collisions, oper_kills));
put_it("%s", convert_output_format("%G| %CF%cake Modes      %K[%W$[-4]0%K]    %CU%cnauth       %K[%W$[-4]1%K]", "%d %d",serv_fakes, serv_unauth));
put_it("%s", convert_output_format("%G| %CH%cigh Traffic    %K[%W$[-4]0%K]    %CN%corm Traffic %K[%W$[-4]1%K]", "%d %d",serv_split, serv_rejoin));
put_it("%s", convert_output_format("%G| %CT%cotal Clients   %K[%W$[-4]0%K]    %CS%cerv rehash  %K[%W$[-4]1%K]", "%d %d",client_connects, serv_rehash));
put_it("%s", convert_output_format("%G| %CC%client exits    %K[%W$[-4]0%K]    %CK%c-lines adds %K[%W$[-4]1%K]", "%d %d",client_exits, serv_klines));
put_it("%s", convert_output_format("%G| %CC%client Floods   %K[%W$[-4]0%K]    %CS%ctats reqs   %K[%W$[-4]1%K]", "%d %d",client_floods, stats_req));
put_it("%s", convert_output_format("%G| %CI%cnvalid User    %K[%W$[-4]0%K]    %CO%cper Reqs    %K[%W$[-4]1%K]", "%d %d",client_invalid, oper_requests));
put_it("%s", convert_output_format("%G| %CP%cossible Bots   %K[%W$[-4]0%K]    %CB%cot Alarms   %K[%W$[-4]1%K]", "%d %d",client_bot, client_bot_alarm));
put_it("%s", convert_output_format("%G| %CS%cerv Squits     %K[%W$[-4]0%K]    %CS%cerv Connect %K[%W$[-4]1%K]", "%d %d",serv_squits, serv_connects));

#else

put_it("%s", convert_output_format("%G---%g%G-%K[ %WServer %wStats %K]-%g%G-%g---%K%g--%K%g-%K--- --  - --- -- -", NULL));
put_it("%s", convert_output_format("%G %CN%cick Collisions %K[%W$[-4]0%K]    %CO%cper Kills   %K[%W$[-4]1%K]", "%l %l", nick_collisions, oper_kills));
put_it("%s", convert_output_format("%G %CF%cake Modes      %K[%W$[-4]0%K]    %CU%cnauth       %K[%W$[-4]1%K]", "%l %l",serv_fakes, serv_unauth));
put_it("%s", convert_output_format("%g %CH%cigh Traffic    %K[%W$[-4]0%K]    %CN%corm Traffic %K[%W$[-4]1%K]", "%l %l",serv_split, serv_rejoin));
put_it("%s", convert_output_format("%G %CT%cotal Clients   %K[%W$[-4]0%K]    %CS%cerv rehash  %K[%W$[-4]1%K]", "%l %l",client_connects, serv_rehash));
put_it("%s", convert_output_format("%g| %CC%client exits    %K[%W$[-4]0%K]    %CK%c-lines adds %K[%W$[-4]1%K]", "%l %l",client_exits, serv_klines));
put_it("%s", convert_output_format("%G: %CC%client Floods   %K[%W$[-4]0%K]    %CS%ctats reqs   %K[%W$[-4]1%K]", "%l %l",client_floods, stats_req));
put_it("%s", convert_output_format("%G: %CI%cnvalid User    %K[%W$[-4]0%K]    %CO%cper Reqs    %K[%W$[-4]1%K]", "%l %l",client_invalid, oper_requests));
put_it("%s", convert_output_format("%K| %CP%cossible Bots   %K[%W$[-4]0%K]    %CB%cot Alarms   %K[%W$[-4]1%K]", "%l %l",client_bot, client_bot_alarm));
put_it("%s", convert_output_format("%g: %CS%cerv Squits     %K[%W$[-4]0%K]    %CS%cerv Connect %K[%W$[-4]1%K]", "%l %l",serv_squits, serv_connects));

#endif

}

char *strip (char *str, char *unwanted)
{
static char buffer[NICKNAME_LEN*4];
register char *cp, *dp;
	if (!str)
		return empty_string;
	for (cp = str, dp = buffer; *cp; cp++)
	{
		if (!strchr(unwanted, *cp))
			*dp++ = *cp;
	}	
	*dp = 0;
	return buffer;
}


BUILT_IN_COMMAND(set_autoreply)
{
char new_nick[NICKNAME_LEN+10];
char not_wanted1[] = "_^\\{}[]|-";
char not_wanted2[] = "_^\\{}[]|-0123456789";
extern char *auto_str;
	if (!args || !*args)
	{
		userage("SetAR", helparg);
		return;
	}
	if (*args == '-')
	{
		set_string_var(AUTO_RESPONSE_STR_VAR, NULL);
		bitchsay("Auto-reply pats are deleted");
		new_free(&auto_str);
	}
	else
	{
		char *p, *new_args = NULL;
		p = next_arg(args, &args);
		if (*p == 'd' && strlen(p) == 1)
		{
			int len = strlen(nickname);
			m_e3cat(&new_args, nickname, " ");
			m_e3cat(&new_args, strip(nickname, not_wanted1), len > 4 ? " ": empty_string);
			if (len > 4)
			{
				memset(new_nick, 0, sizeof(new_nick));
				new_nick[0] = '*';
				strncpy(new_nick+1, strip(nickname, not_wanted1), 4);
				new_nick[5] = '*';
				if (!strstr(new_args, new_nick))
					m_e3cat(&new_args, new_nick, " ");
			}
			if (!strstr(new_args, strip(nickname, not_wanted2)))
				m_e3cat(&new_args, strip(nickname, not_wanted2), len > 4 ? space:empty_string);
			if (len > 4)
			{
				memset(new_nick, 0, sizeof(new_nick));
				new_nick[0] = '*';
				strncpy(new_nick+1, strip(nickname, not_wanted2), 4);
				new_nick[5] = '*';
				if (!strstr(new_args, new_nick))
					malloc_strcat(&new_args, new_nick);
			}
			set_string_var(AUTO_RESPONSE_STR_VAR, new_args);
			reinit_autoresponse(current_window, new_args, 0);
		}
		else
		{
			do {
				m_3cat(&new_args, p, args?" ":empty_string);
			} while ((p = next_arg(args, &args)));
			set_string_var(AUTO_RESPONSE_STR_VAR, new_args);
			reinit_autoresponse(current_window, new_args, 0);
		}
		new_free(&new_args);
		bitchsay("Auto-Response now set to [%s]", get_string_var(AUTO_RESPONSE_STR_VAR));
	}
}



BUILT_IN_COMMAND(unload)
{
	remove_bindings();
	init_keys_1();
	delete_all_timers();
	destroy_aliases(VAR_ALIAS);
	destroy_aliases(COMMAND_ALIAS);
	destroy_aliases(VAR_ALIAS_LOCAL);
	flush_on_hooks();
	init_variables();                                                                        	                        
	init_window_vars(NULL, NULL, NULL, NULL);
}


BUILT_IN_COMMAND(add_no_flood)
{
char *nick;
List *nptr;
	if (!args || !*args)
	{
		int count = 0;
		for (nptr = next_namelist(no_flood_list, NULL, FLOOD_HASHSIZE); nptr; nptr = next_namelist(no_flood_list, nptr, FLOOD_HASHSIZE))
		{
			if (count == 0)
				put_it("%s", convert_output_format("No Flood list", NULL, NULL));
			put_it("%s", nptr->name);
			count++;
		}
		return;
	}
	nick = next_arg(args, &args);
	while (nick && *nick)
	{
		if (!(nptr = find_name_in_genericlist(nick, no_flood_list, FLOOD_HASHSIZE, 0)))
			add_name_to_genericlist(nick, no_flood_list, FLOOD_HASHSIZE);
		nick = next_arg(args, &args);
	}
}

BUILT_IN_COMMAND(check_clones)
{
char *channel= NULL;
ChannelList *chan = NULL;
NickList *nptr = NULL, *nptr1 = NULL;
int server = from_server;
int clones = 0;
	if (args && *args)
	{
		channel = next_arg(args, &args);
		channel = make_channel(channel);
		chan = prepare_command(&server, channel, NO_OP);
	}
	else
	{
		channel = get_current_channel_by_refnum(0);
		chan = prepare_command(&server, channel, NO_OP);
	}
	if (chan == NULL)
		return;
	for (nptr = next_nicklist(chan, NULL); nptr; nptr = next_nicklist(chan, nptr))
		nptr->check_clone = 0;
	for (nptr = next_nicklist(chan, NULL); nptr; nptr = next_nicklist(chan, nptr))
	{
		char *q;
		nptr1 = NULL;
		q = strchr(nptr->host, '@'); q++;
		for (nptr1 = next_nicklist(chan, NULL); nptr1; nptr1 = next_nicklist(chan, nptr1))
		{
			char *p;
			if (nptr1 == nptr)
				continue;
			p = strchr(nptr1->host, '@'); p++;
			if (!strcmp(p, q) && !nptr->check_clone)
			{
				/* clone detected */
				if (!clones && do_hook(CLONE_LIST, "Clones detected on %s", chan->channel))
					bitchsay("Clones detected on %s", chan->channel);
				if (!nptr->check_clone++ && do_hook(CLONE_LIST, "%s %s %s", nptr->nick, nptr->host, nptr->chanop? "@":empty_string))
				{
					put_it("\t%s %s %s", nptr->chanop ? "@":" ", nptr->nick, nptr->host);
					clones++;
				}
				if (!nptr1->check_clone && do_hook(CLONE_LIST, "%s %s %s", nptr1->nick, nptr1->host, nptr1->chanop? "@":empty_string))
					put_it("\t%s %s %s", nptr1->chanop ? "@":" ", nptr1->nick, nptr1->host);
				nptr1->check_clone++;
				clones++;
			}
		}
	}
	if (!clones)
	{
		if (do_hook(CLONE_LIST, "No clones detected on %s", channel))
			bitchsay("No clones detected on %s", channel);
	}
	else if (do_hook(CLONE_LIST, "Found %d clones", clones))
		bitchsay("Found %d clones", clones);
}

void get_range(char *line, int *start, int *end)
{
char *q = line, *p = line;
	while (*p && isdigit(*p))
		p++;
	if (*p)
		*p++ = 0;
	*start = my_atol(q);
	*end = *p? my_atol(p): *start;
	if (*end < *start)
		*end = *start;
}

BUILT_IN_COMMAND(pastecmd)
{
	char *lines;
	char *channel = NULL;
	Window *win;
	int	winref = 0;
	int line = 1;
	int topic = 0;

	int start_line = 1, end_line = 1, count;
#if 0
	Lastlog *start_pos;
#else
	Display *start_pos;
#endif        
	if ((lines = next_arg(args, &args)))
		get_range(lines, &start_line, &end_line);
	if (!args || !*args)
		channel = get_current_channel_by_refnum(0);
	else
	{
		char *t;
		while (args && *args)
		{
			t = next_arg(args, &args);
			if (*t == '-')
			{
				if (!my_strnicmp(t, "-win", strlen(t)))
				{
					if (*args && isdigit(*args))
					{
						t = next_arg(args, &args);
						winref = my_atol(t);
					}
				}
				else if (!my_strnicmp(t, "-topic", strlen(t)))
				{
					topic = 1;
				}
			}
			else 
				channel = t;
		}
	}
	if (!channel && !(channel = get_current_channel_by_refnum(0)))
		return;
	win = get_window_by_refnum(winref);

	if (!(end_line - start_line))
		line = end_line;
	else
		line = end_line - start_line + 1;
#if 0
	if (line < 1 || line > win->lastlog_size)
	{
		bitchsay("Try a realistic number within your scrollbuffer");
		return;
	}
	for (start_pos = get_input_hold(win) ? get_input_hold(win):win->lastlog_head; line; start_pos = start_pos->next)
		line--;

	if (!start_pos)
		start_pos = win->lastlog_tail;
	else
		start_pos = start_pos->prev;
	count = end_line - start_line + 1;
	if (count == 1 && topic && start_pos)
	{
		send_to_server("TOPIC %s :%s", channel, start_pos->msg);
		return;
	}
	while (count)
	{
		line++;
		if (start_pos && start_pos->msg)
		{
			if (do_hook(PASTE_LIST, "%s %s", channel, start_pos->msg))
				send_text(channel, convert_output_format(fget_string_var(FORMAT_PASTE_FSET),"%s %d %s", channel, line, start_pos->msg), NULL, 1, 0);
			start_pos = start_pos->prev;
		}
		count--;
	}
#else
	if (line < 1 || line > win->display_buffer_size)
	{
		bitchsay("Try a realistic number within your scrollbuffer");
		return;
	}
	start_pos = get_screen_hold(win);
	for (start_pos = start_pos ? start_pos->prev : win->display_ip->prev; line > 1; start_pos = start_pos->prev)
		line--;

	if (!start_pos)
		start_pos = win->display_ip->prev;

	count = end_line - start_line + 1;
	if (count == 1 && topic && start_pos)
	{
		send_to_server("TOPIC %s :%s", channel, start_pos->line);
		return;
	}
	line = 0;
	while (count)
	{
		line++;
		if (start_pos && start_pos->line)
		{
			if (do_hook(PASTE_LIST, "%s %s", channel, start_pos->line))
				send_text(channel, convert_output_format(fget_string_var(FORMAT_PASTE_FSET),"%s %d %s", channel, line, start_pos->line), NULL, 1, 0);
			start_pos = start_pos->next;
		}
		count--;
	}
#endif
}


void parsemenuitem(char *pargs, char **itemtext, char **options, char **itemalias)
{
char *text;
	if (*pargs == '-')
	{
		text = pargs;
		switch(*(pargs+1))
		{
			case 'c':
			case 'n':
			{
				char *p;
				if ((p = strchr(pargs, ' ')))
					p++;
				text = new_next_arg(p, &pargs);
				break;
			}
			default:
				break;
		}
		*options = text;		
		text = new_next_arg(pargs, &pargs);
		*itemtext = text;
	}	
	else
		*itemtext = new_next_arg(pargs, &pargs);
	if (pargs && *pargs == '{')
		*itemalias = next_expr(&pargs, '{');
	else
		*itemalias = pargs;
}

void parsesubmenu(char *pargs, char **submenutext, char **options)
{
	if (*pargs == '-')
	{
		*options = new_next_arg(pargs, &pargs);
	}
	*submenutext = pargs;
}

/*
 * Returns a pointer to the menu you are looking for, or returns NULL if it does not exist
 */

MenuStruct *findmenu(char *menuname)
{
MenuStruct *thismenu, *tmenu;
	if(morigin!=NULL)
	{
		thismenu=morigin;
		while(thismenu)
		{
			if(!strcmp(menuname, thismenu->name))
				return thismenu;
			else if (thismenu->menuorigin)
			{
				for (tmenu = thismenu->menuorigin->submenu; tmenu; tmenu = tmenu->next)
				{
					if (!strcmp(menuname, tmenu->name))
						return tmenu;
				}
			}
			thismenu = thismenu->next;
		}
	}
	return NULL;
}


MenuStruct *findsubmenu(char *menuname, MenuList *msearch)
{
MenuStruct *thismenu;
	thismenu=msearch->submenu;
	while(thismenu)
	{
		if(!strcmp(menuname, thismenu->name))
			return thismenu;
		thismenu = thismenu->next;
	}
	return NULL;
}

/*
 * This adds an empty menu entry
 */

static int null_cmp_func(List *s, List *s1)
{
	return 0;
}

MenuStruct *addmenu(char *menuname)
{
	MenuStruct *new = NULL;
	new = new_malloc(sizeof(MenuStruct));
	malloc_strcpy(&new->name, menuname);

	new->menuorigin=NULL;
	new->next=NULL;
	add_to_list_ext((List **)&morigin, (List *)new, null_cmp_func);
	return new;
}

MenuStruct *addsubmenu(char *menuname)
{
	MenuStruct *new = NULL;
	new = new_malloc(sizeof(MenuStruct));
	malloc_strcpy(&new->name, menuname);
	return new;
}

/*
 * This function recursively deletes all menuitems 
 */

void recdel(MenuList *delitem)  
{
MenuList *last;
	while (delitem)
	{
		last = delitem->next;
		new_free(&delitem->name);
		new_free(&delitem);
		delitem = last;
	}
}

/*
 * This removes a menu entry and all menuitems on it
 */

void removemenu(char *menuname)
{
MenuStruct *thismenu;
	if ((thismenu = (MenuStruct *)remove_from_list((List **)&morigin, menuname)))
	{
		if (thismenu->menuorigin)
			recdel(thismenu->menuorigin);
		new_free(&thismenu->name);
		new_free(&thismenu);
	}
}

BUILT_IN_COMMAND(os2menu)
{
   char *mpar;
   MenuStruct *thismenu;

	if ((mpar = new_next_arg(args, &args)))
	{
        	//if(load_depth != -1) return;
		if(*mpar =='-')
			removemenu(mpar + 1);
		else
			addmenu(mpar);
	}
	else
	{
		if (morigin)
		{
			MenuList *item, *itemsub;
			MenuStruct *tmenu;
			thismenu=morigin;
			while (thismenu!=NULL) 
			{
				say("Menu \'%s\'",thismenu->name);
				for (item = thismenu->menuorigin; item; item = item->next)
				{
					say("\tItem \'%s\'", item->name ? item->name : "______________");
					for (tmenu = item->submenu; tmenu; tmenu = tmenu->next)
					{
						say("\t\tSubitem \'%s\'", tmenu->name ? tmenu->name : "__________");
						for (itemsub = tmenu->menuorigin; itemsub; itemsub = itemsub->next)
							say("\t\t\tSub \'%s\'", itemsub->name ? itemsub->name : "__________");
					
					}
				}				
				thismenu=thismenu->next;
			}
		}
		else
			say("No menus defined.");
	}
}

BUILT_IN_COMMAND(os2menuitem)
{
char	*menuname = NULL, 
	*itemtext = NULL, 
   	*options = NULL, 
   	*itemalias = NULL; 
MenuStruct *thismenu;
MenuList *lastitem = NULL, *thisitem = NULL;

	if ((menuname = next_arg(args, &args)) && (thismenu=findmenu(menuname)))
	{
		parsemenuitem(args, &itemtext, &options, &itemalias);
		if (thismenu->menuorigin!=NULL)
		{
			thisitem=thismenu->menuorigin;
			while (thisitem)
			{
				lastitem=thisitem;
				thisitem=lastitem->next;
			}
			lastitem->next=(MenuList *)new_malloc(sizeof(MenuList)); /* I need to add error checking here later */
			thisitem=lastitem->next;
		}
		else
		{
			thismenu->menuorigin=(MenuList *)new_malloc(sizeof(MenuList)); /* I need to add error checking here later */			
			thisitem=thismenu->menuorigin;
		}
		thisitem->menuid=globalmenuid;
		globalmenuid++;                 /* Add checks for inactive items, etc in options */
		if (!my_stricmp(itemtext, "separator"))
			thisitem->menutype=PMBXSEPARATOR;
		else
		{
			thisitem->menutype=PMBXMENUITEM;
			malloc_strcpy(&thisitem->name,itemtext);
		}
		thisitem->submenu=NULL;
		thisitem->next=NULL;
	}
}

BUILT_IN_COMMAND(os2submenu)
{
char	*menuname = NULL, 
   	*submenuname = NULL, 
   	*submenutext = NULL, 
   	*options = NULL; 
MenuStruct *thismenu = NULL, *submenu = NULL;
MenuList *lastitem = NULL, *thisitem = NULL;


	if ((menuname = next_arg(args, &args)))
	{
		submenuname = next_arg(args, &args);
		if(!submenuname)
			return;
		if (!(thismenu = findmenu(menuname)))
			thismenu = addmenu(menuname);
		if (thismenu->menuorigin)
			submenu = findsubmenu(submenuname, thismenu->menuorigin);
		if (!submenu)
			submenu = addsubmenu(submenuname);
	}
	if (menuname && thismenu)
	{
		parsesubmenu(args, &submenutext, &options);
		if(thismenu->menuorigin)
		{
			thisitem=thismenu->menuorigin;
			while(thisitem)
			{
				lastitem=thisitem;
				thisitem=lastitem->next;
			}
			lastitem->next=(MenuList *)new_malloc(sizeof(MenuList)); /* I need to add error checking here later */
			thisitem=lastitem->next;
		}
		else
		{
			thismenu->menuorigin=(MenuList *)new_malloc(sizeof(MenuList)); /* I need to add error checking here later */
			thisitem=thismenu->menuorigin;
		}
		thisitem->menuid=globalmenuid;
		globalmenuid++;                 /* Add checks for inactive items, etc in options */
		if (!my_stricmp(submenutext, "separator"))
			thisitem->menutype=PMBXSEPARATOR;
		else
		{
			thisitem->menutype=PMBXSUBMENU;
			malloc_strcpy(&thisitem->name,submenutext);
		}
		add_to_list_ext((List **)&thisitem->submenu, (List *)submenu, null_cmp_func);
		thisitem->next=NULL;
	}
}

BUILT_IN_COMMAND(os2font)
{
#if 0
	font_dialog(last_input_screen->hwndFrame);
#endif
}










#if !defined(__EMX__) && !defined(WINNT) && defined(WANT_DETACH)

extern char socket_path[];
extern char *old_pass;

int displays = 0;
int reattach_socket = -1;
int save_pid = -1;

struct param {
	pid_t pgrp,
	pid;
	char tty[80];
	char password[80];
};

#ifdef HAVE_SYS_UN_H
#include <sys/un.h>
#endif

#define SOCKMODE (S_IWRITE | S_IREAD | (displays ? S_IEXEC : 0))

char *Filename(char *s)
{
register char *p = s;

	if (p)
		while (*p)
			if (*p++ == '/')
				s = p;
	return s;
}

char *find_tty_name(char *name)
{
static char tty[20];
char *q, *s;
	*tty = 0;
#if 0
	if ((q = strchr(name, '.')))
	{
		q++;
		if((s = strchr(q, '.')))
			strncpy(tty, q, s-q);
	}
#endif
	if ((q = strrchr(name, '/')))
	{
		q++;
		if ((q = strchr(q, '.')))
		{
			q++;
			if ((s = strchr(q, '.')))
				strncpy(tty, q, s-q);
		}
	}
	return tty;
}

char *find_tty_path(char *name)
{
static char ttypath[200];
char *q;
	*ttypath = 0;
	if ((q = strrchr(name, '/')))
		strncpy(ttypath, name, q - name);
	return ttypath;
}

void display_socket_list(char *path, int unl)
{
DIR	*dptr;
struct	dirent	*dir;
struct	stat	st;
char buffer[2000];
char *new_path, *p;
int count = 0;
	new_path = alloca(strlen(path)+1);
	strcpy(new_path, path);
	if ((p = strrchr(new_path, '/')))
		*p = 0;
	if (!(dptr = opendir(new_path)))
	{
		fprintf(stderr, "No such directory %s\r\n ", new_path);
		exit(1);
	}
	while ((dir = readdir(dptr)))
	{
		if (!dir->d_ino)
			continue;
		if (dir->d_name[0] == '.')
			continue;
		sprintf(buffer, "%s/%s", new_path, dir->d_name);
		if ((stat(buffer, &st) == -1))
			continue;
		if (!count && !unl)
			fprintf(stderr, "There is more than one sockets available - \r\n");
		else if (!count)
			fprintf(stderr, "unlinking the following\r\n");
		count++;
		if (unl)
		{
			if (!((st.st_mode & 0700) == 0600))
			{
				fprintf(stderr, "%30s\r\n", dir->d_name);
				unlink(buffer);
			}
		} 
		else
			fprintf(stderr, "%30s %s\r\n", dir->d_name, ((st.st_mode & 0700) == 0600) ? "detached":"Attached or dead");
	}
	if (!count)
		fprintf(stderr, "No sockets to attach too\r\n");
	closedir(dptr);
	exit(1);
}


char *find_detach_socket(char *path, char *name)
{
char	*new_path;
DIR	*dptr;
struct	dirent	*dir;
struct	stat	st;
char *ret = NULL, *p;
int count = 0;
	new_path = alloca(strlen(path)+1);
	strcpy(new_path, path);
	if ((p = strrchr(new_path, '/')))
		*p = 0;
	else
		return NULL;
	if (!(dptr = opendir(new_path)))
		return NULL;
	ret = malloc(2000);
	*ret = 0;
	while ((dir = readdir(dptr)))
	{
		*ret = 0;
		if (!dir->d_ino)
			continue;
		if (dir->d_name[0] == '.')
			continue;
		sprintf(ret, "%s/%s", new_path, dir->d_name);
		p = strrchr(ret, '/'); p++;
		if ((stat(ret, &st) == -1) || (st.st_uid != getuid()) || S_ISDIR(st.st_mode))
		{
			*ret = 0;
			continue;
		}
		if (name)
		{
			char *pid, *n_tty, *h_name;
			pid = alloca(strlen(p)+1);
			strcpy(pid, p);
			n_tty = strchr(pid, '.'); *n_tty++ = 0;
			h_name = strchr(n_tty, '.'); *h_name++ = 0;
			if (strcmp(name, pid))
			{
				if (strcmp(n_tty, name))
				{
					if (strcmp(h_name, name))
					{
						if (strcmp(p, name))
						{
							if (!strstr(p, name))
							{
								*ret = 0;
								continue;
							}
						}
					}
				}
			}
		}
		if ((st.st_mode & 0700) == 0600)
			break;
		count++;
		*ret = 0;
	}
	closedir(dptr);
	if (ret && !*ret)
	{
		free(ret);
		ret = NULL;
	}
	if (count > 1)
	{
		display_socket_list(path, 0);
		if (ret) free(ret);
		ret = NULL;
	}
	return ret;
}

char *crypt();
int checkpass(char *password, char *old)
{
	char seed[3], *p;
	seed[0] = old[0];
	seed[1] = old[1];
	seed[2] = 0;
	p = crypt(password, seed);
	return strcmp(p, old);
	
}
void handle_reconnect(int s)
{
struct param parm;
int len;
struct sockaddr_un addr;
int n;
	memset(&addr, 0, sizeof(addr));
	len = sizeof(addr);
	alarm(10);
	n = accept(s, (struct sockaddr *)&addr, &len);
	alarm(0);
	if (n < 0) /* || strcmp(strrchr(addr.sun_path, '/'), strrchr(socket_path, '/')))*/
	{
		put_it("%d %s %s", errno, strerror(errno), *addr.sun_path ? addr.sun_path:"");
		if ( n > -1) close(n);
		return;
	}
	alarm(5);
	if ((len = read(n, &parm, sizeof(struct param))) > 0)
	{
		alarm(0);
		if ( ((parm.password[0] != '\0') && !old_pass) ||
			((parm.password[0] == '\0') && old_pass) ||
			((parm.password[0] != '\0') && old_pass && checkpass(parm.password, old_pass) ))
		{
			bitchsay("Invalid password attempt on reconnect");
			close(n);
			return;
		}
		save_pid = parm.pid;

		new_close(0);
		close(1);
		close(2);
		fclose(main_screen->fpout);
		fclose(main_screen->fpin);
		close(main_screen->fdout);
		close(main_screen->fdin);

		dup2(n, 0);
		dup2(n, 1);
		dup2(n, 2);

		parm.pid = getpid();
		parm.pgrp = getpgrp();
		strcpy(parm.tty, ttyname(0) ? ttyname(0) : socket_path);
		write(n, &parm, sizeof(struct param));

		main_screen->fpin = fdopen(0, "r");
		main_screen->fpout = fdopen(1, "w");
		main_screen->fdin = fileno(main_screen->fpin);
		main_screen->fdout = fileno(main_screen->fpout);

		new_open(n);


		reinit_term(main_screen->fdin);
		set_term_eight_bit(1);
		charset_ibmpc();
		update_all_windows();
		refresh_screen(0, NULL);
		unlink(addr.sun_path);
		unlink(socket_path);
		reattach_socket = n;
		close_socketread(s);
		use_input = 1;
		return;
	}
	alarm(0);
	close(n);
}

#include <unistd.h>
#ifdef HAVE_SYS_UN_H
#include <sys/un.h>
#endif

#include <sys/wait.h>
#include <sys/ioctl.h>
#ifdef HAVE_SYS_FILIO_H
#include <sys/filio.h>
#endif

void kill_attached_if_needed(int type)
{
	if (reattach_socket != -1)
	{
		new_close(0); 
		new_close(reattach_socket);
		dup2(main_screen->fdin, 0);
		new_open(0);
		dup2(main_screen->fdout, 1);
		dup2(main_screen->fdout, 2);
		kill(save_pid, type ? SIGPIPE : SIGINT);
		close(reattach_socket);
		reattach_socket = -1;
		save_pid = -1;
	}
}



struct param parm;                                                

RETSIGTYPE handle_pipe (int unused)
{
	term_reset();
	fprintf(stdout, "\r\ndetached from %s. To re-attach type BitchX -r or bx-scr %s %s\n\r", ttyname(0), old_pass?"password":"", old_pass?old_pass:empty_string);
	fflush(stdout);
	_exit(1);
}

RETSIGTYPE handle_ctrlc (int unused)
{
	term_reset();
	fprintf(stdout, "\r\nclient has exited\r\n");
	fflush(stdout);
	_exit(1);
}

void reattach_tty(char *tty, char *password)
{
int s = -1;
char *name;
struct sockaddr_un addr;
int len = 0;
fd_set rd_fd;
struct timeval tm = {0};

	if (!(name = find_detach_socket(socket_path, tty)))
	{
		fprintf(stderr, "No detached process to attach to\r\n");
		_exit(1);
	}

	if ((s = socket(AF_UNIX, SOCK_STREAM, 0)) < 0)
		_exit(1);

	chmod(name, S_IRWXU);
	memset (&addr, 0, sizeof(addr));
	addr.sun_family = AF_UNIX;
	sprintf(addr.sun_path, "%s", name);
	len = strlen(addr.sun_path) + sizeof(addr.sun_family) + 1;
	bind(s, (struct sockaddr *)&addr, len);
	
	if (connect(s, (struct sockaddr *)&addr, len) < 0)
	{
		fprintf(stderr, "connection refused for %s\r\n", addr.sun_path);
		chmod(addr.sun_path, SOCKMODE);
		_exit(1);
	}

	memset(&parm, 0, sizeof(struct param));
	parm.pid = getpid();
	parm.pgrp = getpgrp();
	strcpy(parm.tty, ttyname(0));
	if (password) 
		strncpy(parm.password, password, 60);
	fprintf(stderr, "attempting to wakeup %s\r\n", name);
	write(s, &parm, sizeof(struct param));	
	alarm(5);
	len = read(s, &parm, sizeof(struct param));
	alarm(0);
	if (len <= 0)
	{
		fprintf(stderr, "Error reconnecting to %s [%s]\r\n", find_tty_name(name), strerror(errno));
		chmod(addr.sun_path, SOCKMODE);
		exit(1);
	}
	unlink(name);

	term_init();
	set_term_eight_bit(1);
	charset_ibmpc();
	term_clear_screen();
	term_resize();
	term_move_cursor(0,0);
	my_signal(SIGPIPE, handle_pipe, 0);
	my_signal(SIGINT,  handle_ctrlc, 0);
	/*
	 * according to MHacker we need to set errno to 0 under BSD.
	 * for some reason we get a address in use from a socket 
	 *
	 */
	 errno = 0;
	while (1)
	{
		FD_ZERO(&rd_fd);
		FD_SET(0, &rd_fd);
		FD_SET(s, &rd_fd);
		tm.tv_sec = 2;
		
		switch(select(s+1, &rd_fd, NULL, NULL, &tm))
		{
			case -1:
				close(s);
				_exit(1);
				break;
			case 0:
				if (errno)
					_exit(1);
				break;
			default:
			{
				unsigned char buffer[4 * BIG_BUFFER_SIZE+1];
				if (errno)
					_exit(1);
				if (FD_ISSET(0, &rd_fd))
				{
					len = read(0, buffer, sizeof(buffer));
					write(s, buffer, len);
				}
				if (FD_ISSET(s, &rd_fd))
				{
					len = read(s, buffer, sizeof(buffer));
					write(1, buffer, len);
				}
			}
		}
	}
	close(s);
	_exit(1);			 

	return; /* error return */
}


void create_ipc_socket(void)
{
int s = -1;
struct sockaddr_un addr;
int len;
	displays = 0;
	init_socketpath();
	s=socket(AF_UNIX, SOCK_STREAM, 0);
	memset(&addr, 0, sizeof(addr));
	strcpy(addr.sun_path, socket_path);
	addr.sun_family = AF_UNIX;
	len = sizeof(addr.sun_family)+ strlen(addr.sun_path) + 1;
	bind(s, (struct sockaddr *)&addr, len);
	listen(s, 1);
	chmod(socket_path, SOCKMODE);
	chown(socket_path, getuid(), getgid());
#ifdef F_SETOWN
	fcntl(s, F_SETOWN, getpid());
#endif /* F_SETOWN */
	set_non_blocking(s);
	add_socketread(s, 0, 0, socket_path, handle_reconnect, NULL);
}


void do_detach(int pid, char *args)
{
	extern char *stripdev(char *);
	char hostn[BIG_BUFFER_SIZE+1];
	char *p;
	gethostname(hostn, BIG_BUFFER_SIZE);
	if ((p = strchr(hostn, '.')))
		*p = 0;
	if (args)
	{
		cursor_to_input(); 
		term_cr(); 
		term_clear_to_eol();
		term_reset();
	}
	else
		term_reset();
	fprintf(stdout, "\n\r");
	if (args && *args)
		old_pass = m_strdup(next_arg(args, &args));
	fprintf(stdout, "detached from %s. To re-attach type BitchX -R or bx-scr %s %s\n\r", ttyname(0), old_pass?"password":"", old_pass?old_pass:empty_string);
	fflush(stdin);
	fflush(stdout);
	fflush(stderr);
	ioctl(0, TIOCNOTTY, 0);
	_exit(pid);
}
#endif /* EMX WINNT WANT_DETACH */

void close_detach_fd(void)
{
Screen *screen = NULL;
	if (main_screen)
	{
		main_screen->fdout = main_screen->fdin = open("/dev/null", O_RDWR|O_NOCTTY);
		main_screen->fpin = fdopen(main_screen->fdin, "r");
		main_screen->fpout = fdopen(main_screen->fdout, "w");
	}
	else
	{
		close(0); close(1); close(2);
	}
	freopen("/dev/null", "r", stdin);
	freopen("/dev/null", "w", stdout);
	freopen("/dev/null", "w", stderr);
	for (screen = screen_list; screen; screen = screen->next)
	{
		screen->fpin = main_screen->fpin;
		screen->fpout = main_screen->fpout;
		screen->fdin = main_screen->fdin;
		screen->fdout = main_screen->fdout;
	}

}
BUILT_IN_COMMAND(detachcmd)
{
#if !defined(__EMX__) && !defined(WINNT) && defined(WANT_DETACH)
pid_t pid = getpid();
pid_t sid;
	/* 
	 * this is written so that a running bx client will attempt to
	 * detach and then later a screen program can be used to re-attach 
	 * to us. 
	 */	
	displays = 0;
	if (args && *args)
	{
		char *p;
		p = next_arg(args, &args);
		malloc_strcpy(&old_pass, cryptit(p));
	}
	/*
	 * create a server socket with the above name.
	 */
#ifndef BSD
	if (getsid(0) != getpgrp())
#endif
	{
		switch(pid = fork())
		{
			case -1:
				put_it("error in fork");
				return;
			default:
			{
				do_detach(pid, args);
				return;
			}
			case 0:
				break;
		}
		if ((sid = setpgid(0, 0)) == -1)
			return;
	}
	use_input = 0;
	ioctl(0, F_SETOWN, pid);

	create_ipc_socket();
	close_detach_fd();
	kill_attached_if_needed(1);
#endif
}
