
/***

othfilter.h - declarations for the non-TCP filter module
Written by Gerard Paul Java
Copyright (c) Gerard Paul Java 1997
			
***/

#include <sys/types.h>
#include <netinet/udp.h>
#ifndef _I386_TYPES_H
#include <asm/types.h>
#endif

struct othpoptions {
    char filename[40];		/* these are for the UDP filters */
    struct filterlist fl;
    unsigned int filtercode;

    __u16 udp:1, icmp:1, ospf:1, igp:1, igmp:1, igrp:1, arp:1, rarp:1,
     padding:8;
};

void othfilterselect(struct othpoptions *filter);
void loadothfilter(struct othpoptions *filter);
void saveothfilter(struct othpoptions *filter);
int othfilterok(struct othpoptions *filter, unsigned int protocol,
		unsigned long saddr, unsigned long daddr,
		unsigned int sport, unsigned int dport);
