/**************************************************************************
 * LPRng IFHP Filter
 * Copyright 1994-1997 Patrick Powell, San Diego, CA <papowell@astart.com>
 *
 * Based on the CTI printer filters.
 *  See COPYRIGHT for details.
 *
 * open_device.c,v 3.2 1998/03/19 14:21:36 papowell Exp
 */

#include "portable.h"
#include "common.h"
#include "errorcodes.h"

extern char *device;
void Do_stty();

void open_device()
{
	char *s, *end;
	int i;
	int fd, port;
	struct hostent *hostent;
	struct sockaddr_in sin;
	int src_port = 0;
	char dcopy[128];

	log(3,"open_device: device '%s'", device);
	strncpy( dcopy, device, sizeof(dcopy)-1 );
	dcopy[sizeof(dcopy)-1] = 0;

	if( (dcopy[0] == '/') ){
		fd = open( dcopy, O_RDWR );
		if( fd < 0 ){
			logerr(0,"open_device: open '%s' failed");
			fexit( JABORT );
		}
		if( fd != 1 ){
			if( dup2( fd, 1 ) < 0 ){
				logerr(0,"open_device: open '%s' failed",dcopy);
				fexit( JABORT );
			}
			close( fd );
		}
		if( isatty( 1 ) && stty_args){
			Do_stty( 1, stty_args );
		}
	} else {
		if( (s = strchr( dcopy, '%' )) == 0 ){
			log(1,"open_device: missing port number '%s'",dcopy );
			fexit( JABORT );
		}
		end = s+1; 
		port = strtol( end, &end, 0 );
		if( port <= 0 ){
			log(1,"open_device: bad port number '%s'",s+1 );
			fexit( JABORT );
		}
		if( end && *end ){
			src_port = atoi( end+1 );
		}
		*s = 0;
		memset( &sin, 0, sizeof(sin) );
		sin.sin_family = AF_INET;
		if( (hostent = gethostbyname(dcopy)) ){
			/*
			 * set up the address information
			 */
			if( hostent->h_addrtype != AF_INET ){
				log(1,"open_device: bad address type for host '%s'", dcopy);
				fexit( JABORT );
			}
			memcpy( &sin.sin_addr, hostent->h_addr, hostent->h_length );
		} else {
			sin.sin_addr.s_addr = inet_addr(dcopy);
			if( sin.sin_addr.s_addr == -1){
				log(1,"open_device: getconnection: unknown host '%s'", dcopy);
				fexit( JABORT );
			}
		}
		sin.sin_port = htons( port );
		log(2,"open_device: destination '%s' port %d",
			inet_ntoa( sin.sin_addr ), ntohs( sin.sin_port ) );
		fd = socket (AF_INET, SOCK_STREAM, 0);
		if( fd >= 0 && src_port ){
			struct sockaddr_in src_sin;
			memset( &src_sin, 0, sizeof(src_sin) );
			src_sin.sin_family = AF_INET;
			src_sin.sin_port = htons( src_port );
			if( bind( fd, (struct sockaddr *)&src_sin,
				sizeof( src_sin )) < 0 ){
				logerr(0,"open_device: bind failed");
				fexit(JABORT);
			}
		}
		if (fd < 0) {
			logerr(0,"open_device: socket call failed");
			fexit( JABORT );
		}
		i = connect (fd, (struct sockaddr *) & sin, sizeof (sin));
		if( i < 0 ){
			logerr(0,"open_device: connect to '%s port %d' failed",
				inet_ntoa( sin.sin_addr ), ntohs( sin.sin_port ) );
			fexit(JABORT);
		}
		if( fd != 1 ){
			log(4,"open_device: dup %d to %d", fd, 1 );
			if( dup2( fd, 1 ) < 0 ){
				logerr(0,"open_device: dup failed");
				fexit(JABORT);
			}
			close( fd );
		}
	}
}
