/**************************************************************************
 * LPRng IFHP Filter
 * Copyright 1994-1997 Patrick Powell, San Diego, CA <papowell@astart.com>
 *
 * Based on the CTI printer filters.
 *  See COPYRIGHT for details.
 *
 * ifhp.c,v 3.3 1998/03/29 23:03:08 papowell Exp
 */

#include "portable.h"
#include "common.h"
#include "hp4.h"

static const char *const idallf = "@(#) Computer Technology Institute, CTI-Print Project";
static const char *const idhp4 = "@(#)       Filter for HP LaserJet 4, V 1.2 \n" ;
static const char *const idifhp4 = "@(#) ifhp4.c 95/08/23 - V 1.15" ;

int main(argc,argv,envp)
int argc;
char *argv[];
char *envp[];
{
	unsigned long starttime, endtime;
	int elapsed;

	Envp = envp;
	debug = 2;

	/* save the PID */
	starttime = time( (void *)0 );
	filterpid = getpid();

	Accounting_fd = dup(0);
	if( Accounting_fd == 4 ){
		close( Accounting_fd );
		Accounting_fd = 3;
	} else {
		close( Accounting_fd );
		Accounting_fd = 0;
	}

	getargs( argc, argv );
	get_info();

	errorcode = FILTABORT;
	plp_snprintf(job_start,sizeof(job_start)-1,
		"NAME=\"Start of CTI-Print Job: %d\"",getpid());
	plp_snprintf(job_end,sizeof(job_end)-1,
		"NAME=\"End of CTI-Print Job: %d\"", getpid() );


	(void)signal(SIGINT, cleanup);
	(void)signal(SIGHUP, cleanup);
	(void)signal(SIGTERM, cleanup);
	(void)signal(SIGQUIT, cleanup);
	(void)signal(SIGPIPE, SIG_IGN);

	/* open device if specified */
	if( device ) open_device();

	log(4,"%s: get_status %d", name, get_status );
#if defined(F_GETFL)
	if( get_status ){
		int status;
		log(4,"%s: trying fcntl", name );
		status = fcntl( 1, F_GETFL );
		log(4,"%s: fcntl returned 0x%x, O_RDWR = 0x%x", name, status, O_RDWR );
		if( (status & O_RDWR) == 0 ){
			log(4,"%s: cannot read stdout, not getting status", name );
			get_status = 0;
		}
	}
#endif

	/* set up the initialization of the printer, and start monitoring */
	do_monitor();

	doaccnt(0);

	if( of_filter ){
		log(2,"Starting of_filter actions");
		do_of_stream(stdin, STDOUT );
	} else {
		sendjob(0, STDOUT );
	}


	while( monitpid > 0 ) {
		int pid, status;
		log(3,"stopping monitor %d", monitpid);
		kill(monitpid,SIGTERM);
		kill(monitpid,SIGCONT);
		pid = waitpid( monitpid, &status, 0 );
		if( pid == monitpid || (pid == -1 && errno == ECHILD)) monitpid = -1;
		log(3,"%s: monitor %d exit status %d", name, pid, status );
	}

	/* terminate job */
	tbcp_enabled = 0;
	/* this is NOT what we should be sending,  but it appears to
		avoid error messages from PCL/PostScript printers ... 
	    Sigh.
	*/
	header_info();

	/* get the status and end of job */
	npages = -1;
	if( get_status ){
		if( sync_printer ) check_job_end();
		if( pagecount && forcepagecount == 0 ){
			npages = pr_pagecount(STDOUT);
			if( npages < 0 ){
				log (2, "No pagecount using PJL INFO.");
			}
		}
		if (npages < 0 || forcepagecount ) {
			npages = pr_pspagecount(STDOUT);
			if (npages < 0)  {
				log (2, "No pagecount using PostScript");
			}
		}
	}

	endtime = time( (void *)0 );
	elapsed = endtime - starttime;
	if( elapsed == 0 ) ++elapsed;
	log(2,"Initial page count %d, final %d, Total pages = %d, elapsed time %d secs",
		initialpagecount, npages, npages - initialpagecount, elapsed );
	doaccnt(elapsed);

	fexit(FILTSUCC);
	return( 0 );
}
