/* GtkSQL -- an interactive graphical query tool for PostgreSQL
 * Copyright (C) 1998  Lionel ULMER
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <strings.h>

#include "common.h"

/* Some functions that should be in gtk_notebook... */
GtkNotebookPage *gtk_notebook_get_bookpage(GtkNotebook *notebook,
					   gint position) {
  GList *children;
  gint page_num;
  GtkNotebookPage *ret = NULL;

  page_num = 0;
  children = notebook->children;
  while (children != NULL) {
    GtkNotebookPage *page = children->data;

    if (page_num == position) {
      ret = page;
      break;
    }
    
    children = children->next;
    page_num++;
  }

  return ret;
}

GtkWidget *gtk_notebook_get_page(GtkNotebook *notebook,
				 gint position) {
  GtkNotebookPage *page = gtk_notebook_get_bookpage(notebook, position);

  if (page == NULL)
    return NULL;
  else
    return page->child;
}

GtkWidget *gtk_notebook_get_tab_label(GtkNotebook *notebook,
				      gint position) {
  GtkNotebookPage *page = gtk_notebook_get_bookpage(notebook, position);
  
  if (page == NULL)
    return NULL;
  else
    return page->tab_label;
}

GtkWidget *gtk_notebook_get_menu_label(GtkNotebook *notebook,
				       gint position) {
  GtkNotebookPage *page = gtk_notebook_get_bookpage(notebook, position);
  
  if (page == NULL)
    return NULL;
  else
    return page->menu_label;
}
