/* 
 *  gstalker stock charter
 * 
 *  Copyright (c) 1998 Stefan S. Stratigakos
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, 
 *  USA.
 */

#include "myheader.h"
#include "myerrors.h"
#include <string.h>
#include <ctype.h>
#include <unistd.h>
#include <dirent.h>
#include <tcp4u.h>
#include <http4u.h>



/**************************************************************************************/
void add_quote()
{
	char *text, *line[2];
	extern char *error_message;
	extern GtkWidget *quote_entry, *quotes_clist;
	
	
	text = gtk_entry_get_text(GTK_ENTRY(quote_entry));
	if (strlen(text) < 1)
		RETURN_ERR(gs_nothing_entered);
		
	line[0] = text;
	line[1] = NULL;
	gtk_clist_append (GTK_CLIST (quotes_clist), line);
}
/***************************************************************************************/
void delete_quote()
{
	GList *list;
	int tint;
	extern GtkWidget *quotes_clist;
	extern char *error_message;
	
	
	list = GTK_CLIST (quotes_clist)->selection;
	if (list)
	{
		tint = (int) list->data;
		gtk_clist_remove(GTK_CLIST(quotes_clist), tint);
	}
	else
		RETURN_ERR(gs_nothing_selected);
}
/***************************************************************************************/
void select_all_quote()
{
	int tint, tint2=0;
	char *text;
	extern GtkWidget *quotes_clist;
	
	
	gtk_clist_freeze (GTK_CLIST (quotes_clist));
	while (tint2 > -1)
	{
		tint = gtk_clist_get_text (GTK_CLIST (quotes_clist), tint2, 0, &text);
		if (! tint)
			break;
		else
		{
			gtk_clist_select_row(GTK_CLIST(quotes_clist), tint2, 0);
			tint2++;
		}
	}
	gtk_clist_thaw (GTK_CLIST (quotes_clist));
}
/*************************************************************************************/
void unselect_all_quote()
{
	int tint, tint2=0;
	char *text;
	extern GtkWidget *quotes_clist;
	
	
	gtk_clist_freeze (GTK_CLIST (quotes_clist));
	while (tint2 > -1)
	{
		tint = gtk_clist_get_text (GTK_CLIST (quotes_clist), tint2, 0, &text);
		if (! tint)
			break;
		else
		{
			gtk_clist_unselect_row(GTK_CLIST(quotes_clist), tint2, 0);
			tint2++;
		}
	}
	gtk_clist_thaw (GTK_CLIST (quotes_clist));
}
/**************************************************************************************/
void parse_quotes()
{
	unsigned long date2=0, volume=0;
	int tint, tint2, found = 0;
	FILE *infile;
	char tstring[250], symbol[25], date[25], openint[15], *tstringp, *tstringp2;
	float tfloat = 0, close=0, open=0, high=0, low=0;
	extern int header_size;
	extern char *datapath;
	extern struct record2 header;
	
	
	
	infile = fopen("/tmp/quotes.csv", "r");
	if (! infile)
		return;
	fgets(tstring, 250, infile);
	fclose(infile);
	tint = strlen(tstring);
	for (tint2 = 0; tint2 < tint; tint2++)
	{
		if (tstring[tint2] == ',')
			tstring[tint2] = ' ';
		if (tstring[tint2] == '"')
			tstring[tint2] = ' ';
	}
	sscanf(tstring, "%s %g %s %s %s %g %g %g %ld", symbol, &close, date, openint, openint, &open, &high, &low, &volume);
	tint = strlen(date);
	openint[0] = date[tint - 4];
	openint[1] = date[tint - 3];
	openint[2] = date[tint - 2];
	openint[3] = date[tint - 1];
	if (date[0] == '1')
	{
		openint[4] = date[0];
		openint[5] = date[1];
	}
	else
	{
		openint[4] = '0';
		openint[5] = date[0];
	}
	tstringp = strchr(date, '/');
	tstringp2 = strrchr(date, '/');
	tint = tstringp2 - tstringp;
	if (tint < 3)
	{
		openint[6] = '0';
		openint[7] = *(tstringp + 1);
	}
	else
	{
		openint[6] = *(tstringp + 1);
		openint[7] = *(tstringp + 2);
	}
	openint[8] = 0;
	if (strlen(openint) != 8)
		return;
	date2 = atol(openint);
	
	
	strcpy(tstring, datapath);
	strcat(tstring, symbol);
	infile = fopen(tstring, "rb");
	if (infile)
	{
		fread(&header, header_size, 1, infile);
		fclose(infile);
		if (date2 > header.last_date)
			append_chart_record(tstring,date2,open,high,low,close,volume,tfloat);
		else
		{
			found = find_chart_record(tstring, date2);
			if (found > -1)
				overwrite_chart_record (tstring, found, date2, open, high, low, close, volume, tfloat);
			else
				insert_chart_record(tstring, date2, open, high, low, close, volume,tfloat);
		}
	}
	else
	{
		tint = create_new_chart(symbol);
		if (tint) 
			return;
		else
			append_chart_record(tstring,date2,open,high,low,close,volume,tfloat);
	}
}
/*****************************************************************************************/
void ok_update_quotes()
{
	float tfloat;
	GList *list=NULL;
	int counter=1, tint, tint2, tint3;
	char *text, tstring[250], url[250], proxy[250];
  	extern char *error_message, yahoo_server[], data_file[];
  	extern GtkWidget *quotes_label, *quotes_clist, *quotes_bar;
  	extern struct record3 config;
  	

	
	if (strlen(config.proxy) < 1)
		proxy[0] = 0;
	else
		strcpy(proxy, config.proxy);
	if (proxy[0] != 0)
	{
		sprintf(tstring, "%d", config.port);
		strcat(proxy, ":");
		strcat(proxy, tstring);
	}
	list = GTK_CLIST (quotes_clist)->selection;
	if (list)
	{
		tint2 = g_list_length(list);
		sprintf(tstring, "Connecting to %s...", yahoo_server);
		gtk_label_set(GTK_LABEL(quotes_label), tstring);
		while (list)
		{
			tint = (int) list->data;
			gtk_clist_get_text (GTK_CLIST (quotes_clist), tint, 0, &text);
   			sprintf(tstring, "Downloading %s...", text);
			gtk_label_set(GTK_LABEL(quotes_label), tstring);
   			sprintf(url, "http://%s/d/quotes.csv?s=%s&f=sl1d1t1c1ohgv&e=.csv", yahoo_server, text);
   			if (proxy[0] == 0)
   				tint3 = HttpGetFile(url, NULL, data_file);
   			else
   				tint3 = HttpGetFile(url, proxy, data_file);
   			if (tint3 == HTTP4U_SUCCESS)
   				parse_quotes();
   			else
   			{
   				sprintf(tstring, "%s", Http4uErrorString(tint3));
   				strcat(tstring, ".");
   				tstring[0] = toupper(tstring[0]);
   				error_message = (char *)malloc(sizeof(tstring) + 1);
				strcpy(error_message, tstring);
   				display_message();
   				strcpy(tstring, "Idle");
				gtk_label_set(GTK_LABEL(quotes_label), tstring);
				gtk_progress_bar_update(GTK_PROGRESS_BAR (quotes_bar), 1.0);
   				return;
   			}
   			tfloat = ((float)counter / tint2);
			if (tfloat > 1.0)
				tfloat = 1.0;
			if (tfloat < 0.0)
				tfloat = 0.0;
			gtk_progress_bar_update (GTK_PROGRESS_BAR (quotes_bar), tfloat);
			while (gtk_events_pending())
				gtk_main_iteration();
			list = list->next;
			update_clist_entry(tint, text, quotes_clist);
			gtk_clist_unselect_row(GTK_CLIST(quotes_clist), tint, 0);
			counter++;
   		}
   	}
   	else
	  	RETURN_ERR(gs_nothing_selected);
	  	
        strcpy(tstring, "Idle");
	gtk_label_set(GTK_LABEL(quotes_label), tstring);
	unlink("/tmp/quotes.csv");
}
/******************************************************************************************/
void show_update_quotes()
{
	extern GList *source_list;
	gchar *text[] = {"Symbol", "Name", "Start", "End"};
   	GtkWidget *vbox, *vbox2, *hbox, *button, *button2, *button3, *frame, *vbox3, *frame3;
   	GtkWidget *hbox2, *hbox3, *hbox4, *frame2, *button4, *button5, *button6, *button7, *hbox5;
	extern GtkWidget *quotes_clist, *update_quotes_window, *quote_entry;
	extern GtkWidget *quotes_label, *quotes_bar, *source_combo;
    	extern struct record3 config;
   	
   	
   	if (update_quotes_window)
   		return;
   		
   	update_quotes_window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
	gtk_signal_connect (GTK_OBJECT (update_quotes_window), "destroy",
			    GTK_SIGNAL_FUNC (gtk_widget_destroyed), &update_quotes_window);
	gtk_window_position(GTK_WINDOW (update_quotes_window), GTK_WIN_POS_CENTER);
	gtk_window_set_title (GTK_WINDOW (update_quotes_window), "Update Quotes");
	gtk_widget_set_usize(GTK_WIDGET (update_quotes_window), 0, 0);
	
	hbox = gtk_hbox_new (FALSE, 10);
      	gtk_container_add (GTK_CONTAINER (update_quotes_window), hbox);
      	gtk_container_border_width (GTK_CONTAINER (hbox), 10);
      	gtk_widget_show (hbox);
      	
      	vbox = gtk_vbox_new (FALSE, 10);
      	gtk_box_pack_start (GTK_BOX (hbox), vbox, FALSE, TRUE, 0);
      	gtk_widget_show (vbox);
      	
      	vbox2 = gtk_vbutton_box_new();
      	gtk_container_border_width (GTK_CONTAINER (vbox2), 5);
      	gtk_box_pack_start (GTK_BOX (hbox), vbox2, FALSE, TRUE, 0);
     	gtk_vbutton_box_set_spacing_default(5);
        gtk_vbutton_box_set_layout_default(GTK_BUTTONBOX_START);
      	gtk_widget_show(vbox2);
        
      	button = gtk_button_new_with_label("Download");
      	gtk_box_pack_start (GTK_BOX (vbox2), button, FALSE, TRUE, 0);
      	gtk_signal_connect (GTK_OBJECT (button), "clicked",
			    GTK_SIGNAL_FUNC (ok_update_quotes), NULL);
      	gtk_widget_show (button);
      	
      	button4 = gtk_button_new_with_label("Select All");
      	gtk_box_pack_start (GTK_BOX (vbox2), button4, FALSE, TRUE, 0);
      	gtk_signal_connect (GTK_OBJECT (button4), "clicked",
			    GTK_SIGNAL_FUNC (select_all_quote), NULL);
      	gtk_widget_show (button4);
      	
      	button7 = gtk_button_new_with_label("Unselect All");
      	gtk_box_pack_start (GTK_BOX (vbox2), button7, FALSE, TRUE, 0);
      	gtk_signal_connect (GTK_OBJECT (button7), "clicked",
			    GTK_SIGNAL_FUNC (unselect_all_quote), NULL);
      	gtk_widget_show (button7);
      	
      	button6 = gtk_button_new_with_label("Delete");
      	gtk_box_pack_start (GTK_BOX (vbox2), button6, FALSE, TRUE, 0);
      	gtk_signal_connect (GTK_OBJECT (button6), "clicked",
			    GTK_SIGNAL_FUNC (delete_quote), NULL);
      	gtk_widget_show (button6);
      	
      	button2 = gtk_button_new_with_label("Cancel");
      	gtk_box_pack_start (GTK_BOX (vbox2), button2, FALSE, TRUE, 0);
      	gtk_signal_connect_object (GTK_OBJECT (button2), "clicked",
			    GTK_SIGNAL_FUNC (gtk_widget_destroy),
			    GTK_OBJECT(update_quotes_window));
      	gtk_widget_show (button2);
      	
      	button3 = gtk_button_new_with_label("Help");
      	gtk_box_pack_start (GTK_BOX (vbox2), button3, FALSE, TRUE, 0);
      	gtk_signal_connect (GTK_OBJECT (button3), "clicked",
			    GTK_SIGNAL_FUNC (help_update_quotes_window), NULL);
      	gtk_widget_show (button3);
      	
      	hbox5 = gtk_hbox_new(FALSE, 10);
      	gtk_box_pack_start (GTK_BOX (vbox), hbox5, TRUE, TRUE, 0);
      	gtk_widget_show(hbox5);
      	
      	frame2 = gtk_frame_new("Quote Source:");
      	gtk_box_pack_start (GTK_BOX (hbox5), frame2, TRUE, TRUE, 0);
      	gtk_widget_show(frame2);
      	
      	source_combo = gtk_combo_new ();
      	gtk_combo_set_popdown_strings (GTK_COMBO (source_combo), source_list);
      	gtk_entry_set_text(GTK_ENTRY(GTK_COMBO(source_combo)->entry), config.source);
      	gtk_container_add (GTK_CONTAINER (frame2), source_combo);
      	gtk_container_border_width (GTK_CONTAINER (source_combo), 5);
      	gtk_entry_set_text(GTK_ENTRY(GTK_COMBO(source_combo)->entry), "Yahoo");
      	gtk_entry_set_editable(GTK_ENTRY(GTK_COMBO(source_combo)->entry), FALSE);
      	gtk_widget_show (source_combo);
      	
      	frame3 = gtk_frame_new("Add Symbol:");
      	gtk_box_pack_start (GTK_BOX (hbox5), frame3, TRUE, TRUE, 0);
      	gtk_widget_show(frame3);
      	
      	hbox4 = gtk_hbox_new(FALSE, 10);
      	gtk_container_add (GTK_CONTAINER (frame3), hbox4);
      	gtk_container_border_width (GTK_CONTAINER (hbox4), 5);
      	gtk_widget_show(hbox4);
      	
      	quote_entry = gtk_entry_new();
      	gtk_box_pack_start (GTK_BOX (hbox4), quote_entry, TRUE, TRUE, 0);
      	gtk_widget_show(quote_entry);
      	
      	button5 = gtk_button_new_with_label("Add");
      	gtk_box_pack_start (GTK_BOX (hbox4), button5, TRUE, TRUE, 0);
      	gtk_signal_connect (GTK_OBJECT (button5), "clicked",
			    GTK_SIGNAL_FUNC (add_quote), NULL);
      	gtk_widget_show (button5);
      	
      	quotes_clist = gtk_clist_new_with_titles (4, text);
      	gtk_clist_set_selection_mode (GTK_CLIST (quotes_clist), GTK_SELECTION_MULTIPLE);
	gtk_clist_set_column_width (GTK_CLIST (quotes_clist), 0, 100);
	gtk_clist_set_column_width (GTK_CLIST (quotes_clist), 1, 150);
	gtk_clist_set_column_width (GTK_CLIST (quotes_clist), 2, 65);
	gtk_clist_set_column_width (GTK_CLIST (quotes_clist), 3, 65);
	gtk_clist_set_column_justification (GTK_CLIST (quotes_clist), 0,GTK_JUSTIFY_LEFT);
       	gtk_clist_set_policy (GTK_CLIST (quotes_clist),GTK_POLICY_AUTOMATIC,GTK_POLICY_AUTOMATIC);
      	gtk_container_add (GTK_CONTAINER (vbox), quotes_clist);
      	gtk_widget_set_usize(GTK_WIDGET (quotes_clist), 450, 200);
      	gtk_widget_show (quotes_clist);
      	
      	frame = gtk_frame_new("Update Status:");
      	gtk_box_pack_start (GTK_BOX (vbox), frame, FALSE, TRUE, 0);
      	gtk_widget_show(frame);
      	
      	vbox3 = gtk_vbox_new(FALSE, 5);
        gtk_container_border_width (GTK_CONTAINER (vbox3), 5);
        gtk_container_add (GTK_CONTAINER (frame), vbox3);
      	gtk_widget_show(vbox3);
      	
      	hbox2 = gtk_hbox_new(FALSE, 5);
      	gtk_box_pack_start (GTK_BOX (vbox3), hbox2, FALSE, TRUE, 0);
      	gtk_widget_show(hbox2);
      	
      	quotes_label = gtk_label_new("Idle");
      	gtk_box_pack_start (GTK_BOX (hbox2), quotes_label, FALSE, TRUE, 0);
      	gtk_widget_show(quotes_label);
      	
      	hbox3 = gtk_hbox_new(FALSE, 0);
      	gtk_box_pack_start (GTK_BOX (vbox3), hbox3, FALSE, TRUE, 0);
      	gtk_widget_show(hbox3);
      	
      	quotes_bar = gtk_progress_bar_new ();
        gtk_box_pack_start (GTK_BOX (hbox3), quotes_bar, TRUE, TRUE, 0);
      	gtk_progress_bar_update (GTK_PROGRESS_BAR (quotes_bar), 1.0);
      	gtk_widget_show(quotes_bar);
			    
	show_chart_list(quotes_clist);
	gtk_widget_show(update_quotes_window);
}