#    Copyright (C) 1998  Dennis Roddeman
#    email: dennis.roddeman@uibk.ac.at
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
# 
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#   
#   
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software Foundation
#    59 Temple Place, Suite 330, Boston, MA, 02111-1307, USA

# globals
set switch 0
set window_offset +50+50
set cmd_array_length 0

global tnpath

# examples of tnpath: 
#   /home/dennis/tn (unix) 
#   c:/user/dennis/tn (ms windows) 
set tnpath ~/tn

#

source $tnpath/vtn/global.tcl

set directory_start [pwd]

if       {"$tcl_platform(platform)" == "unix"} {
  set platform unix
} elseif {"$tcl_platform(platform)" == "windows"} {
  set platform windows
} else {
  error_show "Sorry, vtn is not available on this platform."
}

# create main window

eval destroy [winfo child .]
wm title . "Visual Tochnog"
wm geometry . 500x25
wm geometry . +50+0

#  vtnmbar

frame .vtnmbar -relief raised -bd 2
frame .dummy -width 10c -height 5c

pack .vtnmbar .dummy -side top -fill x

menubutton .vtnmbar.file -text File -menu .vtnmbar.file.menu
menubutton .vtnmbar.edit -text Edit -menu .vtnmbar.edit.menu
menubutton .vtnmbar.run  -text Run  -menu .vtnmbar.run.menu
menubutton .vtnmbar.view -text View -menu .vtnmbar.view.menu
menubutton .vtnmbar.search -text Search -menu .vtnmbar.search.menu
menubutton .vtnmbar.help -text Help -menu .vtnmbar.help.menu

pack .vtnmbar.file .vtnmbar.edit .vtnmbar.run .vtnmbar.view -side left
pack .vtnmbar.help -side right
pack .vtnmbar.search -side right

# vtnmbar file 

set m .vtnmbar.file.menu
menu $m
$m add command -label "File Open/Save/View" -command { file_file }
$m add command -label "Quit" -command { exit }

# vtnmbar edit 

set m .vtnmbar.edit.menu
menu $m
$m add command -label "Initia" -command { edit_initia }
$m add command -label "Data" -command { edit_data }

# vtnmbar run 

set m .vtnmbar.run.menu
menu $m
$m add command -label "Run in foreground" -command { run user_run foreground}
$m add command -label "Run in background" -command { run user_run background}

# vtnmbar view 

set m .vtnmbar.view.menu
menu $m
$m add command -label "VtnVtk" -command { vtnvtk }
$m add command -label "Gmv" -command { exec gmv & }
$m add command -label "Gnuplot" -command { exec gnuplot & }
$m add command -label "Matlab" -command { exec matlab & }
$m add command -label "Melati" -command { exec melati & }
$m add command -label "Plotmtv" -command { exec plotmtv plotmtv.dat & }
$m add command -label "Tecplot" -command { exec tecplot tecplot.plt & }

# vtnmbar search 

set m .vtnmbar.search.menu
menu $m
$m add command -label "Data" -command { search_data }
$m add command -label "File" -command { search_file }

# vtnmbar help 

set m .vtnmbar.help.menu
menu $m
$m add command -label "About" -command {
  help "Visual Tochnog is developed and copyrighted by Dennis Roddeman. The Gnu Public License applies."
}
$m add command -label "Help on menu bar" -command { 
  help "File.\n  Open/Save/View: open, save or view file.\n  Quit: quit.\n\nEdit.\n  Initia: edit initia part.\n  Data: edit data part.\n\nRun.\n  Run in foreground: run and wait till job finishes.\n  Run in background: run and don't wait till job finishes.\n  Vtn will run jobs by calling tn with input file vtn.dat and output file vtn.out.\n\nView.\n  View calculation results.\n\nSearch.\n  Data: Search for data items containing ...\n  Files: Search for file in test directory containing ...\n"
}
$m add command -label "Limitations of vtn" -command {
  help "Visual Tochnog uses files vtn.* for communication with tochnog. You should not use such file names yourself."
}

#   include tcl files

  source $tnpath/vtn/file.tcl
  source $tnpath/vtn/edit_initia.tcl
  source $tnpath/vtn/edit_data.tcl
  source $tnpath/vtn/run.tcl
  source $tnpath/vtn/vtnvtk.tcl
  source $tnpath/vtn/search_data.tcl
  source $tnpath/vtn/search_file.tcl
  source $tnpath/vtn/help.tcl
  source $tnpath/vtn/initia.tcl
  source $tnpath/vtn/miscel.tcl
  source $tnpath/vtn/TkInteractor.tcl

#  initialise
  initia_initialise
  run only_initia foreground
  data_initialise

#

tk_menuBar .vtnmbar .vtnmbar.edit .vtnmbar.run .vtnmbar.view .vtnmbar.help
focus .vtnmbar
