\name{mcmc}
\title{Markov Chain Monte Carlo Objects}

\usage{mcmc(data= NA, start = 1, end = numeric(0), thin = 1, ts.eps = .Options$ts.eps))}
\alias{as.mcmc(x)}
\alias{is.mcmc(x)}

\alias{print(mcmc.obj, ...)
\alias{summary(mcmc.obj, quantiles = c(0.02, 0.25, 0.5, 0.75, 0.98), batch.size = 25, combine.chains = F, ...)}

\arguments{
\item{data}{a vector, matrix or 3d-array of MCMC output}
\item{start}{the iteration number of the first observation}
\item{end}{the iteration number of the last observation}
\item{thin}{the thinning interval between consecutive observations}
\item{ts.eps}{Hmmm. What's this doing here? (MTP)}
}

\description{

The function `mcmc' is used to create Markov Chain Monte Carlo objects.
These are three dimensional arrays with a class of `ts' (and additional
attributes) which represent data which has been produced by a discrete
time Markov chain.

MCMC objects resemble time series (\code{ts}) objects, but have the
additional property that the Markov Chain may be replicated, using a
different starting value and/or different seed for the pseudo random
number generator.  Hence mcmc objects are always three dimensional
arrays, with the first dimension representing time, the second dimension
representing variables and the third dimension representing replicates
of the Markov chain.

\code{start} and \end{end} are integers which correspond to iteration numbers.

\code{as.mcmc} and \code{is.mcmc} respectively coerce a vector, matrix or
array into a Markov Chain and test whether the object is a Markov
Chain.

Markov Chains have methods associated with the generic \code{print},
\code{start}, \code{end}, \code{thin}, \code{time} and \code{summary}
functions. 
}

\note{
When subscripting mcmc objects, the default value of the \code{drop}
parameter is FALSE. Hence mcmc objects will always retain their
dimensionality and their class when subscripted unless you explicitly
specify drop=TRUE.}

\author{Martyn Plummer}

\seealso{
\code{\link{start}},
\code{\link{end}},
\code{\link{frequency}},
\code{\link{thin}},
\code{\link{time}},
\code{\link{window}},
\code{\link{join.mcmc}}.
}

\keyword{ts}
