"print.summary.mcmc" <-
function (x, digits = max(3, .Options$digits - 3), ...) 
{
        cat("Iterations used = ", x$mcpar["start"], ":", x$mcpar["end"], 
                "\n", sep = "")
        cat("Thinning interval =", x$mcpar["thin"], "\n")
        cat("Sample size per chain =", (x$mcpar["end"] - x$mcpar["start"])/x$mcpar["thin"] + 
                1, "\n")
        if (x$combined) {
                cat("\nPooling over chains:\n", paste(x$chain.names, 
                        collapse = "\n"), "\n", sep = "")
        }
        cat("\n1. Empirical mean and standard deviation for each variable,")
        cat("\n   plus standard error of the mean:\n\n")
        if (length(dim(x$statistics)) == 3) 
                for (i in 1:(dim(x$statistics)[3])) {
                        cat("\n", x$chain.names[i], "\n", sep = "")
                        print(x$statistics[, , i], digits = digits, 
                                ...)
                }
        else print(x$statistics, digits = digits, ...)
        cat("\n2. Quantiles for each variable:\n\n")
        if (length(dim(x$quantiles)) == 3) 
                for (i in 1:(dim(x$quantiles)[3])) {
                        cat("\n", x$chain.names[i], "\n", sep = "")
                        print(x$quantiles[, , i], digits = digits, 
                                ...)
                }
        else print(x$quantiles, digits = digits, ...)
        invisible(x)
}
