function __pl_draw_legend(xm, xM, ym, yM)

global __pl

__pl_strm = plgstrm+1;

[a b] = plgchr;

# why 100? it works with me... docs say its units are mm, my monitor has ~100 dpi!?
# Fonts are of proportional width

ch_height = (b * __pl.multi_row(__pl_strm)) / 100;
ch_width = (b * __pl.multi_col(__pl_strm)) / 100;	# FIXME! not always OK.

if (!ishold)
	__pl.lab_str(1,:) = "";
endif

plwind(-0.01, 1.01, -0.01, 1.01);	# this makes it independent of the scale

llm = ch_width * columns(__pl.lab_str)/2;
xxl= __pl.legend_xpos(__pl_strm) - llm * __pl.legend_xpos(__pl_strm);
xxr= __pl.legend_xpos(__pl_strm) + llm * (1-__pl.legend_xpos(__pl_strm));
yyt = __pl.legend_ypos(__pl_strm);
yyb = (__pl.legend_ypos(__pl_strm) - ch_height * __pl.lab_pos(__pl_strm));

if (__pl.legend(__pl_strm) == 2)	# opaque
	plcol(0);	# background color (erase lines behind legend)
	plfill([xxl;xxr;xxr;xxl], [yyb; yyb; yyt; yyt])
	plcol(15);pllsty(1);
	plline([xxl;xxr;xxr;xxl;xxl], [yyb; yyb; yyt; yyt;yyb])
endif
	
for i=1:__pl.lab_pos(__pl_strm)-1
	xx = __pl.legend_xpos(__pl_strm);
	yy = (__pl.legend_ypos(__pl_strm) - ch_height * i);

	plcol(15);
	plptex(xx, yy, 0, 0, __pl.legend_xpos(__pl_strm), __pl.lab_str(i,:));
	plcol(__pl.lab_col(__pl_strm,i)); pllsty(__pl.lab_lsty(__pl_strm,i)); 
	plline([xxl; xxr],[yy-ch_height/2; yy-ch_height/2]);
endfor

#restore size
plwind(__pl.axis(__pl_strm,1), __pl.axis(__pl_strm,2), __pl.axis(__pl_strm,3), __pl.axis(__pl_strm,4))

endfunction
