## Copyright (C) 1996, 1997  Friedrich Leisch
## 
## This program is free software; you can redistribute it and/or modify
## it under the terms of the GNU General Public License as published by
## the Free Software Foundation; either version 2, or (at your option)
## any later version.
## 
## This program is distributed in the hope that it will be useful, but
## WITHOUT ANY WARRANTY; without even the implied warranty of
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
## General Public License for more details. 
## 
## You should have received a copy of the GNU General Public License
## along with this file.  If not, write to the Free Software Foundation,
## 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

## usage:  [in, out] = spiral_set (n, m, s)
##
## Returns a 2 class training set for a generalization of the two
## spirals problem. The two classes consist of spirals with n points per
## cycle and m cycles. Hence a training set is of size 2*n*m.
##
## If s is not zero, the points have Gaussian noise with mean zero and
## variance s^2 normal to the direction of the spiral.

## Author:  FL <Friedrich.Leisch@ci.tuwien.ac.at>
## Description:  Data for 2 spirals classification problem
  
function [in, out] = spiral_set (n, m, s);

  if (nargin == 2)
    s = 0;
  endif
  
  in = [spiral (n, m, s); - spiral (n, m, s)];
  out = [ones (n * m, 1)  zeros (n * m, 1)
         zeros (n * m, 1) ones (n * m, 1) ];
  
endfunction

  