/* Copyright (c) 1992 The Geometry Center; University of Minnesota
   1300 South Second Street;  Minneapolis, MN  55454, USA;
   
This file is part of geomview/OOGL. geomview/OOGL is free software;
you can redistribute it and/or modify it only under the terms given in
the file COPYING, which you should have received along with this file.
This and other related software may be obtained via anonymous ftp from
geom.umn.edu; email: software@geom.umn.edu. */

/* Authors: Charlie Gunn, Stuart Levy, Tamara Munzner, Mark Phillips */

#include "bboxP.h"

BBox *
BBoxFSave(BBox *bbox, FILE *f, char *fname)
{
    if (bbox->geomflags & VERT_4D)	{
      fprintf(f, "4BBOX\n%g %g %g %g\n%g %g %g %g\n",
	bbox->min.x, bbox->min.y, bbox->min.z, bbox->min.w,
	bbox->max.x, bbox->max.y, bbox->max.z, bbox->max.w);
	}
    else	{
      fprintf(f, "BBOX\n%g %g %g\n%g %g %g\n",
	bbox->min.x, bbox->min.y, bbox->min.z,
	bbox->max.x, bbox->max.y, bbox->max.z);
	}
    return bbox;
}
