/* Copyright (c) 1993 The Geometry Center; University of Minnesota
   1300 South Second Street;  Minneapolis, MN  55454, USA;
   
This file is part of geomview/OOGL. geomview/OOGL is free software;
you can redistribute it and/or modify it only under the terms given in
the file COPYING, which you should have received along with this file.
This and other related software may be obtained via anonymous ftp from
geom.umn.edu; email: software@geom.umn.edu. */

/* Authors: Olaf Holt */


#include <ooglutil.h>
#include "hpointn.h"
#include <math.h>

HPointN *
HPtNCreate(int dim, const HPtNCoord *vec)
{
    HPointN *pt = OOGLNewE(HPointN, "new HPointN");
/*    pt->space = 0;  			*/
    if(dim <= 0) dim = 1;
    pt->dim = dim;
    pt->v = OOGLNewNE(HPtNCoord, dim, "new HPointN data");
	if(vec == NULL) {
	    memset(pt->v, 0, dim*sizeof(HPtNCoord));
	    pt->v[dim-1] = 1;
	} else
	    memcpy(pt->v, vec, dim*sizeof(HPtNCoord));
    return pt;
}

void
HPtNDelete(HPointN *pt)
{
    if(pt) {
	if(pt->v) OOGLFree(pt->v);
	OOGLFree(pt);
    }
}
