// print_integer().

// General includes.
#include "cl_sysdep.h"

// Specification.
#include "cl_print.h"


// Implementation.

#include "cl_io.h"
#include "cl_I.h"
#include "cl_DS.h"

void print_integer (cl_ostream stream, unsigned int base, const cl_I& z)
{
	var cl_I abs_z;
	if (minusp(z)) {
		// z<0 -> Vorzeichen ausgeben:
		fprintchar(stream,'-');
		abs_z = -z;
	} else
		abs_z = z;
	SAVE_NUM_STACK // num_stack retten
	var uintL need = cl_digits_need(abs_z,base);
	var DYNAMIC_ARRAY(ziffern,uintB,need); // Platz fr die Ziffern
	var cl_digits erg; erg.LSBptr = &ziffern[need];
	I_to_digits(abs_z,(uintD)base,&erg); // Umwandlung in Ziffern
	// Ziffern ausgeben:
	{
		var uintB* ptr = erg.MSBptr;
		var uintL count = erg.len;
		do { fprintchar(stream,*ptr++); } until (--count==0);
	}
	FREE_DYNAMIC_ARRAY(ziffern);
}
