/*
 * gbuffy.h
 */

#ifndef _GBUFFY_H_
#define _GBUFFY_H_ 1

#include "config.h"

#include <stdio.h>
#include <sys/types.h>
#include <gtk/gtk.h>

#define STRING_LEN 256

enum BOXTYPE {UNKNOWN = -1, GB_MBOX = 0, GB_MMDF, GB_MAILDIR, GB_MH, GB_IMAP, 
  GB_NNTP, GB_EXTERNAL, GB_MAX};

enum {
  GB_DETACH_PROCESS = 1
};

typedef struct _box_info
{
  GtkWidget *w;
  GtkWidget *button;
  GdkPixmap *pixmap;
  int selected;
  int leave;          /* denotes if mouse left window before release */

  enum BOXTYPE type;
  char *title;
  char *path;
  char *server;
  int port;
  char *login;
  char *pass;

  GList *headers;
  int face;		/* denotes if headers list contains an X-Face: */

  time_t st_mtime;
  off_t st_size;

  int new_messages;
  int num_messages;

  int height;

  char *command;

  struct _box_info *next;
} BOX_INFO;

typedef struct _box_class
{
  char *name;
  int (*count)(struct _box_info *, int, GList *);
/* void (*browse)(struct _box_info *); */
  int server;
} BOX_CLASS;

typedef struct _message_info
{
  char *from;
  char *subject;
  char *face;
} MESSAGE_INFO;

/* Global Variables */
extern int Vertical;
extern char *Homedir;
extern char *Maildir;
extern int PollTime;
extern BOX_INFO *MailboxInfo;
extern BOX_CLASS MailboxClass[];

#define FOREVER while (1)
#define NONULL(x) x?x:""
#define ISSPACE(c) isspace((unsigned char)c)
#define strfcpy(A,B,C) strncpy(A,B,C), *(A+(C)-1)=0

int mbox_folder_count (BOX_INFO *mbox, int force, GList *headers);
int dir_folder_count (BOX_INFO *mbox, int force, GList *headers);
int imap_folder_count (BOX_INFO *mbox, int force, GList *headers);
int nntp_folder_count (BOX_INFO *mbox, int force, GList *headers);
int external_folder_count (BOX_INFO *mbox, int force, GList *headers);

void gbuffy_configure_dialog ();
BOX_INFO *gbuffy_configure_load ();

/* lib.c */
void safe_free (void **p);
char *safe_strdup (const char *s);
char *gbuffy_expand_path (char *s, size_t slen);
void safe_realloc (void **p, size_t siz);
char *read_rfc822_line (FILE *f, char *line, size_t *linelen);

/* system.c */
int gbuffy_system (const char *cmd, int flags);
#endif /* _GBUFFY_H_ */
