
static char rcsid[] = "@(#)$Id: savecopy.c,v 1.5.4.1 1999/10/10 15:57:06 hurtta Exp $";

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 1.5.4.1 $   $State: Exp $
 *
 *  Modified by: Kari Hurtta <hurtta+elm@ozone.FMI.FI>
 ******************************************************************************
 *  The Elm Mail System 
 *
 * 			Copyright (c) 1988-1992 USENET Community Trust
 * 			Copyright (c) 1986,1987 Dave Taylor
 *****************************************************************************/

/** Save a copy of the specified message in a folder.

**/

#include "headers.h"
#include "s_elm.h"

#include <errno.h>
#include "me.h"


char *format_long(), *error_description(), *ctime();

extern int errno;

/*
 * save_copy() - Append a copy of the message contained in "filename" to
 * the file specified by "copy_file".  This routine simply gets all of
 * the filenames right, and then invokes "append_copy_to_file()" to do
 * the dirty work.
 */
int save_copy(headers, filename, copy_file, form, mime_info)
     struct mailing_headers * headers; 
     char *filename, *copy_file;
     int form;
     mime_send_t *mime_info;
{
    char  buffer[SLEN],	/* read buffer 		       */
	savename[SLEN],	/* name of file saving into    */
	msg_buffer[SLEN], answer;
    int
	is_ordinary_file;
    int  err;
    
    /* presume copy_file is okay as is for now */
    strfcpy(savename, copy_file, sizeof savename);
    
    /* if save-by-name wanted */
    if( (strcmp(copy_file, "=") == 0 || strcmp(copy_file, "=?") == 0) &&
	headers->to.addrs_len > 0) {
	
	/* determine 'to' login */
	get_return_name(headers->to.addrs[0].addr, 
			buffer, TRUE,  sizeof buffer);  	
	if (strlen(buffer) == 0) {
	    
	    /* can't get file name from 'to' -- use sent_mail instead */
	    dprint(3, (debugfile,
		       "Warning: get_return_name couldn't break down %s\n", 
		       headers->to.addrs[0].addr));
	    lib_error(CATGETS(elm_msg_cat, ElmSet, ElmCannotDetermineToName,
			      "Cannot determine `to' name to save by! Saving to \"sent\" folder %s instead."),
		      sent_mail);
	    strfcpy(savename, "<", sizeof savename);
	    if (sleepmsg > 0)
		sleep(sleepmsg);
	} else
	    elm_sfprintf(savename, sizeof savename,
			 FRM("=%.*s"), 
			 sizeof savename-2,buffer);		/* good! */
    }
    
    expand_filename(savename, TRUE, sizeof savename);	
    /* expand special chars */
    
    /*
     *  If saving conditionally by logname but folder doesn't
     *  exist save to sent folder instead.
     */
    if((strcmp(copy_file, "=?") == 0)
       && (access(savename, ACCESS_EXISTS) != 0)) {
	dprint(5, (debugfile,
		   "Conditional save by name: file %s doesn't exist - using \"<\".\n",
		   savename));
	strfcpy(savename, "<", sizeof savename);
	expand_filename(savename, TRUE, sizeof savename);
    }
    
    /*
     *  Allow options
     *  confirm_files, confirm_folders,
     *  confirm_append and confirm_create
     *  to control where the actual copy
     *  should be saved.
     */
    is_ordinary_file = strncmp (savename, folders, strlen(folders));
    
    if (access(savename, ACCESS_EXISTS)== 0) {	/* already there!! */
	if (confirm_append || (confirm_files && is_ordinary_file)) {
	    /*
	     *  OK in batch mode it may be impossible
	     *  to ask the user to confirm. So we have
	     *  to use sent_mail anyway.
	     */
	    if (batch_only) {
		strfcpy(savename, sent_mail, sizeof savename);
	    }
	    else {
		if (is_ordinary_file)
		    elm_sfprintf(msg_buffer, sizeof msg_buffer,
				 CATGETS(elm_msg_cat, ElmSet, 
					 ElmConfirmFilesAppend,
					 "Append to an existing file `%s'? (%c/%c) "),
				 savename, *def_ans_yes, *def_ans_no);
		else
		    elm_sfprintf(msg_buffer, sizeof msg_buffer,
				 CATGETS(elm_msg_cat, ElmSet, 
					 ElmConfirmFolderAppend,
					 "Append to mail folder `%s'? (%c/%c) "),
				 savename, *def_ans_yes, *def_ans_no);
		
		answer = want_to(msg_buffer, *def_ans_no, elm_LINES-2, 1);
		
		if (answer != *def_ans_yes) {
		    strfcpy(savename, sent_mail, sizeof savename);
		    PutLineX (elm_LINES-2, 0, CATGETS(elm_msg_cat, 
							ElmSet, 
						      ElmSavingToInstead,
						      "Alright - saving to `%s' instead"),
			      savename);
		    if (sleepmsg > 0)
			sleep(sleepmsg);
		    ClearLine (elm_LINES-2);
		}
	    }
	}
    }
    else {
	if (confirm_create || (confirm_folders && !is_ordinary_file)) {
	    /*
	     *  OK in batch mode it may be impossible
	     *  to ask the user to confirm. So we have
	     *  to use sent_mail anyway.
	     */
	    if (batch_only) {
		strfcpy(savename, sent_mail, sizeof savename);
	    }
	    else {
		if (is_ordinary_file)
		    elm_sfprintf(msg_buffer, sizeof msg_buffer,
				 CATGETS(elm_msg_cat, ElmSet, 
					 ElmConfirmFilesCreate,
					 "Create a new file `%s'? (%c/%c) "),
				 savename, *def_ans_yes, *def_ans_no);
		else
		    elm_sfprintf(msg_buffer, sizeof msg_buffer,
				 CATGETS(elm_msg_cat, ElmSet, 
					 ElmConfirmFolderCreate,
					 "Create a new mail folder `%s'? (%c/%c) "),
				 savename, *def_ans_yes, *def_ans_no);
		
	      answer = want_to(msg_buffer, *def_ans_no, elm_LINES-2, 1);
	      
	      if (answer != *def_ans_yes) {
		  strfcpy(savename, sent_mail, sizeof savename);
		  PutLineX (elm_LINES-2, 0, 
			    CATGETS(elm_msg_cat, 
				    ElmSet, 
				    ElmSavingToInstead,
				    "Alright - saving to `%s' instead"),
			    savename);
		  if (sleepmsg > 0)
		      sleep(sleepmsg);
		  ClearLine (elm_LINES-2);
	      }
	    }
	}
    }
    
    if ((err = can_open(savename, "a"))) {
	dprint(2, (debugfile,
		   "Error: attempt to autosave to a file that can't be appended to!\n"));
	dprint(2, (debugfile, "\tfilename = \"%s\"\n", savename));
	dprint(2, (debugfile, "** %s **\n", error_description(err)));
	
	/* Lets try sent_mail before giving up */
	if(strcmp(sent_mail, savename) == 0) {
	    /* we are ALREADY using sent_mail! */
	    lib_error(CATGETS(elm_msg_cat, ElmSet, ElmCannotSaveTo,
			      "Cannot save to %s!"), savename);
	    if (sleepmsg > 0)
		sleep(sleepmsg);
	    return(FALSE);
	}
	
	if ((err = can_open(sent_mail, "a"))) {
	    dprint(2, (debugfile,
		       "Error: attempt to autosave to a file that can't be appended to!\n"));
	    dprint(2, (debugfile, "\tfilename = \"%s\"\n", sent_mail));
	    dprint(2, (debugfile, "** %s **\n", error_description(err)));
	    lib_error(CATGETS(elm_msg_cat, ElmSet, ElmCannotSaveToNorSent,
			      "Cannot save to %s nor to \"sent\" folder %s!"),
		      savename, sent_mail);
	    if (sleepmsg > 0)
		sleep(sleepmsg);
	    return(FALSE);
	}
	lib_error(CATGETS(elm_msg_cat, ElmSet, ElmCannotSaveToSavingInstead,
			  "Cannot save to %s! Saving to \"sent\" folder %s instead."),
		  savename, sent_mail);
	if (sleepmsg > 0)
	    sleep(sleepmsg);
	strfcpy(savename, sent_mail, sizeof savename);
    }
    return (append_copy_to_file(headers, savename, filename, form,
				mime_info)==0);
}

char *
cf_english(fn)
char *fn;
{
    /** Return "English" expansion for special copy file name abbreviations
	or just the file name  **/

    if(!*fn)
      return(catgets(elm_msg_cat, ElmSet, ElmNoSave, "<no save>"));
    else if(!fn[1]) {
      if(*fn == '=')
	return(catgets(elm_msg_cat, ElmSet, ElmUncondSaveByName, "<unconditionally save by name>"));
      else if(*fn == '<')
	return(catgets(elm_msg_cat, ElmSet, ElmSentFolder, "<\"sent\" folder>"));
    } else if ((fn[0] == '=') && (fn[1] == '?'))
      return(catgets(elm_msg_cat, ElmSet, ElmCondSaveByName, "<conditionally save by name>"));

    return(fn);
}

static char *ncf_prompt = NULL;

int name_copy_file(fn, size)
     char *fn;
     int size;
{
    /** Prompt user for name of file for saving copy of outbound msg to.
	Return true if we need a redraw. **/

    int redraw = 0;	/* set when we ask for help = need redraw */
    char buffer[SLEN], origbuffer[SLEN];
    static char helpmsg[LONG_STRING];


    if (ncf_prompt == NULL) {
	ncf_prompt = catgets(elm_msg_cat, ElmSet, ElmSaveCopyInPrompt,
			"Save copy in (use '?' for help/to list folders): ");
    }

redraw1:
    /* expand passed copy file name into English */
    strfcpy(buffer, cf_english(fn), sizeof buffer);

    /* prepare screen with instructions */
    MoveCursor(elm_LINES-2, 0);
    CleartoEOS();
    PutLine0(elm_LINES-2, 0, ncf_prompt);

    while(1) {
      int status;

      /* get file name from user input */
      strfcpy(origbuffer, buffer, sizeof origbuffer);
      status = optionally_enter(buffer, elm_LINES-2, strlen(ncf_prompt), 
				OE_REDRAW_MARK, sizeof buffer);
      if (REDRAW_MARK == status) {
	redraw = TRUE;
	goto redraw1;
      }

      if (status != 0) {
	fn[0] = '\0';
	return redraw;
      }

      if(strcmp(buffer, "?") != 0) { /* got what we wanted - non-help choice */

	if(strcmp(origbuffer, buffer) != 0)
	  /* user changed from our English expansion 
	   * so we'd better copy user input to fn
	   */
	  strfcpy(fn, buffer, size);

	/* else user presumably left our English expansion - no change in fn */

	/* display English expansion of new user input a while */
	PutLine0(elm_LINES-2, strlen(ncf_prompt), cf_english(fn));
	MoveCursor(elm_LINES, 0);
	if (sleepmsg > 0)
		sleep((sleepmsg + 1) / 2);
	MoveCursor(elm_LINES-2, 0);
	CleartoEOS();

	return(redraw);
      }

      /* give help and list folders */
      redraw = TRUE;
      if(!*helpmsg) {	/* help message not yet formulated */
	strfcpy(helpmsg, catgets(elm_msg_cat, ElmSet, ElmListFoldersHelp1,
"Enter: <nothing> to not save a copy of the message,\n\
\r       '<'       to save in your \"sent\" folder ("),
		sizeof helpmsg);
	strfcat(helpmsg, sent_mail, sizeof helpmsg);
	strfcat(helpmsg, catgets(elm_msg_cat, ElmSet, ElmListFoldersHelp2,
"),\n\
\r       '='       to save by name (the folder name depends on whom the\n\
\r                     message is to, in the end),\n\
\r       '=?'      to save by name if the folder already exists,\n\
\r                     and if not, to your \"sent\" folder,\n\
\r       or a filename (a leading '=' denotes your folder directory).\n\r\n\r"),
		sizeof helpmsg);
      }

      list_folders(4, helpmsg, NULL);
      PutLine0(elm_LINES-2, 0, ncf_prompt);

      /* restore as default to English version of the passed copy file name */
      strfcpy(buffer, cf_english(fn), sizeof buffer);

    }
}

int append_copy_to_file(headers, fname_copy, fname_mssg, form, mime_info)
     struct mailing_headers * headers; 
     char *fname_copy;
     char *fname_mssg;
     int form;
     mime_send_t *mime_info;
{
    int err;
    FILE *fp_copy, *fp_mssg;
    extern FILE *write_header_info();

    /* open up the file with the message */
    if ((fp_mssg = fopen(fname_mssg, "r")) == NULL) {
	err = errno;
	dprint(1, (debugfile,
	    "Error: Couldn't open \"%s\" for read in append_copy_to_file\n",
	    fname_mssg));
	dprint(1, (debugfile, "** %s **\n", error_description(err)));
	lib_error(CATGETS(elm_msg_cat, ElmSet, ElmAppendCopyCouldntReadFile,
			  "Couldn't read file \"%s\"!"), 
		  fname_mssg);
	if (sleepmsg > 0)
	    sleep(sleepmsg);
	return -1;
    }

    /* dump the header to the end of the copy file */
    save_file_stats(fname_copy);
    fp_copy = write_header_info(fname_copy, headers, (form == YES), TRUE,
				mime_info);
    if (fp_copy == NULL) {
	(void) fclose(fp_mssg);
	return -1;
    }
    restore_file_stats(fname_copy);

    /* dump the contents of the message to the end of the copy file */
    copy_message_across(fp_mssg, fp_copy, TRUE, mime_info);

    /* copy successfully done */
    fclose(fp_copy);
    fclose(fp_mssg);
    return 0;
}

/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 * End:
 */
