
static char rcsid[] = "@(#)$Id: expires.c,v 1.1.1.1 1998/10/15 15:36:42 hurtta Exp $";

/*****************************************************************************
 * This code is reimpleted. Original code was following copyright:
 *
 *			Copyright (c) 1988-1992 USENET Community Trust
 *			Copyright (c) 1986,1987 Dave Taylor
 *****************************************************************************/

/** This routine is written to deal with the Expires: header on the
    individual mail coming in.  What it does is to look at the date,
    compare it to todays date, then set the EXPIRED flag on the
    current message if it is true...
**/

#include "headers.h"
#include "me.h"

void process_expiration_date(date, message_status)
     char *date;
     int  *message_status;
{
	time_t thetime, expiretime;
#ifndef	_POSIX_SOURCE
	time_t time();
#endif

	if (!parse_date_time(date,
			     NULL, 0, NULL, &expiretime)) {
	  dprint(7, (debugfile,
		     "process_expiration_date: \"%s\" unparseable\n", date));

	}

	thetime = time((time_t *) 0);

	dprint(7, (debugfile,
		   "process_expiration_date: now %ld, expires %ld\n", 
		   (long)thetime, (long)expiretime));

	if (expiretime > thetime)
	  return;

	/** it's EXPIRED!  Yow!! **/

	(*message_status) |= EXPIRED;
	dprint(7, (debugfile,
		   "process_expiration_date: Message is expired\n")); 
	return;
}
