static char rcsid[] = "@(#)$Id: addr_util.c,v 1.6.2.2 1999/10/10 15:57:04 hurtta Exp $";

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 1.6.2.2 $   $State: Exp $
 *
 *  Modified by: Kari Hurtta <hurtta+elm@ozone.FMI.FI>
 ******************************************************************************
 *  The Elm Mail System 
 *
 * 			Copyright (c) 1988-1992 USENET Community Trust
 * 			Copyright (c) 1986,1987 Dave Taylor
 *****************************************************************************/

/** This file contains addressing utilities 

**/

#include "headers.h"
#include "s_elm.h"
#include "me.h"

static int add_expanded_ P_((struct expanded_address *x,
			     const char *ADR, const char *FN,
			     const char *COM));
static int add_expanded_ (x,ADR,FN,COM)
     struct expanded_address *x;
     CONST char *ADR;
     CONST char *FN;
     CONST char *COM;
{
    x->addrs = safe_realloc(x->addrs,(x->addrs_len + 2) * 
			    sizeof (struct addr_item));
    x->addrs[x->addrs_len].addr     = safe_strdup(ADR);
    x->addrs[x->addrs_len].fullname = safe_strdup(FN);
    x->addrs[x->addrs_len].comment = safe_strdup(COM);
    x->addrs[x->addrs_len+1].addr     = NULL;
    x->addrs[x->addrs_len+1].fullname = NULL;
    x->addrs[x->addrs_len+1].comment  = NULL;
    return x->addrs_len++;
}

static int add_textual_ P_((struct expanded_address *x,
			    const char *TEXTUAL, int POS, int LEN));
static int add_textual_ (x,TEXTUAL,POS,LEN)
     struct expanded_address *x;
     CONST char *TEXTUAL;
     int POS, LEN;
{
    x->surface = safe_realloc(x->surface,(x->surface_len + 2) * 
			      sizeof (struct textual));
    if (!TEXTUAL)
	x->surface[x->surface_len].textual     = NULL;
    else
	x->surface[x->surface_len].textual     = safe_strdup(TEXTUAL);
    x->surface[x->surface_len].pos         = POS;
    x->surface[x->surface_len].len         = LEN;
    x->surface[x->surface_len+1].textual   = NULL;
    x->surface[x->surface_len+1].pos       = POS+LEN;
    x->surface[x->surface_len+1].len       = 0;
    return x->surface_len++;
}

#define ADD_EXPANDED(x,ADR,FN,COM)  add_expanded_(&x,ADR,FN,COM)
#define ADD_TEXTUAL(x,TEXTUAL,POS,LEN) add_textual_(&x,TEXTUAL,POS,LEN)

void zero_expanded_address (x)
     struct expanded_address *x;
{
    x->addrs        = NULL;
    x->addrs_len    = 0;
    x->surface      = NULL;
    x->surface_len  = 0;
}

int aliases_to_expanded(x)
     struct expanded_address *x;
{
    int i;
    int tagged = 0;
    CONST int NEWPOS = x->addrs_len;
    
    for (i=0; i < message_count; i++) {
	if (ison(aliases[i]->status, TAGGED)) {
	    add_textual_(x,aliases[i]->alias,NEWPOS,0);
	    tagged++;
	}
    }
    
    if (tagged == 0) {
	add_textual_(x,aliases[current-1]->alias,NEWPOS,0);
    }

    return tagged;
}

static char * make_surface P_((struct addr_item ITEM));
static char * make_surface(ITEM)
     struct addr_item ITEM; 
{
    char * result = NULL;
    
    if (ITEM.fullname[0]) {
	char * D = safe_strdup(ITEM.fullname), *p;

	/* No fancy quotation stuff on textual form for editing */
	for (p = D; *p; p++) {
	    
	    if(
#ifdef ASCII_CTYPE
	       !isascii(*p) || !isprint(*p)
#else
	       !isprint((unsigned char)*p)
#endif
	       )
		*p = '_';
	    
	    switch(*p) {
	    case '"': case '\\': 
		*p = '_';
		break;
	    }
	}

	result = strmcat(result,"\"");
	result = strmcat(result,D);
	result = strmcat(result,"\" ");
	free(D);
    }

    result = strmcat(result,"<");
    result = strmcat(result,ITEM.addr);
    result = strmcat(result,">");
    
    if (ITEM.comment[0]) {
	char * D = safe_strdup(ITEM.comment), *p;

	/* No fancy quotation stuff on textual form for editing */
	for (p = D; *p; p++) {
	    
	    if(
#ifdef ASCII_CTYPE
	       !isascii(*p) || !isprint(*p)
#else
	       !isprint((unsigned char)*p)
#endif
	       )
		*p = '_';
	    
	    switch(*p) {
	    case '"': case '\\': case '(': case ')':
		*p = '_';
		break;
	    }
	}

	result = strmcat(result," (");
	result = strmcat(result,D);
	result = strmcat(result,")");
	free(D);

    }

    return result;
}

void free_expanded_address(x)
     struct expanded_address *x;
{
    int i;
    
    if (x->addrs_len)
	free_addr_items(x->addrs);
    x->addrs = NULL;
    x->addrs_len = 0;
    
    if (x->surface_len) {
	for (i = 0; i < x->surface_len; i++) {
	    if (x->surface[i].textual) {
		free(x->surface[i].textual);
		x->surface[i].textual = NULL;
	    }
	}
	free(x->surface);
	x->surface = NULL;
	x->surface_len = 0;
    }
}

void copy_expanded_address (result,source) 
     struct expanded_address *result;
     struct expanded_address source;
{
    int i;
    free_expanded_address(result);
    
    for (i = 0; i < source.surface_len; i++) {
	int count = 0;
	int pos = result->addrs_len;
	int j;
	for (j = 0; j < source.surface[i].len; j++) {
	    CONST struct addr_item *ptr1 = & 
		(source.addrs[source.surface[i].pos+j]);
	    int p = add_expanded_(result,ptr1->addr,ptr1->fullname,
				  ptr1->comment);
	    if (0 == count)
		pos = p;
	    count++;
	}
	add_textual_(result,source.surface[i].textual,pos,count);      
    }
}

void dump_expanded_address(debuglevel,text,expanded)
     int debuglevel; 
     CONST char *text;
     struct expanded_address expanded;

{
    struct textual *ptr;
    int l = strlen(text);
    int LASTPOS = -1;

    dprint(debuglevel,(debugfile,"%s: %d surfaces, %d addresses\n",
		       text, expanded.surface_len, expanded.addrs_len));
 
    for (ptr = expanded.surface; 
	 ptr < expanded.surface + expanded.surface_len; 
	 ptr++) {
	int j;
	if (!ptr->textual) {
	    dprint(debuglevel,(debugfile,
			       "%*s [%d] surface NULL! \t(%d addresses)\n",
			       l,"",ptr-expanded.surface,ptr->len));
	} else {
	    dprint(debuglevel,(debugfile,
			       "%*s [%d] surface=%s \t(%d addresses)\n",
			       l,"",ptr-expanded.surface,ptr->textual,
			       ptr->len));
	}
	if (ptr->pos != LASTPOS + 1) {     
	    dprint(debuglevel,(debugfile,
			       "%*s [%d] ERROR!  address pos = %d != %d (lastpost +1)\n",
			       l,"",ptr-expanded.surface, ptr->pos, LASTPOS+1));			
	}
	for (j = 0; j < ptr->len; j++) {
	    if (ptr->pos < 0 || ptr->pos >= expanded.addrs_len) {
		dprint(debuglevel,(debugfile,
				   "%*s    %d [%d] ERROR, not range 0 - %d\n",
				   l,"",j,ptr->pos,
				   expanded.addrs_len-1));
	    } else {
		CONST struct addr_item *ptr1 = & (expanded.addrs[ptr->pos]);
		if (!ptr1->addr || !ptr1->fullname || !ptr1->comment) {
		    dprint(debuglevel,(debugfile,
				       "%*s    %d [%d] ERROR! NULL element!\n",
				       l,"",j,ptr->pos));
		} else {
		    dprint(debuglevel,(debugfile,
				       "%*s    %d [%d] addr=%s \tfullname=%s\tcomment=%s\n",
				       l,"",j,ptr->pos,
				       ptr1->addr,ptr1->fullname,
				       ptr1->comment));
		}
		LASTPOS = ptr->pos;
	    }
	}
    }
    dprint(debuglevel,(debugfile,
		       "%*s === end\n",l,""));

}

char * kludge_addr(char **addr) {
    char * ptr = *addr;
    int l = strlen(ptr);
    char *res;
    
    ptr = safe_realloc(ptr,l + 1 + 2 + l + 1);

    res = ptr + l + 1;

    res[0] = '<';
    strfcpy(res+1,ptr,l+1);
    res[l+1] = '>';
    res[l+2] = '\0';

    *addr = ptr;
    return res;
}

extern char **argv_from_headers (headers)
     struct mailing_headers * headers;
{
    int count = 
	headers->to.addrs_len + 
	headers->cc.addrs_len + headers->bcc.addrs_len;
    char **res;
    int idx = 0,i;
    struct addr_item *p;
        
    dprint(8, (debugfile, "argv_from_headers, count=%d\n",count));
    
    res = safe_malloc((count + 1) * sizeof (char *));
    
    dump_expanded_address(8,"argv_from_headers -- enter (to)",headers->to);

    for (p = headers->to.addrs; 
	 p < headers->to.addrs + headers->to.addrs_len;
	 p++) {
	if (p->addr[0] == '-' || p->addr[0] == '@' ||
	    p->addr[0] == '\0')
	    /* Modify p->addr so that there is space
	     * alloced also for <addr> form 
	     */
	    res[idx++] = kludge_addr(&p->addr);
	else
	    res[idx++] = p->addr;
    }

    dump_expanded_address(8,"argv_from_headers -- enter (cc)",headers->cc);

    for (p = headers->cc.addrs; 
	 p < headers->cc.addrs + headers->cc.addrs_len;
	 p++) {
	if (p->addr[0] == '-' || p->addr[0] == '@' ||
	    p->addr[0] == '\0')
	    /* Modify p->addrs so that there is space
	     * alloced also for <addr> form 
	     */
	    res[idx++] = kludge_addr(&p->addr);
	else
	    res[idx++] = p->addr;
    }

    dump_expanded_address(8,"argv_from_headers -- enter (bcc)",headers->bcc);

    for (p = headers->bcc.addrs; 
	 p < headers->bcc.addrs + headers->bcc.addrs_len;
	 p++) {
	if (p->addr[0] == '-' || p->addr[0] == '@' ||
	    p->addr[0] == '\0')
	    /* Modify p->addrs so that there is space
	     * alloced also for <addr> form 
	     */
	    res[idx++] = kludge_addr(&p->addr);
	else
	    res[idx++] = p->addr;
    }
    
    res[idx] = NULL;
    
    dprint(8, (debugfile, "           idx=%d\n",idx));
    for (i = 0; i < idx; i++) 
	dprint(8, (debugfile, "           [%d]=%s\n",i,res[i]));

    dump_expanded_address(11,"argv_from_headers -- leave (to)",headers->to);
    dump_expanded_address(11,"argv_from_headers -- leave (cc)",headers->cc);
    dump_expanded_address(11,"argv_from_headers -- leave (bcc)",headers->bcc);

    return res;
}


int argv_to_expanded(result,argv)
     struct expanded_address *result;
     char *argv[];
{
    int i,res;
    free_expanded_address(result);

    dprint(7,(debugfile,"argv_to_expanded:"));
    for (i = 0;  argv[i]; i++) {
	dprint(7,(debugfile," [%d]=%s",i,argv[i]));
    }
    dprint(7,(debugfile,"\n"));

    for (i = 0;  argv[i]; i++) {
	add_textual_(result,argv[i],0,0);
    }

    dump_expanded_address(8,"argv_to_expanded: before build_address_l()",
			  *result);

    /* And make address structures */
    res = build_address_l(result);

    dump_expanded_address(7,"argv_to_expanded: (result)",*result);

    dprint(7,(debugfile,"argv_to_expanded=%d\n",res));
    return res;
}

void addr_to_expanded(result,addrs)
     struct expanded_address *result;
     struct addr_item *addrs;
{
    int i;
    free_expanded_address(result);

    dprint(7,(debugfile,"addr_to_expanded:"));
    if (!addrs) {
	dprint(7,(debugfile," -- NULL"));
    } else {
	for (i = 0;  
	     addrs[i].addr && addrs[i].fullname && addrs[i].comment; i++) {
	    dprint(7,(debugfile," [%d]: {addr=%s, fullname=%s, comment=%s}",i,
		      addrs[i].addr, addrs[i].fullname, addrs[i].comment));
	}
    }
    dprint(7,(debugfile,"\n"));

    for (i = 0;  
	 addrs && addrs[i].addr && addrs[i].fullname && addrs[i].comment; 
	 i++) {
	int pos = add_expanded_(result,addrs[i].addr, 
				addrs[i].fullname, addrs[i].comment);
	add_textual_(result,NULL,pos,1);
    }

    dump_expanded_address(8,"addr_to_expanded: before build_address_l()",
			  *result);

    /* And make address structures */
    build_address_l(result);

    dump_expanded_address(7,"addr_to_expanded: (result)",*result);
}


void expanded_to_edit_buffer(buffer,size,expanded)
     char * buffer;
     int size;  
     struct expanded_address expanded;
{
    struct textual *ptr;
    buffer[0] = '\0';

    dprint(7,(debugfile,"expanded_to_edit_buffer: size=%d\n",size));
    dump_expanded_address(7,"expanded_to_edit_buffer",expanded);

    for (ptr = expanded.surface; 
	 ptr < expanded.surface + expanded.surface_len; 
	 ptr++) {
	if (buffer[0]) 
	    strfcat(buffer,", ",size);
	strfcat(buffer,ptr->textual,size);
    }
    dprint(7,(debugfile,"expanded_to_edit_buffer: (result) buffer=%s\n",
	      buffer));
}

void update_expanded_from_edit_buffer(expanded,buffer)
     struct expanded_address *expanded;
     CONST char *buffer;
{
    int i,next;
    struct expanded_address result;
    struct textual *ptr = expanded->surface;
    char ** tokenized = rfc822_tokenize(buffer);

    zero_expanded_address(&result);

    dprint(7,(debugfile,"update_expanded_from_edit_buffer: buffer=%s\n",
	      buffer));
    dump_expanded_address(7,"expanded_to_edit_buffer: (initial)",*expanded);

    for (i = 0; tokenized[i]; i = next) {
	CONST int NEWPOS = result.addrs_len;
	char * surface = NULL;
	int q= 0, spacecount =  0, q_seen = 0;

	dprint(25,(debugfile,
		   "expanded_to_edit_buffer: [%d]=\"%s\"\n",
		   i,tokenized[i]));

	if (whitespace(tokenized[i][0]) ||
	    ',' == tokenized[i][0]) {
	    next = i+1;
	    continue;
	}
	for (next = i; tokenized[next]; next++) {
	    if ('<' == tokenized[next][0]) {
		q++;
		q_seen = 1;
	    } else if ('>' == tokenized[next][0])
		q--;
	    else if (!q && ',' == tokenized[next][0])
		break;
	    else if (!q && q_seen && 
		     !whitespace(tokenized[next][0]) &&
		     '(' != tokenized[next][0])
		break;
	    else if (!q && whitespace(tokenized[next][0]) &&
		     tokenized[next+1] && '(' == tokenized[next+1][0])
		/* Don't count whitespaces before comments */  ;
	    else if (!q && q_seen &&
		     whitespace(tokenized[i][0]))
		break;
	    else if (!q && whitespace(tokenized[next][0]))
		spacecount ++;

	    dprint(25,(debugfile,
		       "expanded_to_edit_buffer+ [%d]=\"%s\" q=%d\n",
		       next,tokenized[next],q));

	    surface = strmcat(surface,tokenized[next]);     	       
	}

	dprint(25,(debugfile,
		   "expanded_to_edit_buffer- spacecount=%d, q=seen=%d\n",
		   spacecount,q_seen));

  
	if (surface && ptr < expanded->surface + expanded->surface_len &&
	    0 == strcmp(ptr->textual,surface)) {
	    int r;
	    int pos = NEWPOS;
	    int count = 0;
	    int j;
	    /* no change -- copy original */
      
	    for (j = 0; j < ptr->len; j++) {
		CONST struct addr_item *ptr1 = & (expanded->addrs[ptr->pos+j]);
		int p = ADD_EXPANDED(result,ptr1->addr,ptr1->fullname,
				     ptr1->comment);
		if (0 == count)
		    pos = p;
		count++;
	    }
	    r=ADD_TEXTUAL(result,ptr->textual,pos,count);
	    dprint(25,(debugfile,"expanded_to_edit_buffer-> [%d] = %s (keep %d addresses)\n",
		       r,surface,count));
	    
	}

	/* Starting with - is alias expansion removing syntax */
	else if (tokenized[i][0] == '-') {
	    int r;
	    char * surface1 = NULL;
      
	    dprint(25,(debugfile,
		       "expanded_to_edit_buffer= resscan from %d\n",i));
			   
	    for (next = i; tokenized[next]; next++) {
		if ('<' == tokenized[next][0] ||
		    '>' == tokenized[next][0] ||
		    ',' == tokenized[next][0] ||
		    whitespace(tokenized[next][0]))
		    break;

		dprint(25,(debugfile,
			   "expanded_to_edit_buffer+ [%d]=\"%s\"\n",
			   next,tokenized[next]));

		surface1 = strmcat(surface1,tokenized[next]);     	       
	    }

	    r=ADD_TEXTUAL(result,surface1,NEWPOS,0);
	    dprint(25,(debugfile,"expanded_to_edit_buffer-> [%d] = %s\n",
		       r,surface1));

	    if (surface1)
		free(surface1);

	    /* word <address> */
	} else if (spacecount <= 1 && q_seen) {
	    int r = ADD_TEXTUAL(result,surface,NEWPOS,0);
	    dprint(25,(debugfile,"expanded_to_edit_buffer-> [%d] = %s\n",
		       r,surface));
	} else {
	    char * surface1 = NULL;
	    int r;

	    dprint(25,(debugfile,
		       "expanded_to_edit_buffer= resscan from %d\n",i));

	    for (next = i; tokenized[next]; next++) {
		if (!q && whitespace(tokenized[next][0]) &&
		    tokenized[next+1] && '(' == tokenized[next+1][0])
		    /* Don't break on whitespaces before comments */  ;
		else if ('<' == tokenized[next][0] ||
			 '>' == tokenized[next][0] ||
			 ',' == tokenized[next][0] ||
			 whitespace(tokenized[next][0]))
		    break;

		dprint(25,(debugfile,
			   "expanded_to_edit_buffer+ [%d]=\"%s\"\n",
			   next,tokenized[next]));

		surface1 = strmcat(surface1,tokenized[next]);     	       
	    }

	    r=ADD_TEXTUAL(result,surface1,NEWPOS,0);
	    dprint(25,(debugfile,"expanded_to_edit_buffer-> [%d] = %s\n",
		       r,surface1));

	    if (surface1)
		free(surface1);
	}

	if (ptr < expanded->surface + expanded->surface_len)
	    ptr++;
	if (surface)
	    free(surface);
    }

    dump_expanded_address(7,"expanded_to_edit_buffer: before build_address_l",
			  result);

    build_address_l(&result);

    free_expanded_address(expanded);
    *expanded = result;   /* put new (same?) result to place */

    if (tokenized)
	free(tokenized);

    dump_expanded_address(7,"expanded_to_edit_buffer: (result)",*expanded);
}

int build_address_l(expanded)
     struct expanded_address *expanded;
{
    struct textual *ptr;
    int expands = 0;
    struct expanded_address result;
    int too_long = FALSE;

    dump_expanded_address(11,"build_address_l",*expanded);

    zero_expanded_address(&result);

    for (ptr = expanded->surface; 
	 ptr < expanded->surface + expanded->surface_len; 
	 ptr++) {
	CONST int NEWPOS = result.addrs_len;
	struct addr_item * aliases;

	char *alias;

	if (!ptr->textual) {

	    if (ptr->len == 1) {
		/* If we have no textual presentation we are converting
		 * from struct addrs
		 */
		char *temp = make_surface(expanded->addrs[ptr->pos]);
		int pos = ADD_EXPANDED(result,
				       expanded->addrs[ptr->pos].addr,
				       expanded->addrs[ptr->pos].fullname,
				       expanded->addrs[ptr->pos].comment);
		ADD_TEXTUAL(result,temp,pos,1);
	
		free(temp);
	    } else {
		dprint(1,(debugfile,
			  "build_address_l: SOFWARE ERROR: [%d]: textual=NULL, len=%d\n",
			  ptr - expanded->surface, ptr->len));
	    }
	}

	else if (ptr->textual[0] == '-') {
	    /* Is also on result's remove list */
	    ADD_TEXTUAL(result,ptr->textual,NEWPOS,0);
	}

	else if (qstrpbrk(ptr->textual,"!@: <>,()") != NULL) {
	    char * temp = NULL;
	    if (ptr->len == 1) 
		temp = make_surface(expanded->addrs[ptr->pos]);

	    if (temp && 0 == strcmp(temp,ptr->textual)) {
		/* no change -- preserve original address */

		int pos = ADD_EXPANDED(result,
				       expanded->addrs[ptr->pos].addr,
				       expanded->addrs[ptr->pos].fullname,
				       expanded->addrs[ptr->pos].comment);
		ADD_TEXTUAL(result,temp,pos,1);

	    } else {
		/* generate addresses from textual 'surface' presentation */
		int pos = NEWPOS;
		int count = 0;
		struct addr_item * address =
		    break_down_address(ptr->textual, 
				       /* If user pastes encoded words from somewhere
					* decode them also.
					*/
				       is_rfc1522(ptr->textual) ?
				       rfc1522_decode_structured : decode_who_none);
		struct addr_item *ptr1;

		for (ptr1 = address; 
		     ptr1 && ptr1 -> addr && ptr1->fullname && ptr1->comment; 
		     ptr1++) {
		    int p = ADD_EXPANDED(result,ptr1->addr,
					 ptr1->fullname, ptr1->comment);
		    if (0 == count)
			pos = p;
		    count++;
		}
		ADD_TEXTUAL(result,ptr->textual,pos,count);
		if (address)
		    free_addr_items(address);
	    }

	    if (temp)
		free(temp);

	} 

	else if (NULL != (aliases = 
			  get_alias_address_l(ptr->textual, TRUE, &too_long))) {
	    struct addr_item *ptr1;
	    int pos = NEWPOS;
	    int count = 0;

	    expands = 1;

	    for (ptr1 = aliases; 
		 ptr1 && ptr1 -> addr && ptr1->fullname && ptr1->comment; 
		 ptr1++) {
		struct textual *ptr2;
		int p;

		/* scan words to be eleminated */
		for (ptr2 = expanded->surface; 
		     ptr2 < expanded->surface + expanded->surface_len; 
		     ptr2++) {
		    if (ptr2 -> textual &&
			ptr2 -> textual[0] == '-') {
			if (0 == strcmp(ptr1->addr,&(ptr2->textual[1])))
			    break;
		    }    
		}

		if (ptr2 && ptr2 < expanded->surface + expanded->surface_len)
		    /* Is on eliminating list -- don't add */
		    continue;

		p = ADD_EXPANDED(result,ptr1->addr,ptr1->fullname,
				 ptr1->comment);
		if (0 == count)
		    pos = p;
		count++;
	    }
	    ADD_TEXTUAL(result,ptr->textual,pos,count);

	    if (aliases)
		free_addr_items(aliases);
	} 

	else if (too_long) {
	    dprint(2,(debugfile,"Overflowed alias expansion for %s\n", 
		      ptr->textual));
	    continue;             /* Don't process */
	}

	else if (valid_name(ptr->textual)) {
	    char * gecos = NULL; 
	    char * comment = "";
	    int pos;

	    /* Preserve possible comment */
	    if (ptr->len == 1)
		gecos = expanded->addrs[ptr->pos].fullname;
	    if (ptr->len == 1)
		comment = expanded->addrs[ptr->pos].comment;


	    if (!gecos || !gecos[0])
		gecos = get_full_name(ptr->textual);

	    if (!gecos)
		gecos = "";
      
	    pos = ADD_EXPANDED(result,ptr->textual,gecos,comment);
#ifdef USE_DOMAIN
	    result.addrs[pos].addr = strmcat(result.addrs[pos].addr,"@");
	    result.addrs[pos].addr = strmcat(result.addrs[pos].addr, hostfullname);
#endif
	    ADD_TEXTUAL(result,ptr->textual,pos,1);
	}

	else { 
	    char * gecos = ""; 
	    char * comment = "";
	    int pos; 

	    /* Preserve possible comment */
	    if (ptr->len == 1)
		gecos = expanded->addrs[ptr->pos].fullname;
	    if (ptr->len == 1)
		comment = expanded->addrs[ptr->pos].comment;


	    pos = ADD_EXPANDED(result,ptr->textual,gecos,comment);
	    ADD_TEXTUAL(result,ptr->textual,pos,1);

	    if (check_only) 
		lib_error(CATGETS(elm_msg_cat, ElmSet, ElmAliasUnknown,
				  "(alias \"%s\" is unknown)"), 
			  ptr->textual);
	}
    }

    free_expanded_address(expanded);
    *expanded = result;   /* put new (same?) result to place */

    dump_expanded_address(11,"build_address_l: (result)",*expanded);
    dprint(11,(debugfile,"build_address_l=%d\n",expands));

    return expands;
}

#if 0
int build_address(to, full_to, size_to, size_full_to)
     char *to, *full_to;
     int size_to, size_full_to;
{
    /** loop on all words in 'to' line...append to full_to as
	we go along, until done or length > len.  Modified to
	know that stuff in parens are comments...Returns non-zero
	if it changed the information as it copied it across...
	**/

    register int	i, j, k, l,
	changed = 0, in_parens = 0,
	expanded_information = 0,
	eliminated = 0;
    int too_long = FALSE;
    char word[SLEN], next_word[SLEN], *ptr, buffer[SLEN];
    char new_to_list[VERY_LONG_STRING];
    char elim_list[SLEN], word_a[SLEN], next_word_a[SLEN];
    char *qstrpbrk(), *gecos;
    extern char *get_full_name(), *get_alias_address();

    new_to_list[0] = '\0';

    i = get_word(to, 0, word, sizeof(word));

    full_to[0] = '\0';

    elim_list[0] = '\0';

	/** Look for addresses to be eliminated from aliases **/
    while (i > 0) {

	j = get_word(to, i, next_word, sizeof(next_word));

	if(word[0] == '(')
	    in_parens++;

	if (in_parens) {
	    if(word[strlen(word)-1] == ')')
		in_parens--;
	}

	else if (word[0] == '-'){
	    for (k=0; word[k]; word[k] = word[k+1],k++);
	    if (elim_list[0] != '\0')
		strfcat(elim_list, " ", sizeof elim_list);
	    strfcat(elim_list, word, sizeof elim_list);
	}
	if ((i = j) > 0)
	    strfcpy(word, next_word, sizeof word);
    }

    if (elim_list[0] != '\0')
	eliminated++;

    i = get_word(to, 0, word, sizeof(word));

    while (i > 0) {

	j = get_word(to, i, next_word, sizeof(next_word));

    try_new_word:
	if(word[0] == '(')
	    in_parens++;

	if (in_parens) {
	    char c1 = '\0', c2 = '\0';
	    char *word1 = word;
	    char temp[LONG_STRING];

	    if (word1[0] == '(') {
		c1 = '(';
		word1++;
	    }
	    if(word1[strlen(word1)-1] == ')') {
		in_parens--;
		c2 = ')';
		word1[strlen(word1)-1] = '\0';
	    }
	    if (!allow_no_hdrencoding) {
		rfc1522_encode_text(temp,sizeof temp,word1,HDR_COMMENT);
		word1 = temp;
	    } 
	    strfcat(full_to, " ", size_full_to);
	    if (c1)
		strfcat(full_to, "(", size_full_to);
	    strfcat(full_to, word1, size_full_to-1);
	    if (c2)
		strfcat(full_to, ")", size_full_to);
	}

	else if (word[0] == '-') {
	}

	else if (qstrpbrk(word,"!@:") != NULL) {
	    elm_sfprintf(full_to, size_full_to,
			 FRM("%s%s%s"), full_to,
			 full_to[0] != '\0'? ", " : "", word);
	}
	else if ((ptr = get_alias_address(word, TRUE, &too_long)) != NULL) {

	    /** check aliases for addresses to be eliminated **/
	    if (eliminated) {
		k = get_word(strip_commas(ptr), 0, word_a, sizeof(word_a));

		while (k > 0) {
		    l = get_word(ptr, k, next_word_a, sizeof(next_word_a));
		    if (in_list(elim_list, word_a) == 0)
			elm_sfprintf(full_to, size_full_to,
				     FRM("%s%s%s"), full_to,
				     full_to[0] != '\0' ? ", " : "", word_a);
		    if ((k = l) > 0)
			strfcpy(word_a, next_word_a, sizeof word_a);
		}
	    } else
		elm_sfprintf(full_to, size_full_to,
			     FRM("%s%s%s"), full_to, 
			     full_to[0] != '\0'? ", " : "", ptr);
	    expanded_information++;
	}
	else if (too_long) {
	    /*
	     *   We don't do any real work here.  But we need some
	     *   sort of test in this line of tests to make sure
	     *   that none of the other else's are tried if the 
	     *   alias expansion failed because it was too long.
	     */
	    dprint(2,(debugfile,"Overflowed alias expansion for %s\n", word));
	}
	else if (strlen(word) > 0) {
	    char temp[LONG_STRING];

	    if (valid_name(word)) {
		if (j > 0 && next_word[0] == '(')	/* already has full name */
		    gecos = NULL;
		else				/* needs a full name */
		    gecos = get_full_name(word);

		if (!allow_no_hdrencoding && gecos) {
		    /* from is not longer mime encoded */

		    rfc1522_encode_text(temp,sizeof temp,gecos,HDR_COMMENT);
		    gecos = temp;
		} 

#if defined(USE_DOMAIN)
		elm_sfprintf(full_to, size_full_to,
			     FRM("%s%s%s@%s%s%s%s"),
			     full_to,
			     (full_to[0] ? ", " : ""),
			     word,
			     hostfullname,
			     (gecos ? " (" : ""),
			     (gecos ? gecos : ""),
			     (gecos ? ")" : ""));
#else /* USE_DOMAIN */
		elm_sfprintf(full_to, size_full_to,
			     FRM("%s%s%s%s%s%s"),
			     full_to,
			     (full_to[0] ? ", " : ""),
			     word,
			     (gecos ? " (" : ""),
			     (gecos ? gecos : ""),
			     (gecos ? ")" : ""));
#endif /* USE_DOMAIN */
	    }
	    else if (check_only) {
		if (! isatty(fileno(stdin)) ) {
		    /*
		     *	batch mode error!
		     */
		    Raw(OFF);
		    fprintf(stderr,
			    catgets(elm_msg_cat, ElmSet, ElmCannotExpandNoCR,
				    "Cannot expand alias '%s'!\n"),
			    word);
		    fprintf(stderr,
			    catgets(elm_msg_cat, ElmSet, ElmUseCheckalias,
				    "Use \"checkalias\" to find valid addresses!\n"));
		    dprint(1, (debugfile,
			       "Can't expand alias %s - bailing out of build_address\n", 
			       word));
		    leave(0);
		}
		else {
		    printf(catgets(elm_msg_cat, ElmSet, ElmAliasUnknown,
				   "(alias \"%s\" is unknown)\n\r"), word);
		    changed++;
		}
	    }
	    else {
		elm_sfprintf(full_to, size_full_to,
			     FRM("%s%s%s"),
			     full_to,
			     (full_to[0] ? ", " : ""),
			     word);
	    }
	}

	/* and this word to the new to list */
	if(*new_to_list != '\0')
	    strfcat(new_to_list, " ", sizeof new_to_list);
	strfcat(new_to_list, word, sizeof new_to_list);

	if((i = j) > 0)
	    strfcpy(word, next_word, sizeof word);
    }

    /* if new to list is different from original, update original */
    if (changed)
	strfcpy(to, new_to_list, size_to);

    return( expanded_information > 0 ? 1 : 0 );
}
#endif

void write_addr_header(f,hdr_name,addr,top_encoding)
     FILE *f;
     char *hdr_name;
     struct addr_item * addr;
     int top_encoding;
{
    struct addr_item *p;
    long POS = ftell(f);

#define LEN (ftell(f)-POS)
#define WRAP print_EOLN(f,top_encoding), (POS = ftell(f)), fputc(' ',f)

    fputs(hdr_name,f);
    fputs(": ",f);

    dprint(15,(debugfile,"write_addr_header: %s:",hdr_name));
    
    for (p = addr; p && p->fullname && p->addr && p->comment; p++) {
	CONST int al = strlen(p->addr);
	CONST int fn = strlen(p->fullname);
	CONST int cm = strlen(p->comment);

	dprint(15,(debugfile,"\n          [%d] ",p-addr));

	if (p != addr) {
	    fputs(", ",f);
	    dprint(15,(debugfile,", "));
	}
	if (LEN > 70 || al + fn + cm + LEN > 76) {
	    WRAP;
	    dprint(15,(debugfile,"[WRAP]\n          [%d] ",p-addr));
	}
	
	if (p->fullname[0] || ! p->addr[0] || '@' == p->addr[0]) {
	    if (p->fullname[0]) {
		char buffer[VERY_LONG_STRING];	       
		char *c;
		int need_quotation = 0;
		int size = 5 + strlen(p->fullname) * 2;		
		char *buffer2 = safe_malloc(size), *w = buffer2;

		dprint(15,(debugfile,"\n          {fullname=%s, ",
			   p->fullname));



		if (NULL != strpbrk(p->fullname,"()<>@,;:\\\"/[]?= \t"))
		    need_quotation = 1;
		if (need_quotation)
		    *w++ = '"';
		    
		for (c = p->fullname; 
		     *c != '\0' && w < buffer2 + size -4; 
		     c++) {
		    if (need_quotation && ('\\' == *c || '"' == *c)) 
			*w++ = '\\';		    
		    *w++ = *c;
		}
		if (need_quotation)
		    *w++ = '"';

		*w = '\0';

		dprint(15,(debugfile,"quoted=%s}\n",
			   buffer2));

		if (!allow_no_hdrencoding) {		    
		    rfc1522_encode_text(buffer, sizeof(buffer),
					buffer2,HDR_PHRASE);
		    c = buffer;		    
		} else
		    c = buffer2;
		
		dprint(15,(debugfile,"\n          [%d] ",p-addr));
	       		
		for (; *c != '\0'; c++) {
		    if (*c == '\n' || 
			whitespace(*c) && (LEN > 100)) {
			WRAP;
			dprint(15,(debugfile,"[WRAP]\n          [%d] ",
				   p-addr));
		    } else {
			fputc(*c,f);
			dprint(15,(debugfile,"%c",*c));
		    }
		}
		free(buffer2);
	    }

	    if (LEN > 85) {
		WRAP;
		dprint(15,(debugfile,"[WRAP]\n          [%d] ",p-addr));
	    } else {
		fputc(' ',f);
		dprint(15,(debugfile," "));
	    }

	    fputc('<',f);
	    fputs(p->addr,f);
	    fputc('>',f);
	    dprint(15,(debugfile,"<%s>",p->addr));
	} else {
	    fputs(p->addr,f);
	    dprint(15,(debugfile,"%s",p->addr));
	}

	if (p->comment[0]) {

	    dprint(15,(debugfile,"\n          {comment=%s}",p->comment));
	    dprint(15,(debugfile,"\n          [%d] ",p-addr));

	    if (LEN > 85) {
		dprint(15,(debugfile,"[WRAP]\n          [%d] ",p-addr));
		WRAP;
	    } else {
		fputc(' ',f);
		dprint(15,(debugfile," "));
	    }
	    if (allow_no_hdrencoding) {
		char *c;

		fputc('(',f);			
		dprint(15,(debugfile,"("));

		for (c = p->comment; *c != '\0'; c++) {
		    switch(*c) {
		    case '\\': case '"': case '(': case ')': 
			fputc('\\',f);			
			dprint(15,(debugfile,"\\"));
		    }
		    if (*c == '\n' || 
			whitespace(*c) && (LEN > 100)) {
			WRAP;
			dprint(15,(debugfile,"[WRAP]\n          [%d] ",
				   p-addr));
		    } else {
			fputc(*c,f);
			dprint(15,(debugfile,"%c",*c));
		    }
		}
		fputc(')',f);			
		dprint(15,(debugfile,")"));

	    } else {
		char *c;
		char buffer[VERY_LONG_STRING];
		
		rfc1522_encode_text(buffer, sizeof(buffer),
				    p->comment,HDR_COMMENT);

		dprint(15,(debugfile,"\n          {encoded=%s}",buffer));
		dprint(15,(debugfile,"\n          [%d] ",p-addr));

		fputc('(',f);			
		dprint(15,(debugfile,"("));
		for (c = buffer; *c != '\0'; c++) {
		    if (*c == '\n' || 
			whitespace(*c) && (LEN > 100)) {
			WRAP;
			dprint(15,(debugfile,"[WRAP]\n          [%d] ",
				   p-addr));
		    } else {
			fputc(*c,f);
			dprint(15,(debugfile,"%c",*c));
		    }
		}
		fputc(')',f);			
		dprint(15,(debugfile,")"));
	    }
	}
    }
    print_EOLN(f,top_encoding);
    dprint(15,(debugfile,"[EOLN]\n"));
}

int check_8bit_addr(addr)
     struct addr_item * addr;
{
    struct addr_item *p;
    for (p = addr; p && p->fullname && p->addr && p->comment; p++) {
	if (check_8bit_str(p->fullname))
	    return TRUE;
	if (check_8bit_str(p->comment))
	    return TRUE;
    }
    return FALSE;
}

void write_text_header (f,hdr_name,text, top_encoding)
     FILE *f;
     char *hdr_name; 
     char * text;
     int top_encoding;
{
    long POS = ftell(f);
    char *c;
    fputs(hdr_name,f);
    fputs(": ",f);

    dprint(15,(debugfile,"write_text_header: %s:",hdr_name));

    for (c = text; *c != '\0'; c++) {
	if (*c == '\n' || 
	    whitespace(*c) && (LEN > 75)) {
	    WRAP;
	    dprint(15,(debugfile,"[WRAP]\n          "));
	} else {
	    fputc(*c,f);
	    dprint(15,(debugfile,"%c",*c));
	}
    }
    print_EOLN(f,top_encoding);    
    dprint(15,(debugfile,"[EOLN]\n"));
}

#undef LEN
#undef WRAP

/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 * End:
 */
