#include <stdio.h>
#include <wchar.h>
#include <locale.h>

int main(int argc, char **argv)
{
  char src[BUFSIZ],*p;
  wchar_t dst[BUFSIZ], *wp;
  FILE *F;
  char *progname = argv[0];

  setlocale(LC_CTYPE, "");
  setlocale(LC_MESSAGES, "");
  

  switch (argc) {
  case 1:
    F=stdin;
    break;
  case 2:
    if ((F=fopen(argv[1],"r")) == NULL) {
      fprintf(stderr,"%s:can't open file %s\n",argv[0],argv[1]);
      exit(1);
    }
    break;
  default:
    fprintf(stderr, "usage: %s [<filename>]\n", progname);
    exit (0);
  }

  p=src;

  while (fgets(p, BUFSIZ, F)!=NULL) {
    if (mbsnrtowcs(dst,&p,BUFSIZ,BUFSIZ,NULL)<0) {
      fprintf(stderr,"%s: mbsnrtowcs() error\n",progname);
      exit(1);
    }
    for (wp = dst; ; wp++) {
      printf("0x%08lX\n",*wp);
      if (!*wp) break;
    }
  }

  exit(0);
  return;
}
