/*
 * iconv.c
 * Copyright (c) 1998 Fumitoshi UKAI <ukai@debian.or.jp>
 * 
 * You can use, redistribute and/or modify it under the terms of
 * GNU General Public License. See the file /usr/doc/copyright/GPL
 * 
 */

#include <locale.h>
#include <stdlib.h>
#include <stdio.h>

int
main(int argc, char **argv)
{
    char buf[4096], buf2[4096];
    wchar_t wbuf[4096];
    char *p;
    int err;
    int len;

    if (argc < 3) {
	fprintf(stderr, "usage: %s <source-encoding> <dest-encoding>\n",
		argv[0]);
	exit(1);
    }

    while (fgets(buf, sizeof(buf), stdin) != NULL) {
	p = setlocale(LC_CTYPE, argv[1]);
	if (p == NULL) {
	    perror("setlocale <source>");
	    exit(1);
	}
	len = strlen(buf) + 1;
	err = mbstowcs(wbuf, buf, sizeof(wbuf)/sizeof(wchar_t));
	if (err < 0) {
	    perror("mbstowcs");
	    exit(1);
	}
	p = setlocale(LC_CTYPE, argv[2]);
	if (p == NULL) {
	    perror("setlocale <dest>");
	    exit(1);
	}
	err = wcstombs(buf2, wbuf, sizeof(buf2));
	if (err < 0) {
	    perror("wcstombs");
	    exit(1);
	}
	printf("%s", buf2);
    }
    exit(0);
}
