/*
   libffm	- Free, pretty fast replacement for some math (libm) routines 
			on Linux/AXP, optimized for the 21164

   Copyright (C) 1998  Joachim Wesner <joachim.wesner@frankfurt.netsurf.de>
                  and  Kazushige Goto <goto@statabo.rim.or.jp>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library (see file COPYING.LIB); if not, write 
   to the Free Software Foundation, Inc., 675 Mass Ave, Cambridge, 
   MA 02139, USA.
*/
/*
   Fast combined asin/acos approximation including range reduction by 
   Joachim Wesner, <joachim.wesner@frankfurt.netsurf.de>, see also 
   mc 8/1991 p. 78-93. This version done in June/July 1998.

   No special handling of illegal arguments or NANs, yet !!!
*/
/*
   improved and modified by Kazushige Goto <goto@statabo.rim.or.jp>
*/

        .set noreorder
        .set noat

#ifdef __ELF__
	.section .rodata
#else
	.rdata
#endif

	.align 5
K:
        .t_floating  5.00000000000000000000e-1
	.quad 0x3ff7ffffffc00000         
	.t_floating  1.00000000000000000000
	.t_floating  1.50000000000000000000

        .t_floating -2.38238591536702379869e1
        .t_floating  1.50952708410306058795e2
        .t_floating  4.17144302482604132365e2
        .t_floating -6.96745734473506517226e-1

        .t_floating -3.96888629975048772280e1
        .t_floating -3.81863033617501514527e2
        .t_floating -1.64210967144985602317e2
        .t_floating  1.01525222338064633476e1

        .t_floating  5.72082278778917299178e1
        .t_floating -2.73684945241642552105e1
        .t_floating  1.57079632679489655800e0
        .t_floating  3.14159265358979311600e0

sqrtdata:
	
.long   0x1500, 0x2ef8,   0x4d67,  0x6b02,  0x87be,  0xa395,  0xbe7a,  0xd866
.long   0xf14a, 0x1091b, 0x11fcd, 0x13552, 0x14999, 0x15c98, 0x16e34, 0x17e5f
.long  0x18d03, 0x19a01, 0x1a545, 0x1ae8a, 0x1b5c4, 0x1bb01, 0x1bfde, 0x1c28d
.long  0x1c2de, 0x1c0db, 0x1ba73, 0x1b11c, 0x1a4b5, 0x1953d, 0x18266, 0x16be0
.long  0x1683e, 0x179d8, 0x18a4d, 0x19992, 0x1a789, 0x1b445, 0x1bf61, 0x1c989
.long  0x1d16d, 0x1d77b, 0x1dddf, 0x1e2ad, 0x1e5bf, 0x1e6e8, 0x1e654, 0x1e3cd
.long  0x1df2a, 0x1d635, 0x1cb16, 0x1be2c, 0x1ae4e, 0x19bde, 0x1868e, 0x16e2e
.long  0x1527f, 0x1334a, 0x11051,  0xe951,  0xbe01,  0x8e0d,  0x5924,  0x1edd

.text

        .align  5
        .globl  asin
        .ent    asin
asin:
        fabs    $f16, $f0               # x1 = fabs(x)
        ldgp    $29,.-asin($27)
        mult    $f16, $f16, $f11	# y1 = x * x
        .frame  $30,16,$26,0

#ifdef PROF
	lda	$28, _mcount
	jsr	$28, ($28), _mcount
	unop
	unop
#endif
	.prologue 1

        lda     $28,K
        br      $17, $cont
        .end    asin

        .align  5
        .globl  acos
        .ent    acos
acos:
        fabs    $f16, $f0               # x1 = fabs(x)
        ldgp    $29,.-acos($27)
        mult    $f16, $f16, $f11	# y1 = x * x
        .frame  $30,16,$26,0

#ifdef PROF
	lda	$28, _mcount
	jsr	$28, ($28), _mcount
	unop
	unop
#endif
	.prologue 1

        mov     1, $17
        unop
        lda     $28,K
        unop
	.align 4
$cont:
        ldt     $f10,  0($28)		# K[0]
        ldt     $f23,  64($28)		# K[5]
        ldt     $f19,  32($28)		# K[1]
        ldt     $f27,  96($28)		# K[9]

        cmptlt  $f10, $f0,  $f15	# flag = ( K[0] < x1)
        mult    $f0,  $f10, $f1		# r1 = x1 * K[0]
        lda     $30, -16($30)
        ldt     $f20,  40($28)		# K[2]

        mult    $f11,  $f11,  $f12	# y2 = y1 * y1
        ldt     $f21,  48($28)		# K[3]
        ldt     $f22,  56($28)		# K[4]
        fbeq    $f15,  $L4

        subt    $f10, $f1, $f11         # y1 = K[0] - r1
        bsr     $27, inner_sqrt
        mult    $f11, $f11, $f12        # y2 = y1 * y1
        addt    $f0,  $f0,  $f0         # x1 = 2 * sqrt(y1)
        .align 4

$L4:
        mult    $f20, $f11,  $f20        # r2($f19) = K[2] * y1
        ldt     $f24,  72($28)		# K[6]
        addt    $f11,  $f19, $f19        # r1($f20) = y1 + K[1]
        ldt     $f25,  80($28)		# K[7]
        mult    $f21, $f11,  $f21        # r3($f21) = K[3] * y1
        ldt     $f26,  88($28)		# K[8]
        mult    $f22, $f11,  $f22        # t1($f22) = K[4] * y1
        ldt     $f28, 104($28)		# K[10]

        mult    $f23, $f11,  $f23        # t2($f23) = K[5] * y1
        addt    $f20, $f24, $f20        # r2 = r2 + K[6]

        mult    $f12, $f12, $f14        # y4($f13) = y2 * y2
        addt    $f21, $f25, $f21        # r3 = r3 + K[7]

        mult    $f12, $f11,  $f13        # y3($f14) = y2 * y1
        addt    $f22, $f26, $f22        # t1 = t1 + K[8]
        mult    $f0,  $f11,  $f18        # t3($f18) = x1 * y1
        addt    $f23, $f27, $f23        # t2 = t2 + K[9]

        mult    $f20, $f12, $f20        # r2 = r2 * y2
        mult    $f19, $f14, $f19        # r1 = r1 * y4
        mult    $f22, $f13, $f22        # t1 = t1 * y3
        mult    $f23, $f11, $f23        # t2 = t2 * y1

        addt    $f19, $f20, $f19        # r1 = r1 + r2
        addt    $f22, $f23, $f22        # t1 = t1 + t2

        addt    $f19, $f21, $f19        # r1 = r1 + r3
        addt    $f22, $f28, $f22        # t1 = t1 + K[10]

        mult    $f22, $f18, $f22        # t1 = t1 * t3
        divt    $f22, $f19, $f19        # t1/r1

# Very very long wait, wait, wait, ....

        ldt     $f29, 112($28)		# K[11]
        ldt     $f30, 120($28)		# K[12]
        addq    $30, 16,$30

        addt    $f0,  $f19, $f0         # y = x1 + t1/r1

        blbs    $17,  $L5               # if (mode) goto $L5

        fbeq    $f15, $L10              # if (!$flag) goto $L10
        fbge    $f16, $L13              # if (x>=0) goto $L8

        subt    $f0, $f29,  $f0         # y = K[11] - y
        ret     $31,($26),1

$L13:
        subt    $f29, $f0,  $f0         # y = K[11] - y
        ret     $31,($26),1

$L10:
        fbge    $f16, $L8
        fneg    $f0,  $f0               # y = -y
$L8:
        ret     $31,($26),1
        .align 4
$L5:
        fbeq    $f15,  $L9              # if (flag==0) goto $L9
        fbge    $f16,  $L11             # if (x>0) goto $L8
        subt    $f30,  $f0, $f0         # y = K[12] - y
$L11:
        ret     $31,($26),1
        .align 4
$L9:
        fble    $f16, $L12
        subt    $f29, $f0,  $f0         # r1 = K[11] - y
        ret     $31,($26),1
$L12:
        addt    $f29, $f0,  $f0         # r2 = K[11] + y
        ret     $31,($26),1

        .end    acos

	.align 5

	.ent  inner_sqrt
inner_sqrt: 	
	.frame $30 ,  0, $26  
	.prologue 1
	stt	$f11, 0($30) 
	mult	$f11, $f10, $f24		# x*0.5
	ldah	$2 , 0x5fe8
	nop

	ldq	$3 ,  0($30)
	srl	$3 , 33, $1
	subl	$2 , $1 , $2
	srl	$2 , 12, $1
	and	$1 , 0xfc, $1

	addq	$1 , $28 , $1
	ldl	$1 , 128($1)
	subl	$2 , $1 , $2
	sll	$2 , 32, $2
	stq	$2 ,   8($30)
	ldt	$f25,  8($28)
	ldt	$f30, 16($28)
	ldt	$f29, 24($28)
	ldt	$f0,   8($30)

	mult	$f24, $f0,  $f1		# fm    : $f10 = (x * 0.5) * y
	mult	$f1,  $f0,  $f1		# fm    : $f10 = ((x * 0.5) * y) * y
	subt	$f29, $f1,  $f1		# fa    : $f1 = (1.5 - 0.5*x*y*y)
	mult	$f0,  $f1,  $f0		# fm    : yp = y*(1.5 - 0.5*x*y*y)

 	mult	$f24, $f0, $f1		# fm    : $f24 = x * 0.5 * yp
	mult	$f1,  $f0, $f24		# fm    : $f24 = (x * 0.5 * yp) * yp
	subt	$f25, $f24, $f1		# fa    : $f1= (1.5-2^-30) - 0.5*x*yp*yp
	mult	$f0,  $f1,  $f0		# fm    : ypp = $f13 = yp*$f1
	mult	$f11, $f0,  $f1 	# fm    : z = $f10 = x * ypp

	mult	$f1,  $f0,  $f0 	# fm    : $f24 = z*ypp
	mult	$f1,  $f10, $f24	# fm    : $f10 = z*0.5
	subt	$f30, $f0,  $f0		# .. fa : $f1 = 1 - z*ypp
	mult	$f24, $f0,  $f0		# fm    : $f0 = z*0.5*(1 - z*ypp)
	addt	$f1,  $f0,  $f0		# fa    : zp=res=$f0= z + z*0.5*(1 - z*ypp)

        ret     $31,($27),1

	.end  inner_sqrt  
