/**
 *
 * $Id: ToggleB.c,v 1.35 1998/10/10 07:37:36 gritton Exp $
 *
 * Copyright (C) 1995 Free Software Foundation, Inc.
 *
 * This file is part of the GNU LessTif Library.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 **/

static const char rcsid[] = "$Id: ToggleB.c,v 1.35 1998/10/10 07:37:36 gritton Exp $";

#include <LTconfig.h>
#include <XmI/XmI.h>

#include <Xm/XmP.h>
#include <Xm/ToggleBP.h>
#include <Xm/RowColumnP.h>
#include <Xm/MenuUtilP.h>
#include <Xm/MenuShell.h>
#include <Xm/CascadeB.h>
#include <Xm/CascadeBG.h>
#include <Xm/TransltnsP.h>
#include <X11/ShellP.h>

extern void _XmRadioHandler(Widget, Widget, XmToggleButtonCallbackStruct *,
                Boolean);

#ifndef __STDC__
#include <varargs.h>
#else
#include <stdarg.h>
#endif

#include <XmI/DebugUtil.h>

#include <Xm/ToggleBGP.h>

/* Forward Declarations */

static void class_initialize();

static void class_part_initialize(WidgetClass w_class);

static void initialize(Widget request, Widget new_w,
		       ArgList args, Cardinal *num_args);

static void initialize_prehook(Widget request, Widget new_w,
			       ArgList args, Cardinal *num_args);

static void initialize_posthook(Widget request, Widget new_w,
				ArgList args, Cardinal *num_args);

static void destroy(Widget w);

static void expose(Widget w, XEvent *event, Region region);

static Boolean set_values(Widget current, Widget request, Widget new_w,
			  ArgList args, Cardinal *num_args);

static void MenuProcEntry(int proc, Widget rc,...);

/*
 * Resources for the toggleButton class
 */
#define Offset(field) XtOffsetOf(XmToggleButtonRec, toggle.field)
static XtResource resources[] =
{
    {
	XmNindicatorSize, XmCIndicatorSize, XmRVerticalDimension,
	sizeof(Dimension), Offset(indicator_dim),
	XmRImmediate, (XtPointer)XmINVALID_DIMENSION
    },
    {
	XmNindicatorType, XmCIndicatorType, XmRIndicatorType,
	sizeof(unsigned char), Offset(ind_type),
	XmRImmediate, (XtPointer)((unsigned char)XmUNSPECIFIED)
    },
    {
	XmNvisibleWhenOff, XmCVisibleWhenOff, XmRBoolean,
	sizeof(Boolean), Offset(visible),
	XmRImmediate, (XtPointer)'T'
    },
    {
	XmNspacing, XmCSpacing, XmRHorizontalDimension,
	sizeof(Dimension), Offset(spacing),
	XtRImmediate, (XtPointer)4
    },
    {
	XmNselectPixmap, XmCSelectPixmap, XmRPrimForegroundPixmap,
	sizeof(Pixmap), Offset(on_pixmap),
	XmRImmediate, (XtPointer)XmUNSPECIFIED_PIXMAP
    },
    {
XmNselectInsensitivePixmap, XmCSelectInsensitivePixmap, XmRPrimForegroundPixmap,
	sizeof(Pixmap), Offset(insen_pixmap),
	XmRImmediate, (XtPointer)XmUNSPECIFIED_PIXMAP
    },
    {
	XmNset, XmCSet, XmRBoolean,
	sizeof(Boolean), Offset(set),
	XmRImmediate, (XtPointer)False
    },
    {
	XmNindicatorOn, XmCIndicatorOn, XmRBoolean,
	sizeof(Boolean), Offset(ind_on),
	XtRImmediate, (XtPointer)True
    },
    {
	XmNfillOnSelect, XmCFillOnSelect, XmRBoolean,
	sizeof(Boolean), Offset(fill_on_select),
	XtRImmediate, (XtPointer)85	/* I don't know why */
    },
    {
	XmNselectColor, XmCSelectColor, XmRPixel,
	sizeof(Pixel), Offset(select_color),
	XmRCallProc, (XtPointer)_XmSelectColorDefault
    },
    {
	XmNvalueChangedCallback, XmCValueChangedCallback, XmRCallback,
	sizeof(XtCallbackList), Offset(value_changed_CB),
	XmRPointer, (XtPointer)NULL
    },
    {
	XmNarmCallback, XmCArmCallback, XmRCallback,
	sizeof(XtCallbackList), Offset(arm_CB),
	XmRPointer, (XtPointer)NULL
    },
    {
	XmNdisarmCallback, XmCDisarmCallback, XmRCallback,
	sizeof(XtCallbackList), Offset(disarm_CB),
	XmRPointer, (XtPointer)NULL
    },
    {
	XmNtraversalOn, XmCTraversalOn, XmRBoolean,
	sizeof(Boolean), XtOffsetOf(XmToggleButtonRec, primitive.traversal_on),
	XmRImmediate, (XtPointer)True
    },
    {
	XmNhighlightThickness, XmCHighlightThickness, XmRHorizontalDimension,
sizeof(Dimension), XtOffsetOf(XmToggleButtonRec, primitive.highlight_thickness),
	XmRImmediate, (XtPointer)2
    }
};

static XmSyntheticResource syn_resources[] =
{
    {
	XmNspacing,
	sizeof(Dimension), Offset(spacing),
	_XmFromHorizontalPixels, _XmToHorizontalPixels
    },
    {
	XmNindicatorSize,
	sizeof(Dimension), Offset(spacing),
	_XmFromVerticalPixels, _XmToVerticalPixels
    }
};

static void Arm(Widget w, XEvent *event,
		String *params, Cardinal *num_params);

static void Disarm(Widget w, XEvent *event,
		   String *params, Cardinal *num_params);

static void ArmAndActivate(Widget w, XEvent *event,
			   String *params, Cardinal *num_params);

static void Help(Widget w, XEvent *event,
		 String *params, Cardinal *num_params);

static void EnterWindow(Widget w, XEvent *event,
			String *params, Cardinal *num_params);

static void LeaveWindow(Widget w, XEvent *event,
			String *params, Cardinal *num_params);

static void Select(Widget w, XEvent *event,
		   String *params, Cardinal *num_params);

static void ButtonUp(Widget w, XEvent *event,
		     String *params, Cardinal *num_params);

static void ButtonDown(Widget w, XEvent *event,
		       String *params, Cardinal *num_params);


static XtTranslations default_trans = NULL;
static XtTranslations menu_trans = NULL;

static XtActionsRec actions[] =
{
    {"Arm", Arm},
    {"ArmAndActivate", ArmAndActivate},
    {"Disarm", Disarm},
    {"Select", Select},
    {"Enter", EnterWindow},
    {"Leave", LeaveWindow},
    {"BtnDown", ButtonDown},
    {"BtnUp", ButtonUp},

    {"Help", Help},
};

/* *INDENT-OFF* */
static XmBaseClassExtRec _XmToggleBCoreClassExtRec = {
    /* next_extension            */ NULL,
    /* record_type               */ NULLQUARK,                             
    /* version                   */ XmBaseClassExtVersion,
    /* size                      */ sizeof(XmBaseClassExtRec),
    /* initialize_prehook        */ initialize_prehook,
    /* set_values_prehook        */ XmInheritSetValuesPrehook,
    /* initialize_posthook       */ initialize_posthook,
    /* set_values_posthook       */ XmInheritSetValuesPosthook,
    /* secondary_object_class    */ XmInheritClass,
    /* secondary_object_create   */ XmInheritSecObjectCreate,
    /* get_secondary_resources   */ XmInheritGetSecResData,
    /* fast_subclass             */ { 0 },
    /* get_values_prehook        */ XmInheritGetValuesPrehook,
    /* get_values_posthook       */ XmInheritGetValuesPosthook,
    /* class_part_init_prehook   */ NULL,
    /* class_part_init_posthook  */ NULL,
    /* ext_resources             */ NULL,
    /* compiled_ext_resources    */ NULL,
    /* num_ext_resources         */ 0,
    /* use_sub_resources         */ False,
    /* widget_navigable          */ XmInheritWidgetNavigable,
    /* focus_change              */ XmInheritFocusChange,
    /* wrapper_data              */ NULL
};

XmPrimitiveClassExtRec _XmToggleBPrimClassExtRec = {
    /* next_extension      */ NULL,
    /* record_type         */ NULLQUARK,
    /* version             */ XmPrimitiveClassExtVersion,
    /* record_size         */ sizeof(XmPrimitiveClassExtRec),
    /* widget_baseline     */ XmInheritBaselineProc,
    /* widget_display_rect */ XmInheritDisplayRectProc,
    /* widget_margins      */ NULL
};

XmToggleButtonClassRec xmToggleButtonClassRec = {
    /* Core class part */
    {
	/* superclass            */ (WidgetClass) &xmLabelClassRec,
        /* class_name            */ "XmToggleButton",
	/* widget_size           */ sizeof(XmToggleButtonRec),
	/* class_initialize      */ class_initialize,
	/* class_part_initialize */ class_part_initialize,
	/* class_inited          */ False,
	/* initialize            */ initialize,
	/* initialize_hook       */ NULL,
	/* realize               */ XtInheritRealize,
	/* actions               */ actions,
	/* num_actions           */ XtNumber(actions),
	/* resources             */ resources,
	/* num_resources         */ XtNumber(resources),
	/* xrm_class             */ NULLQUARK,
	/* compress_motion       */ True,
	/* compress_exposure     */ XtExposeCompressMaximal,
	/* compress_enterleave   */ True,
	/* visible_interest      */ False,
	/* destroy               */ destroy,
	/* resize                */ XtInheritResize,
	/* expose                */ expose,
	/* set_values            */ set_values,
	/* set_values_hook       */ NULL,
	/* set_values_almost     */ XtInheritSetValuesAlmost,
	/* get_values_hook       */ NULL,
	/* accept_focus          */ NULL,
	/* version               */ XtVersion,
	/* callback offsets      */ NULL,
	/* tm_table              */ NULL,
	/* query_geometry        */ XtInheritQueryGeometry,
	/* display_accelerator   */ NULL,
	/* extension             */ (XtPointer)&_XmToggleBCoreClassExtRec
    },
    /* Primitive Class part */
    {
        /* border_highlight      */ XmInheritBorderHighlight,
        /* border_unhighlight    */ XmInheritBorderUnhighlight,
        /* translations          */ XtInheritTranslations,
        /* arm_and_activate_proc */ ArmAndActivate,
        /* synthetic resources   */ syn_resources,
        /* num syn res           */ XtNumber(syn_resources),
        /* extension             */ (XtPointer)&_XmToggleBPrimClassExtRec
    },
    /* Label Class part */
    {
        /* setOverrideCallback */ XmInheritSetOverrideCallback,
        /* menuProcs           */ XmInheritMenuProc,
        /* translations        */ XtInheritTranslations,
        /* extension           */ NULL
    },
    /* ToggleButton Class part */
    {
	/* extension */ NULL
    }
};
/* *INDENT-ON* */

WidgetClass xmToggleButtonWidgetClass = (WidgetClass)&xmToggleButtonClassRec;


/* 
 * Some #defines to make the code below more readable
 */

#define IN_MENU(w) (Lab_MenuType(w) == XmMENU_POPUP || \
                    Lab_MenuType(w) == XmMENU_PULLDOWN)

static void
class_initialize()
{
    menu_trans = XtParseTranslationTable(_XmToggleB_menuTranslations);
    default_trans = XtParseTranslationTable(_XmToggleB_defaultTranslations);

    _XmToggleBCoreClassExtRec.record_type = XmQmotif;
}

static void
class_part_initialize(WidgetClass widget_class)
{
    _XmFastSubclassInit(widget_class, XmTOGGLE_BUTTON_BIT);
}

static void
CreateSelectGC(Widget w)
{
    XGCValues values;
    XtGCMask mask;

    mask = GCForeground | GCBackground | GCFillStyle | GCFunction |
	GCSubwindowMode | GCGraphicsExposures | GCPlaneMask;

    if (CoreBackgroundPixmap(w) != None &&
        CoreBackgroundPixmap(w) != XmUNSPECIFIED_PIXMAP)
    {
        /* we're dealing with a pixmap'ed background */
        mask |= GCTile;
 
        values.tile = CoreBackgroundPixmap(w);
        values.fill_style = FillTiled;
    }
    else
    {
        values.fill_style = FillSolid;
    }
 
    values.function = GXcopy;
    values.plane_mask = -1;
    values.subwindow_mode = ClipByChildren;
    values.graphics_exposures = False;
    values.foreground = TB_SelectColor(w);
    values.background = XtBackground(w);

    TB_SelectGC(w) = XtGetGC(w, mask, &values);
}

static void
CreateBackgroundGC(Widget w)
{
    XGCValues values;
    XtGCMask mask;

    mask = GCForeground | GCBackground | GCFillStyle | GCFunction |
	GCSubwindowMode | GCGraphicsExposures | GCPlaneMask;

    if (CoreBackgroundPixmap(w) != None &&
        CoreBackgroundPixmap(w) != XmUNSPECIFIED_PIXMAP)
    {
        /* we're dealing with a pixmap'ed background */
        mask |= GCTile;
 
        values.tile = CoreBackgroundPixmap(w);
        values.fill_style = FillTiled;
    }
    else
    {
        values.fill_style = FillSolid;
    }
 
    values.function = GXcopy;
    values.plane_mask = -1;
    values.subwindow_mode = ClipByChildren;
    values.graphics_exposures = False;
    values.foreground = XtBackground(w);
    values.background = Prim_Foreground(w);

    TB_BackgroundGC(w) = XtGetGC(w, mask, &values);
}

static void
initialize_prehook(Widget request, Widget new_w,
		   ArgList args, Cardinal *num_args)
{
    _XmSaveCoreClassTranslations(new_w);

    if (XmIsRowColumn(XtParent(new_w)) &&
	(RC_Type(XtParent(new_w)) == XmMENU_PULLDOWN ||
	 RC_Type(XtParent(new_w)) == XmMENU_POPUP))
    {
	CoreClassTranslations(new_w) = (String)menu_trans;
    }
    else
    {
	CoreClassTranslations(new_w) = (String)default_trans;
    }
}

static void
initialize_posthook(Widget request, Widget new_w,
		    ArgList args, Cardinal *num_args)
{
    _XmRestoreCoreClassTranslations(new_w);
}

static void
initialize(Widget request, Widget new_w,
	   ArgList args, Cardinal *num_args)
{
    DEBUGOUT(XdbDebug(__FILE__, new_w,
		      "initialize: %i args\n"
		      "\trequest X %5i Y %5i W %5i H %5i\n"
		      "\t  new_w X %5i Y %5i W %5i H %5i\n",
		      *num_args,
		      XtX(request), XtY(request),
		      XtWidth(request), XtHeight(request),
		      XtX(new_w), XtY(new_w),
		      XtWidth(new_w), XtHeight(new_w)));
    DEBUGOUT(XdbPrintArgList(__FILE__, new_w, args, *num_args, False));

    TB_Armed(new_w) = False;

    TB_VisualSet(new_w) = TB_IndicatorSet(new_w) = TB_Set(new_w);

    if (TB_IndOn(new_w))
    {
	if (TB_IndicatorDim(new_w) == XmINVALID_DIMENSION)
	{
	    if (IN_MENU(new_w) && Lab_TextRect_height(new_w) != 0 &&
		Lab_TextRect_height(new_w) > 2 * Xm3D_ENHANCE_PIXEL)
	    {
		TB_IndicatorDim(new_w) = Lab_TextRect_height(new_w) -
		    2 * Xm3D_ENHANCE_PIXEL;
	    }
	    else
	    {
		TB_IndicatorDim(new_w) = XmDEFAULT_INDICATOR_DIM;
	    }
	}
	else
	{
	    TB_IndicatorDim(new_w) -= TB_Spacing(new_w);
	    TB_IndicatorDim(new_w) = TB_IndicatorDim(new_w) <
					2 * Xm3D_ENHANCE_PIXEL
						? 2 * Xm3D_ENHANCE_PIXEL
						: TB_IndicatorDim(new_w);
	}
    }
    else
    {
	TB_IndicatorDim(new_w) = 0;
    }

    CreateSelectGC(new_w);
    CreateBackgroundGC(new_w);

    if (TB_IndType(new_w) == (unsigned char)XmUNSPECIFIED)
    {
	if (XmIsRowColumn(XtParent(new_w)) &&
	    RC_RadioBehavior(XtParent(new_w)))
	{
	    TB_IndType(new_w) = XmONE_OF_MANY;
	}
	else
	{
	    TB_IndType(new_w) = XmN_OF_MANY;
	}
    }

#if 0
    /* rws 26 Sep 1998
       rowcolumn/test19 show this should not be here
     */
    if (TB_IndType(new_w) == XmONE_OF_MANY &&
	TB_IndicatorDim(new_w) > Xm3D_ENHANCE_PIXEL)
    {
	TB_IndicatorDim(new_w) -= Xm3D_ENHANCE_PIXEL;
    }
#endif

    /* allocate the normal and insensitive GC's */
    Lab_MarginLeft(new_w) = TB_IndicatorDim(new_w) + (TB_IndOn(new_w)
						      ? 2 * TB_Spacing(new_w)
						      : 0);

    if (!IN_MENU(new_w))
    {
	if (Prim_HighlightThickness(new_w) != 0)
	{
	    if (TB_IndOn(new_w))
	    {
		Lab_MarginTop(new_w) += Prim_HighlightThickness(new_w);
		Lab_MarginBottom(new_w) += Prim_HighlightThickness(new_w);
	    }
	}

	if (Prim_ShadowThickness(new_w) != 0)
	{
	    if (TB_IndOn(new_w))
	    {
		Lab_MarginTop(new_w) += Prim_ShadowThickness(new_w);
		Lab_MarginBottom(new_w) += Prim_ShadowThickness(new_w);
	    }
	}
    }

    if (Lab_MarginLeft(new_w) != Lab_MarginLeft(request))
    {

	if (XtWidth(request) == 0)
	{
	    XtWidth(new_w) = 0;
	}
	if (XtHeight(request) == 0)
	{
	    XtHeight(new_w) = 0;
	}

	_XmCalcLabelDimensions(new_w);
	/* rws 16 Aug 1997
	   Do not let the toggle button be any shorter than the height of
	   a character. This is to make sure the pixmap can be drawn
	   correctly. This shows in Mosaic with radio or toggle buttons in
	   a form
	 */
	{
	    XmString string;

	    string = XmStringCreateSimple("M");
	    if (XtHeight(new_w) < XmStringHeight(Lab_Font(new_w), string))
            {
	        XtHeight(new_w) = XmStringHeight(Lab_Font(new_w), string);
            }
	    XmStringFree(string);
	}

	(*xmLabelClassRec.core_class.resize) (new_w);
    }

    if (IN_MENU(new_w))
    {
	Lab_Highlight(new_w) = 0;
	if (Prim_ShadowThickness(new_w) == 0)
	{
	    Prim_ShadowThickness(new_w) = 2;
	}
	/* this works because the resource default is 'T', and users
	 * normally specify True */
	if (TB_Visible(new_w) == 'T')
	{
	    TB_Visible(new_w) = False;
	}
	LabClass_MenuProcs(XtClass(new_w)) = MenuProcEntry;
    }
}

static void
destroy(Widget w)
{
    XtReleaseGC(w, TB_SelectGC(w));
    XtReleaseGC(w, TB_BackgroundGC(w));
}

static Boolean
set_values(Widget old, Widget request, Widget new_w,
	   ArgList args, Cardinal *num_args)
{
    Boolean refresh_needed = False;

    DEBUGOUT(XdbDebug(__FILE__, new_w, "ToggleB set_values()\n"));

    if (TB_SelectColor(new_w) != TB_SelectColor(old))
    {
	XtReleaseGC(new_w, TB_SelectGC(new_w));
	CreateSelectGC(new_w);
	refresh_needed = True;
    }
    if (XtBackground(new_w) != XtBackground(old))
    {
	XtReleaseGC(new_w, TB_BackgroundGC(new_w));
	CreateBackgroundGC(new_w);
	refresh_needed = True;
    }

    TB_VisualSet(new_w) = TB_IndicatorSet(new_w) = TB_Set(new_w);
    if (TB_Set(old) != TB_Set(new_w))
    {
	refresh_needed = True;
    }

    if (TB_IndType(old) != TB_IndType(new_w))
    {
	if ((TB_IndType(new_w) != XmN_OF_MANY) &&
	    (TB_IndType(new_w) != XmONE_OF_MANY))
	{
	    TB_IndType(new_w) = TB_IndType(old);
	}
    }

    return refresh_needed;
}

static void
expose(Widget w, XEvent *event, Region region)
{
    Dimension fill;
    Boolean State = TB_VisualSet(w);
    Pixmap tmp_pix = XmUNSPECIFIED_PIXMAP, tmp2_pix = XmUNSPECIFIED_PIXMAP;

    DEBUGOUT(XdbDebug(__FILE__, w, "ToggleB Expose\n"));

    fill = Prim_TopShadowColor(w) != TB_SelectColor(w) &&
	Prim_BottomShadowColor(w) != TB_SelectColor(w);
    if (!TB_IndOn(w))
    {
	if (TB_FillOnSelect(w))
	{
	    XFillRectangle(XtDisplay(w), XtWindow(w),
			   State ? TB_SelectGC(w) : TB_BackgroundGC(w),
			   Lab_Highlight(w) + Lab_Shadow(w),
			   Lab_Highlight(w) + Lab_Shadow(w),
			   XtWidth(w)
			   - 2 * (Lab_Highlight(w) + Lab_Shadow(w)),
			   XtHeight(w)
			   - 2 * (Lab_Highlight(w) + Lab_Shadow(w)));
	}

	if (Lab_IsPixmap(w) && State &&
	    TB_OnPixmap(w) != XmUNSPECIFIED_PIXMAP)
	{
	    tmp_pix = Lab_Pixmap(w);
	    tmp2_pix = Lab_PixmapInsensitive(w);
	    Lab_Pixmap(w) = TB_OnPixmap(w);
	}
#define superclass (&xmLabelClassRec)
	(*superclass->core_class.expose) (w, event, region);
#undef superclass
	if (Lab_IsPixmap(w) && State &&
	    TB_OnPixmap(w) != XmUNSPECIFIED_PIXMAP)
	{
	    Lab_Pixmap(w) = tmp_pix;
	    Lab_PixmapInsensitive(w) = tmp2_pix;
	}

	if (!IN_MENU(w))
	{
	    _XmDrawShadows(XtDisplay(w), XtWindow(w),
			   Prim_TopShadowGC(w),
			   Prim_BottomShadowGC(w),
			   Lab_Highlight(w), Lab_Highlight(w),
			   XtWidth(w) - 2 * Lab_Highlight(w),
			   XtHeight(w) - 2 * Lab_Highlight(w),
			   Lab_Shadow(w),
			   State ? XmSHADOW_IN : XmSHADOW_OUT);
	}
	else
	{
	    _XmDrawShadows(XtDisplay(w), XtWindow(w),
			   Prim_TopShadowGC(w),
			   Prim_BottomShadowGC(w),
			   0, 0,
			   XtWidth(w), XtHeight(w),
			   Lab_Shadow(w),
			   TB_Armed(w) ? (int)XmSHADOW_OUT : (int)XmNO_LINE);
	}
    }
    else if (TB_IndType(w) == XmN_OF_MANY)
    {
	if (Lab_IsPixmap(w) && State &&
	    TB_OnPixmap(w) != XmUNSPECIFIED_PIXMAP)
	{
	    tmp_pix = Lab_Pixmap(w);
	    tmp2_pix = Lab_PixmapInsensitive(w);
	    Lab_Pixmap(w) = TB_OnPixmap(w);
	}
#define superclass (&xmLabelClassRec)
	(*superclass->core_class.expose) (w, event, region);
#undef superclass
	if (Lab_IsPixmap(w) && State &&
	    TB_OnPixmap(w) != XmUNSPECIFIED_PIXMAP)
	{
	    Lab_Pixmap(w) = tmp_pix;
	    Lab_PixmapInsensitive(w) = tmp2_pix;
	}

	XFillRectangle(XtDisplay(w), XtWindow(w),
		       State ? TB_SelectGC(w) : TB_BackgroundGC(w),
		       TB_Spacing(w) + Lab_Highlight(w) + Lab_Shadow(w) + 2 +
		       (1 - fill),
		       (XtHeight(w) - TB_IndicatorDim(w)) / 2 + 2 + (1 - fill),
		       TB_IndicatorDim(w) - 4 - ((1 - fill) << 1),
		       TB_IndicatorDim(w) - 4 - ((1 - fill) << 1));

	if (TB_Visible(w) || State)
	{
	    _XmDrawShadows(XtDisplay(w), XtWindow(w),
			   Prim_TopShadowGC(w),
			   Prim_BottomShadowGC(w),
			   TB_Spacing(w) + Lab_Highlight(w) + Lab_Shadow(w),
			   (XtHeight(w) - TB_IndicatorDim(w)) / 2,
			   TB_IndicatorDim(w), TB_IndicatorDim(w),
			   2, State ? XmSHADOW_IN : XmSHADOW_OUT);
	}
	if (!IN_MENU(w))
	{
	    _XmDrawShadows(XtDisplay(w), XtWindow(w),
			   Prim_TopShadowGC(w),
			   Prim_BottomShadowGC(w),
			   Prim_HighlightThickness(w),
			   Prim_HighlightThickness(w),
			   XtWidth(w) - 2 * Prim_HighlightThickness(w),
			   XtHeight(w) - 2 * Prim_HighlightThickness(w),
			   Lab_Shadow(w),
			   XmSHADOW_OUT);
	}
	else
	{
	    _XmDrawShadows(XtDisplay(w), XtWindow(w),
			   Prim_TopShadowGC(w),
			   Prim_BottomShadowGC(w),
			   0, 0,
			   XtWidth(w), XtHeight(w),
			   Lab_Shadow(w),
			   TB_Armed(w) ? (int)XmSHADOW_OUT : (int)XmNO_LINE);
	}
    }
    else
    {
	if (Lab_IsPixmap(w) && State &&
	    TB_OnPixmap(w) != XmUNSPECIFIED_PIXMAP)
	{
	    tmp_pix = Lab_Pixmap(w);
	    tmp2_pix = Lab_PixmapInsensitive(w);
	    Lab_Pixmap(w) = TB_OnPixmap(w);
	}
#define superclass (&xmLabelClassRec)
	(*superclass->core_class.expose) (w, event, region);
#undef superclass
	if (Lab_IsPixmap(w) && State &&
	    TB_OnPixmap(w) != XmUNSPECIFIED_PIXMAP)
	{
	    Lab_Pixmap(w) = tmp_pix;
	    Lab_PixmapInsensitive(w) = tmp2_pix;
	}

	if (TB_Visible(w) || State)
	{
	    _XmDrawDiamond(XtDisplay(w), XtWindow(w),
			   State
			   ? Prim_TopShadowGC(w)
			   : Prim_BottomShadowGC(w),
			   State
			   ? Prim_BottomShadowGC(w)
			   : Prim_TopShadowGC(w),
			   State ? TB_SelectGC(w) : TB_BackgroundGC(w),
			   TB_Spacing(w) + Lab_Highlight(w),
			   (XtHeight(w) - TB_IndicatorDim(w)) / 2,
			   TB_IndicatorDim(w), TB_IndicatorDim(w),
			   2, fill);
	}
	if (!IN_MENU(w))
	{
	    _XmDrawShadows(XtDisplay(w), XtWindow(w),
			   Prim_TopShadowGC(w),
			   Prim_BottomShadowGC(w),
			   Prim_HighlightThickness(w),
			   Prim_HighlightThickness(w),
			   XtWidth(w) - 2 * Prim_HighlightThickness(w),
			   XtHeight(w) - 2 * Prim_HighlightThickness(w),
			   Lab_Shadow(w),
			   XmSHADOW_OUT);
	}
	else
	{
	    _XmDrawShadows(XtDisplay(w), XtWindow(w),
			   Prim_TopShadowGC(w),
			   Prim_BottomShadowGC(w),
			   0, 0,
			   XtWidth(w), XtHeight(w),
			   Lab_Shadow(w),
			   TB_Armed(w) ? (int)XmSHADOW_OUT : (int)XmNO_LINE);
	}
    }
}

static void
Arm(Widget w, XEvent *event, String *params, Cardinal *num_params)
{
    XmToggleButtonCallbackStruct cbs;
    XtExposeProc exp = XtClass(w)->core_class.expose;

    XmProcessTraversal(w, XmTRAVERSE_CURRENT);

    TB_Armed(w) = True;
    TB_VisualSet(w) = TB_IndicatorSet(w) = !TB_Set(w);

    (exp) (w, event, (Region)NULL);

    if (TB_ArmCallback(w))
    {
	cbs.reason = XmCR_ARM;
	cbs.event = event;
	cbs.set = TB_Set(w);

	XFlush(XtDisplay(w));

	XtCallCallbackList(w,
			   TB_ArmCallback(w),
			   (XtPointer)&cbs);
    }
}

static void
Select(Widget w, XEvent *event, String *params, Cardinal *num_params)
{
    XmToggleButtonCallbackStruct cbs;
    XButtonEvent *ev = (XButtonEvent *)event;

    if (ev->type == KeyPress || ev->type == KeyRelease ||
	((ev->x >= 0 && ev->x < XtWidth(w)) &&
	 (ev->y >= 0 && ev->y < XtHeight(w))))
    {

	if (TB_VisualSet(w) == TB_IndicatorSet(w))
	{
	    cbs.reason = XmCR_VALUE_CHANGED;
	    cbs.event = event;
	    cbs.set = TB_VisualSet(w);

	    /*
	     * Call radio handler *before* setting TB_Set
	     *	so XmToggleButtonGetState still works.
	     */
	    if (XmIsRowColumn(XtParent(w)) && RC_RadioBehavior(XtParent(w)))
		_XmRadioHandler(w, XtParent(w), &cbs, True);

	    TB_Set(w) = TB_VisualSet(w);

	    if (!Lab_SkipCallback(w) && TB_ValueChangedCallback(w))
	    {
		XFlush(XtDisplay(w));

		XtCallCallbackList(w,
				   TB_ValueChangedCallback(w),
				   (XtPointer)&cbs);
	    }
	}
	else
	{
	    TB_IndicatorSet(w) = TB_Set(w);
	}
    }
}


static void
Disarm(Widget w, XEvent *event, String *params, Cardinal *num_params)
{
    XmToggleButtonCallbackStruct cbs;
    XtExposeProc exp = XtClass(w)->core_class.expose;

    TB_Set(w) = TB_IndicatorSet(w) = TB_VisualSet(w);

    if (TB_DisarmCallback(w))
    {
	cbs.reason = XmCR_DISARM;
	cbs.event = event;
	cbs.set = TB_Set(w);

	XFlush(XtDisplay(w));

	XtCallCallbackList(w,
			   TB_DisarmCallback(w),
			   (XtPointer)&cbs);
    }

    TB_Armed(w) = False;
    (exp) (w, event, (Region)NULL);
}

static void
ArmAndActivate(Widget w, XEvent *event, String *params, Cardinal *num_params)
{
    Boolean poppedUp;

    Arm(w, event, params, num_params);

    if (IN_MENU(w))
    {
	RC_MenuButtonPopdown(w, event, &poppedUp);
    }
 
    Select(w, event, params, num_params);
    Disarm(w, event, params, num_params);
}

static void
ButtonUp(Widget w, XEvent *event, String *params, Cardinal *num_params)
{
    Boolean validButton, poppedUp;
    XmToggleButtonCallbackStruct cbs;

    DEBUGOUT(XdbDebug(__FILE__, w, "ToggleB ButtonUp()\n"));

    /* queue events until the next button event */
    XAllowEvents(XtDisplay(w), SyncPointer, CurrentTime);

    if (event && (event->type == ButtonRelease))
    {
	RC_MenuButton(w, event, &validButton);
    }

    if (!validButton)
    {
	return;
    }

    RC_MenuButtonPopdown(w, event, &poppedUp);

    _XmRecordEvent(event);

    TB_Armed(w) = False;

    TB_Set(w) = TB_VisualSet(w) = TB_IndicatorSet(w);

    DEBUGOUT(XdbDebug(__FILE__, w, "ButtonUp: HERE\n"));

    cbs.reason = XmCR_VALUE_CHANGED;
    cbs.event = event;
    cbs.set = TB_Set(w);

    if (XmIsRowColumn(XtParent(w)) && RC_RadioBehavior(XtParent(w)))
	_XmRadioHandler(w, XtParent(w), &cbs, True);

    if (!Lab_SkipCallback(w) && TB_ValueChangedCallback(w))
    {
	XFlush(XtDisplay(w));

	XtCallCallbackList(w,
			   TB_ValueChangedCallback(w),
			   (XtPointer)&cbs);
    }
    if (TB_DisarmCallback(w))
    {
	cbs.reason = XmCR_DISARM;
	cbs.event = event;
	cbs.set = TB_Set(w);

	XFlush(XtDisplay(w));

	XtCallCallbackList(w,
			   TB_DisarmCallback(w),
			   (XtPointer)&cbs);
    }

    _XmSetInDragMode(w, False);
}

static void
ButtonDown(Widget w, XEvent *event, String *params, Cardinal *num_params)
{
    int validButton;
    XtExposeProc exp = XtClass(w)->core_class.expose;

    /* queue events until the next button event. */
    XAllowEvents(XtDisplay(w), SyncPointer, CurrentTime);

    DEBUGOUT(XdbDebug(__FILE__, w, "ToggleB ButtonDown()\n"));

    if (event && (event->type == ButtonPress))
    {
	RC_MenuButton(w, event, &validButton);
	if (!validButton)
	{
	    return;
	}
    }

    _XmSetInDragMode(w, True);

    TB_Armed(w) = True;
    TB_VisualSet(w) = TB_IndicatorSet(w) = !TB_Set(w);

    /*
    TB_IndicatorSet(w) = !TB_Set(w);
    */

    (*exp) (w, event, NULL);

    {
    Boolean poppedUp;

	RC_MenuShellPopdown(w, event, &poppedUp);
    }

    _XmSetInDragMode(w, False);

    _XmRecordEvent(event);
}

static void
Help(Widget w, XEvent *event, String *params, Cardinal *num_params)
{
    XtCallActionProc(w, "PrimitiveHelp", event, params, *num_params);
}

static void
EnterWindow(Widget w, XEvent *event, String *params, Cardinal *num_params)
{
    XmToggleButtonCallbackStruct cbs;
    XtExposeProc exp = XtClass(w)->core_class.expose;

    DEBUGOUT(XdbDebug(__FILE__, w, "ToggleB Enter\n"));

    if (!IN_MENU(w))
    {
	_XmPrimitiveLeave(w, event, NULL, NULL);
	if (TB_Armed(w))
	{
	    TB_VisualSet(w) = TB_IndicatorSet(w);
	    (*exp) (w, NULL, (Region)NULL);
	}
    }
    else
	/* In menu */
    {
	if (_XmGetInDragMode(w))
	{
	    {
	    Boolean poppedUp;

		RC_MenuShellPopdown(w, event, &poppedUp);
	    }

	    TB_Armed(w) = True;

	    TB_IndicatorSet(w) = !TB_Set(w);

	    (*exp) (w, event, NULL);

	    if (TB_ArmCallback(w))
	    {
		cbs.reason = XmCR_ARM;
		cbs.event = event;
		cbs.set = TB_Set(w);

		XFlush(XtDisplay(w));

		XtCallCallbackList(w,
				   TB_ArmCallback(w),
				   (XtPointer)&cbs);
	    }
	}
    }
}

static void
LeaveWindow(Widget w, XEvent *event, String *params, Cardinal *num_params)
{
    XmToggleButtonCallbackStruct cbs;
    XtExposeProc exp = XtClass(w)->core_class.expose;

    if (!IN_MENU(w))
    {
	_XmPrimitiveLeave(w, event, NULL, NULL);
	if (TB_Armed(w))
	{
	    TB_VisualSet(w) = TB_Set(w);
	    (*exp) (w, NULL, (Region)NULL);
	}
    }
    else
	/* we're in a menu */
    {
	if (_XmGetInDragMode(w))
	{
	    TB_IndicatorSet(w) = TB_Set(w);

	    TB_Armed(w) = False;

	    (*exp) (w, event, NULL);

	    if (TB_DisarmCallback(w))
	    {
		cbs.reason = XmCR_DISARM;
		cbs.event = event;
		cbs.set = TB_Set(w);

		XFlush(XtDisplay(w));

		XtCallCallbackList(w,
				   TB_DisarmCallback(w),
				   (XtPointer)&cbs);
	    }
	}
    }
}

#ifdef __STDC__
static void
MenuProcEntry(int proc, Widget w,...)
{
    va_list arg_list;
    XEvent *event = NULL;
    extern void _XmTearOffArm();
 
    va_start(arg_list, w);
#else
MenuProcEntry(proc, w, va_alist)
     int proc;
     Widget w;
     va_dcl
{
    va_list arglist;
    XEvent *event = NULL;
    extern void _XmTearOffArm();
 
    va_start(arglist);
#endif

    switch (proc)
    {
    case XmMENU_ARM:
    	{
	XtExposeProc exp = XtClass(w)->core_class.expose;

	    TB_Armed(w) = True;
	    (exp) (w, event, (Region)NULL);
    	}
    	break;
    case XmMENU_DISARM:
    	{
	XtExposeProc exp = XtClass(w)->core_class.expose;

	    TB_Armed(w) = False;
	    (exp) (w, event, (Region)NULL);
    	}
    	break;
    default:
	_XmWarning(w, "%s(%d) - Invalid menuProc function", __FILE__, __LINE__);
	break;
    }

    va_end(arg_list);
}

Widget
XmCreateToggleButton(Widget parent, char *name,
		     Arg *arglist, Cardinal argcount)
{
    return XtCreateWidget(name, xmToggleButtonWidgetClass, parent,
			  arglist, argcount);
}

Boolean
XmToggleButtonGetState(Widget widget)
{
    if (XmIsToggleButtonGadget(widget))
    {
	return XmToggleButtonGadgetGetState(widget);
    }
    else if (XmIsToggleButton(widget))
    {
	return TB_Set(widget);
    }
    return False;
}

void
XmToggleButtonSetState(Widget w, Boolean state, Boolean notify)
{
    XmToggleButtonCallbackStruct cbs;
    XtExposeProc exp = XtClass(w)->core_class.expose;

    DEBUGOUT(XdbDebug(__FILE__, w, "ToggleB SetState: %d %d\n",
		      state, notify));

    if (XmIsGadget(w))
    {
	XmToggleButtonGadgetSetState(w, state, notify);
	return;
    }
    if (!XmIsToggleButton(w))
    {
	return;
    }

    if ((TB_Set(w) && !state) || (!TB_Set(w) && state))
    {
	cbs.reason = XmCR_VALUE_CHANGED;
	cbs.event = NULL;
	cbs.set = state;

	if (XmIsRowColumn(XtParent(w)) && RC_RadioBehavior(XtParent(w)))
	    _XmRadioHandler(w, XtParent(w), &cbs, notify);

	TB_VisualSet(w) = TB_Set(w) = state ? True : False;

	if (notify && TB_ValueChangedCallback(w))
	{
	    XFlush(XtDisplay(w));

	    XtCallCallbackList(w,
			       TB_ValueChangedCallback(w),
			       (XtPointer)&cbs);
	}

	if (XtIsRealized(w))
	{
	    (*exp) (w, NULL, (Region)NULL);
	}
    }
}

#if 0
/*
 * A simpler version, only to be used by _XmRadioCallback.
 * This one is only concerned with the widget itself no callbacks.
 */
void
_XmToggleButtonSetState(Widget w, Boolean state)
{
    XtExposeProc exp = XtClass(w)->core_class.expose;

    DEBUGOUT(XdbDebug(__FILE__, w, "_XmToggleButtonSetState(%s)\n",
		XdbBoolean2String(state)));

    if ((TB_Set(w) && !state) || (!TB_Set(w) && state))
    {
	TB_VisualSet(w) = TB_Set(w) = state ? True : False;

	if (XtIsRealized(w))
	{
	    (*exp) (w, NULL, (Region)NULL);
	}
    }
}
#else
/*
 * Redefine this sucker
 * It should do callbacks, but it shouldn't think about it.
 * That is: only _XmRadioCallback knows what's going on.
 * Trust it and just do as it says.
 * The notify parameter has a different meaning than.
 */
void
_XmToggleButtonSetState(Widget w, Boolean state, Boolean notify)
{
    XmToggleButtonCallbackStruct	cbs;
    XtExposeProc			exp = XtClass(w)->core_class.expose;

    DEBUGOUT(XdbDebug(__FILE__, w, "_XmToggleButtonSetState(%s)\n",
		XdbBoolean2String(state)));

    TB_VisualSet(w) = TB_Set(w) = state;

    if (notify) {
	if (XtIsRealized(w))
	    (*exp) (w, NULL, (Region)NULL);

	cbs.reason = XmCR_VALUE_CHANGED;
	cbs.event = NULL;
	cbs.set = state;

	XtCallCallbackList(w,
		TB_ValueChangedCallback(w),
		(XtPointer)&cbs);
    }
}
#endif
