/**
 *
 * $Id: HostTranscript.c,v 1.4 1998/07/06 16:11:20 rwscott Exp $
 *
 * Copyright (C) 1996 Free Software Foundation, Inc.
 *
 * This file is part of the GNU LessTif Extension Library.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 **/

#include <Xm/Text.h>
#include <Host.h>

static void
Modify(Widget Transcript, Widget Host, XmTextVerifyCallbackStruct *call_data)
{
String tmp, tmp1;
int left;

	tmp = call_data->text->ptr;
	left = call_data->text->length;
	while ((tmp1 = memchr(tmp, '\n', left)) != NULL)
	{
	    if (tmp != tmp1)
	    {
		    XltHostSendData(Host, tmp, tmp1 - tmp + 1);
	    }
	    XltHostSendString(Host, "\r");
	    left -= (tmp1 - tmp + 1);
	    tmp = tmp1;
	    tmp++;
	}
	XltHostSendData(Host, tmp, left);
	call_data->newInsert = XmTextGetLastPosition(Transcript) + call_data->text->length;
	call_data->startPos = XmTextGetLastPosition(Transcript);
	call_data->endPos = XmTextGetLastPosition(Transcript);
}

static void
AsciiInput(Widget Host, Widget Transcript, XltHostCallbackStruct *call_data)
{
	XtRemoveCallback(Transcript, XmNmodifyVerifyCallback, (void *)Modify, Host);
	XmTextInsert(Transcript,
		XmTextGetLastPosition(Transcript),
		call_data->data);
	XmTextInsert(Transcript,
		XmTextGetLastPosition(Transcript),
		"\n");
	XmTextSetInsertionPosition(Transcript, 
		XmTextGetLastPosition(Transcript));
	XtAddCallback(Transcript, XmNmodifyVerifyCallback, (void *)Modify, Host);
}

Widget
XltHostCreateTranscript(Widget parent, Widget Host, Arg *args_in, Cardinal n_in)
{
Widget Transcript;

	Transcript = XmCreateScrolledText(parent, "HostTranscript", args_in, n_in);
	XtAddCallback(Transcript, XmNmodifyVerifyCallback, (void *)Modify, Host);
	XtAddCallback(Host, XltNasciiInputCallback, (void *)AsciiInput, Transcript);
	return(Transcript);
}
