/*
 * GWT - General Windowing Toolkit
 *
 * Copyright (C) 1998 MenTaLguY - mentalg@geocities.com
 *                    Rodolphe Ortalo - ortalo@laas.fr
 *                    Tristan Wibberley - twibberley@llamacom.com
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Log: gwt_types.h,v $
 * Revision 1.4  1998/09/02 02:21:56  tristan
 * Loadsa great stuff done. Visible/invalid regions,
 *  copy on move - fixed tt_region.c too!
 *
 * Revision 1.3  1998/08/23 18:57:17  ortalo
 * Minor editing (mainly comments).
 *
 * Revision 1.2  1998/08/11 22:09:11  ortalo
 * Incorporated the work made by Tristan Wibberley. Still in alpha
 * development state.
 *
 * Revision 1.1  1998/07/09 18:38:39  ortalo
 * Initial integration of libgwt in the GGI repository.
 * This is experimental code, for your eyes only !
 * (Don't execute... ;-)
 *
 */

#ifndef __GGI_GWT_TYPES_H
#define __GGI_GWT_TYPES_H

#include <ggi/ggi.h>
#include <ggi/events.h>

typedef int gwt_id_t;
#define GWT_NULL_ID 0;

struct _gwt_window;
typedef struct _gwt_window gwt_window;
typedef gwt_window *gwt_window_t;

struct _gwt_event_record;
typedef struct _gwt_event_record gwt_event_record;

struct _gwt_event_record {
	gwt_window_t recipient;
	ggi_event event;
	gwt_event_record *prev, *next;
};

typedef struct _gwt_evqueue {
	int refcount;
	gwt_event_record *head, *tail;
	ggi_event_mask seen;
	int fds[2];
	int count;
#ifdef USE_THREADS
	pthread_mutex_t mutex;
#endif
} gwt_evqueue;
typedef gwt_evqueue *gwt_evqueue_t;

#include "region.h"

struct _gwt_zorder {
	gwt_window_t zbottom, ztop;
};
typedef struct _gwt_zorder gwt_zorder;

struct _gwt_window {
        /* Root visual being used to display */
	ggi_visual_t visual;
	
	ggi_event_mask accepts;
	gwt_evqueue_t _ev_queue;	
	
	int hidden;
	int _implicit_hide;
	
	gwt_window_t wparent;
	int level;
	
	ggi_coord origin;
	gwt_region_t geometry;
	gwt_region_t invalid;
	gwt_region_t visible;		/* not covered by child or
					 * other windows */
	gwt_region_t _family_visible;	/* What would be visible if
					 * there were no children or parent
					 * covering part of it */
	gwt_region_t _external_visible;	/* Now with ancestors covering */

	/* Sub-windows Z-Order */
	gwt_zorder zorder;
	/* A window needs pointers to be part of a Z-Order */
	gwt_window_t zprev, znext;

	/* Private data */
	void *priv;

        /* Unique ID */
	gwt_id_t id;
};

typedef struct _gwtprivate { char priv[123];} gwtprivate;

#endif /* __GGI_GWT_TYPES_H */
