/* 
 *  Circle template
 *
 *  Copyright (C) 1998 by Thomas Tanner. See CREDITS for details.
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public
 *  License along with this library; if not, write to the Free
 *  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

/*----------------------------------------------------------------------
    macros that must be defined:
    
#define PLOT(x, y)
    plots a pixel at (x,y)

#define SCANLINE(x1, x2, y)
    fills a horizontal scanline from (x1,y) to (x2,y) 

#define FILL
    filled circle

#define STIPPLE
    use stippling 

----------------------------------------------------------------------*/

/* 
void	drawCircle(ggi_visual_t vis, int x, int y, uint r)
void	fillCircle(ggi_visual_t vis, int x, int y, uint r)
*/
{
	int	cx, cy, d;

	cx = 0; cy = r; d = r-1;
	do {
		if (d < 0) { cy--; d += 2*cy; }
#ifndef	FILL
#	ifndef	STIPPLE
		PLOT(x - cx, y - cy);
		PLOT(x + cx, y - cy);
		PLOT(x - cy, y - cx);
		PLOT(x + cy, y - cx);
		PLOT(x - cy, y + cx);
		PLOT(x + cy, y + cx);
		PLOT(x - cx, y + cy);
		PLOT(x + cx, y + cy);
#	else
#	endif
#else
		SCANLINE(x - cx, x + cx, y - cy);
		SCANLINE(x - cy, x + cy, y - cx);
		SCANLINE(x - cx, x + cx, y + cy);
		SCANLINE(x - cy, x + cy, y + cx);
#endif
		d -= 2*cx + 1; cx++;
	} while (cy >= cx);
}

#undef PLOT
#undef SCANLINE
#undef FILL
#undef STIPPLE
