/* $Id: ggi2d.h,v 1.5 1998/10/07 20:13:14 tanner Exp $ */
/* 
 *  GGI/2D interface
 *
 *  Copyright (C) 1998 by Thomas Tanner. See CREDITS for details.
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public
 *  License along with this library; if not, write to the Free
 *  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#ifndef __ggi2d_h
#define __ggi2d_h

#include <ggi/ggi.h>

#ifdef __cplusplus
extern "C" {
#endif

typedef	uint16		ggi_alpha;
#define	GGI_MAX_ALPHA	255

/***********************************************************/
/* library initialization and exit */

int	ggi2dInit(void);
int	ggi2dExit(void);

/***********************************************************/
/* visual */

int	ggi2dOpen(ggi_visual_t vis);
int	ggi2dClose(ggi_visual_t vis);

/***********************************************************/
/* images */

#ifndef _BUILDING_LIBGGI2D_
typedef void	*ggi2d_image;
#endif	

int	ggi2dCreateImage(ggi2d_image *image, ggi_visual_t vis,
			ggi_visual_t source, 
			ggi_uint x, ggi_uint y, 
			ggi_uint width, ggi_uint height);
int	ggi2dDestroyImage(ggi2d_image image);
int    	ggi2dCompatibleImage(ggi_visual_t vis, ggi2d_image image);

/***********************************************************/
/* graphics context */

typedef enum { 
	GGI2D_ARC_SECTOR,
	GGI2D_ARC_SEGMENT
} ggi2d_arcmode;

typedef enum { 
	GGI2D_POLY_EVENODD, 
	GGI2D_POLY_WINDING 
} ggi2d_polymode;

typedef enum {
	GGI2D_NOOP,			/* dest = dest */
	GGI2D_INVERT,			/* dest = ~dest */
	GGI2D_SET,			/* dest = color */
	GGI2D_SET_INVERTED,		/* dest = ~color */
	GGI2D_AND,			/* dest = (dest & color) */
	GGI2D_NAND,			/* dest = ~(dest & color) */
	GGI2D_AND_REVERSE,		/* dest = ~dest & color */
	GGI2D_AND_INVERTED,		/* dest = dest & ~color */
	GGI2D_OR,			/* dest = (dest | color) */
	GGI2D_NOR,			/* dest = ~(dest | color) */
	GGI2D_OR_REVERSE,		/* dest = ~dest & color */
	GGI2D_OR_INVERTED,		/* dest = dest & ~color */
	GGI2D_XOR,			/* dest = (dest ^ color) */
	GGI2D_EQUIV,			/* dest = ~(dest ^ color */
	GGI2D_ADD,			/* dest = dest + color */
	GGI2D_SUB			/* dest = dest - color */
} ggi2d_operator;

typedef	struct {
	ggi_sint	x, y;
} ggi2d_coord;

int 	ggi2dSetClip(ggi_visual_t vis, ggi_sint x1, ggi_sint y1, ggi_sint x2, ggi_sint y2);
int    	ggi2dPointVisible(ggi_visual_t vis, ggi_sint x, ggi_sint y);
int    	ggi2dRectVisible(ggi_visual_t vis, ggi_sint x1, ggi_sint y1, ggi_sint x2, ggi_sint y2);
int	ggi2dSetArcMode(ggi_visual_t vis, ggi2d_arcmode mode);
ggi2d_arcmode	ggi2dGetArcMode(ggi_visual_t vis);
int	ggi2dSetPolyMode(ggi_visual_t vis, ggi2d_polymode mode);
ggi2d_polymode	ggi2dGetPolyMode(ggi_visual_t vis);
int	ggi2dSetLineDash(ggi_visual_t vis, ggi_uint dash[], ggi_uint size);
int	ggi2dGetLineDash(ggi_visual_t vis, ggi_uint dash[], ggi_uint *size);
int	ggi2dSetAppendMode(ggi_visual_t vis, int append);
int    	ggi2dGetAppendMode(ggi_visual_t vis);
int	ggi2dSetDrawColor(ggi_visual_t vis, ggi_pixel color);
ggi_pixel	ggi2dGetDrawColor(ggi_visual_t vis);
int	ggi2dSetFillColor(ggi_visual_t vis, ggi_pixel color);
ggi_pixel	ggi2dGetFillColor(ggi_visual_t vis);
int	ggi2dSetFillTexture(ggi_visual_t vis, ggi2d_coord refpoint, ggi2d_image texture);
int	ggi2dGetFillTexture(ggi_visual_t vis, ggi2d_coord *refpoint, ggi2d_image *texture);
int	ggi2dSetOperator(ggi_visual_t vis, ggi2d_operator operator);
ggi2d_operator	ggi2dGetOperator(ggi_visual_t vis);

/***********************************************************/
/* drawing */

typedef	struct {
	ggi_sint	x1, x2, y;
} ggi2d_scanline;

typedef struct {
	ggi_sint x1, y1, x2, y2; 
} ggi2d_line;

/* primitives */
int	ggi2dPutPixel(ggi_visual_t vis, ggi_sint x, ggi_sint y, ggi_pixel color);
int	ggi2dDrawPixel(ggi_visual_t vis, ggi_sint x, ggi_sint y);
int	ggi2dFillPixel(ggi_visual_t vis, ggi_sint x, ggi_sint y);
int	ggi2dDrawPixels(ggi_visual_t vis, ggi2d_coord coords[], ggi_uint count);

int	ggi2dScanLine(ggi_visual_t vis, ggi_sint x1, ggi_sint x2, ggi_sint y);
int	ggi2dScanLines(ggi_visual_t vis, ggi2d_scanline scanlines[], ggi_uint count);

int	ggi2dHLine(ggi_visual_t vis, ggi_sint x1, ggi_sint x2, ggi_sint y);
int	ggi2dVLine(ggi_visual_t vis, ggi_sint x, ggi_sint y1, ggi_sint y2);
int	ggi2dDrawRect(ggi_visual_t vis, ggi_sint x1, ggi_sint y1, ggi_sint x2, ggi_sint y2);
int	ggi2dFillRect(ggi_visual_t vis, ggi_sint x1, ggi_sint y1, ggi_sint x2, ggi_sint y2);

/* curves */

int	ggi2dLine(ggi_visual_t vis, ggi_sint x1, ggi_sint y1, ggi_sint x2, ggi_sint y2);
int	ggi2dDrawLines(ggi_visual_t vis, ggi2d_line lines[], ggi_uint count);
int	ggi2dDrawCircle(ggi_visual_t vis, ggi_sint x, ggi_sint y, ggi_uint r);
int	ggi2dFillCircle(ggi_visual_t vis, ggi_sint x, ggi_sint y, ggi_uint r);
int	ggi2dDrawEllipse(ggi_visual_t vis, ggi_sint x, ggi_sint y, ggi_uint rx, ggi_uint ry);
int	ggi2dFillEllipse(ggi_visual_t vis, ggi_sint x, ggi_sint y, ggi_uint rx, ggi_uint ry);
int	ggi2dDrawArc(ggi_visual_t vis, ggi_sint x, ggi_sint y, ggi_uint rx, ggi_uint ry, 
			ggi_float start, ggi_float end, int close);
int	ggi2dFillArc(ggi_visual_t vis, ggi_sint x, ggi_sint y, ggi_uint rx, ggi_uint ry, 
			ggi_float start, ggi_float end);
int	ggi2dBezier(ggi_visual_t vis, 
			ggi_sint x1, ggi_sint y1, ggi_sint x2, ggi_sint y2, 
			ggi_sint x3, ggi_sint y3, ggi_sint x4, ggi_sint y4);
int	ggi2dTrapezoid(ggi_visual_t vis, ggi_sint xl1, ggi_sint xr1, 
			ggi_sint y1, ggi_sint xl2, ggi_sint xr2, ggi_sint y2);
int	ggi2dTriangle(ggi_visual_t vis, ggi_sint x1, ggi_sint y1, 
			ggi_sint x2, ggi_sint y2, ggi_sint x3, ggi_sint y3);
int	ggi2dDrawPoly(ggi_visual_t vis, ggi2d_coord coords[], ggi_uint count);
int	ggi2dFillPoly(ggi_visual_t vis, ggi2d_coord coords[], ggi_uint count);
int	ggi2dFillPolys(ggi_visual_t vis, ggi2d_coord coords[], 
			ggi_uint counts[], ggi_uint count);

/* blitting */

int	ggi2dBlit(ggi_visual_t vis, ggi_sint dx, ggi_sint dy, 
			ggi2d_image src, ggi_sint sx, ggi_sint sy, 
			ggi_sint width, ggi_sint height);
int	ggi2dStretchBlit(ggi_visual_t vis, ggi_sint dx, ggi_sint dy, 
			ggi_sint dwidth, ggi_sint dheight, 
			ggi2d_image src, ggi_sint sx, ggi_sint sy, 
			ggi_sint swidth, ggi_sint sheight);
int	ggi2dBlitOp(ggi_visual_t vis, ggi_sint dx, ggi_sint dy, 
			ggi2d_image src1, ggi_sint s1x, ggi_sint s1y,
			ggi2d_image src2, ggi_sint s2x, ggi_sint s2y, 
			ggi_sint width, ggi_sint height, ggi2d_operator op);
int	ggi2dStretchBlitOp(ggi_visual_t vis, ggi_sint dx, ggi_sint dy, 
			ggi_sint dwidth, ggi_sint dheight, 
			ggi2d_image src1, ggi_sint s1x, ggi_sint s1y,
			ggi2d_image src2, ggi_sint s2x, ggi_sint s2y, 
			ggi_sint swidth, ggi_sint sheight, ggi2d_operator op);

/***********************************************************/

#ifdef __cplusplus
}
#endif

#endif /* __ggi2d_h */

