/* $Id: events.c,v 1.12 1998/10/05 22:58:59 becka Exp $
***************************************************************************

   Graphics library for GGI. Events handling.

   Copyright (C) 1997 Jason McMullan	[jmcc@ggi-project.org]
   Copyright (C) 1998 Hartmut Niemann

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
  
   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.
  
   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

***************************************************************************
*/

#include <ggi/internal/internal.h>

ggi_event_mask ggiEventPoll(ggi_visual *vis,ggi_event_mask mask,
			    struct timeval *t)
{
	/* FIXME - when all targets are converted - remove the branch */
	if (vis->input) return giiEventPoll(vis->input,mask,t);
	return vis->opdisplay->eventpoll(vis,mask,t);
}

int ggiEventRead(ggi_visual *vis,ggi_event *ev,ggi_event_mask mask)
{
	if (vis->input) return giiEventRead(vis->input,ev,mask);
	return vis->opdisplay->eventread(vis,ev,mask);
}

int ggiSetEventMask(ggi_visual *vis, ggi_event_mask evm)
{
	if (vis->input) return giiSetEventMask(vis->input,evm);
	return vis->opdisplay->seteventmask(vis, evm);
}

ggi_event_mask ggiGetEventMask(ggi_visual *vis)
{
	if (vis->input) return giiGetEventMask(vis->input);
	return vis->evmask;
}

int     ggiGetSelectFdset(ggi_visual *vis, fd_set *readfds,int *haspolled)
{
	/* We have a GII-Style target. Nice. */
	if (vis->input) return giiGetSelectFdset(vis->input,readfds,haspolled);

	/* We haven't one. */
	FD_ZERO(readfds);	/* Clear the table*/
	if (haspolled) *haspolled=1;	/* Assume polled operation */
	if (vis->select_fd) { 	/* Have a select_fd */

		FD_SET(vis->select_fd,readfds); /* Set it */
		return vis->select_fd+1;	/* Highest FD+1 ... */
	}

	return 0;	/* No select_fd. Polled only. */
}

/* This can also be used to query the vis->input member.
 */
gii_input_t ggiJoinInputs(ggi_visual *vis, gii_input_t inp)
{
	return vis->input=giiJoinInputs(vis->input,inp);
}

int ggiKbhit(ggi_visual_t vis)
{
	struct timeval t={0,0};

	return (ggiEventPoll(vis, emKeyPress|emKeyRepeat, &t) != emZero);
}

int ggiGetc(ggi_visual_t vis)
{
	ggi_event ev;

	/* Block until we get a key. */
	ggiEventRead(vis, &ev, emKeyPress|emKeyRepeat);

	return ev.key.sym;
}
