/* $Id: stubs.c,v 1.15 1998/10/10 13:21:35 ajapted Exp $
***************************************************************************

   Display-trueemu : stubs

   Copyright (C) 1998 Andrew Apted    [andrew@ggi-project.org]

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

***************************************************************************
*/

#include <string.h>
#include <ggi/internal/ggi-dl.h>

#include "trueemu.h"


/* The following operations update the 'dirty region', which is used to
 * limit the area blit to the parent at ggiFlush() time.
 */

int GGI_trueemu_putpixel_nc(ggi_visual *vis, int x, int y, ggi_pixel col)
{ 
	TrueemuHook *th = TRUEEMU_PRIV(vis);
	
	UPDATE_MOD(vis, x, y, 1, 1);
	
	return th->mem_opdraw->putpixel_nc(vis, x, y, col);
}

int GGI_trueemu_putpixel(ggi_visual *vis, int x, int y, ggi_pixel col)
{ 
	TrueemuHook *th = TRUEEMU_PRIV(vis);
	
	UPDATE_MOD(vis, x, y, 1, 1);
	
	return th->mem_opdraw->putpixel(vis, x, y, col);
}

int GGI_trueemu_drawpixel_nc(ggi_visual *vis, int x, int y)
{
	TrueemuHook *th = TRUEEMU_PRIV(vis);
	
	UPDATE_MOD(vis, x, y, 1, 1);
	
	return th->mem_opdraw->drawpixel_nc(vis, x, y);
}

int GGI_trueemu_drawpixel(ggi_visual *vis, int x, int y)
{
	TrueemuHook *th = TRUEEMU_PRIV(vis);
	
	UPDATE_MOD(vis, x, y, 1, 1);
	
	return th->mem_opdraw->drawpixel(vis, x, y);
}

int GGI_trueemu_drawline(ggi_visual *vis, int x1, int y1, int x2, int y2)
{ 
	TrueemuHook *th = TRUEEMU_PRIV(vis);

	int sx=MIN(x1,x2);
	int sy=MIN(y1,y2);

	int ex=MAX(x1,x2);
	int ey=MAX(y1,y2);

	UPDATE_MOD(vis, sx, sy, ex-sx, ey-sy);

	return th->mem_opdraw->drawline(vis, x1, y1, x2, y2);
}

int GGI_trueemu_drawvline_nc(ggi_visual *vis, int x, int y, int h)
{
	TrueemuHook *th = TRUEEMU_PRIV(vis);
	
	UPDATE_MOD(vis, x, y, 1, h);
	
	return th->mem_opdraw->drawvline_nc(vis, x, y, h);
}

int GGI_trueemu_drawvline(ggi_visual *vis, int x, int y, int h)
{
	TrueemuHook *th = TRUEEMU_PRIV(vis);
	
	UPDATE_MOD(vis, x, y, 1, h);
	
	return th->mem_opdraw->drawvline(vis, x, y, h);
}

int GGI_trueemu_putvline(ggi_visual *vis, int x, int y, int h, void *buffer)
{
	TrueemuHook *th = TRUEEMU_PRIV(vis);
	
	UPDATE_MOD(vis, x, y, 1, h);
	
	return th->mem_opdraw->putvline(vis, x, y, h, buffer);
}

#undef putc

int GGI_trueemu_putc(ggi_visual *vis, int x, int y, char c)
{
	TrueemuHook *th = TRUEEMU_PRIV(vis);

	int char_w;
	int char_h;
	
	ggiGetCharSize(vis, &char_w, &char_h);

	UPDATE_MOD(vis, x, y, char_w, char_h);
	
	return th->mem_opdraw->putc(vis, x, y, c);
}


/* ---------------------------------------------------------------------- */


int GGI_trueemu_drawhline_nc(ggi_visual *vis, int x, int y, int w)
{
	TrueemuHook *th = TRUEEMU_PRIV(vis);
	
	UPDATE_MOD(vis, x, y, w, 1);

	return th->mem_opdraw->drawhline_nc(vis, x, y, w);
}

int GGI_trueemu_drawhline(ggi_visual *vis, int x, int y, int w)
{
	TrueemuHook *th = TRUEEMU_PRIV(vis);
	
	UPDATE_MOD(vis, x, y, w, 1);

	return th->mem_opdraw->drawhline(vis, x, y, w);
}

int GGI_trueemu_puthline(ggi_visual *vis, int x, int y, int w, void *buffer)
{ 
	TrueemuHook *th = TRUEEMU_PRIV(vis);
	
	UPDATE_MOD(vis, x, y, w, 1);

	return th->mem_opdraw->puthline(vis, x, y, w, buffer);
}

int GGI_trueemu_putbox(ggi_visual *vis, int x, int y, int w, int h, void *buffer)
{ 
	TrueemuHook *th = TRUEEMU_PRIV(vis);
	
	UPDATE_MOD(vis, x, y, w, h);

	return th->mem_opdraw->putbox(vis, x, y, w, h, buffer);
}

int GGI_trueemu_drawbox(ggi_visual *vis, int x, int y, int w, int h)
{
	TrueemuHook *th = TRUEEMU_PRIV(vis);
	
	UPDATE_MOD(vis, x, y, w, h);

	return th->mem_opdraw->drawbox(vis, x, y, w, h);
}

int GGI_trueemu_fillscreen(ggi_visual *vis)
{
	TrueemuHook *th = TRUEEMU_PRIV(vis);
	
	UPDATE_MOD(vis, 0, 0, LIBGGI_VIRTX(vis), LIBGGI_VIRTY(vis));

	return th->mem_opdraw->fillscreen(vis);
}


/* ---------------------------------------------------------------------- */


int GGI_trueemu_copybox(ggi_visual *vis, int x, int y, int w, int h, 
			int nx, int ny)
{
	TrueemuHook *th = TRUEEMU_PRIV(vis);
	
	UPDATE_MOD(vis, nx, ny, w, h);

	return th->mem_opdraw->copybox(vis, x, y, w, h, nx, ny);
}

int GGI_trueemu_crossblit(ggi_visual *src, int sx, int sy, int w, int h,
                	  ggi_visual *vis, int dx, int dy)
{
	TrueemuHook *th = TRUEEMU_PRIV(vis);
	
	UPDATE_MOD(vis, dx, dy, w, h);
	
	return th->mem_opdraw->crossblit(src, sx, sy, w, h, vis, dx, dy);
}


/* ---------------------------------------------------------------------- */


#if 0
/* The following routine is treated specially.  We assume that copybox
 * on the parent will be faster than performing the conversion blit
 * (especially when the parent uses acceleration).
 */

int GGI_trueemu_copybox(ggi_visual *vis, int x, int y, int w, int h, int nx, int ny)
{
	TrueemuHook *th = TRUEEMU_PRIV(vis);
	int err;
	
	if ((err = ggiCopyBox(th->parent, x, y, w, h, nx, ny)) < 0) {
		return err;
	}

	if (! (LIBGGI_FLAGS(vis) & GGIFLAG_ASYNC)) {
		ggiFlush(th->parent);
	}

	return th->mem_opdraw->copybox(vis, x, y, w, h, nx, ny);
}
#endif


/* ---------------------------------------------------------------------- */


/* The following functions are just pass-throughs to the parent visual.
 */

int GGI_trueemu_setorigin(ggi_visual *vis, int x, int y)
{
	TrueemuHook *th = TRUEEMU_PRIV(vis);

	int err;

	if ((err = ggiSetOrigin(th->parent, x, y)) < 0) {
		return err;
	}

	vis->origin_x = x;
	vis->origin_y = y;
	
	return 0;
}

#if 0
int GGI_trueemu_getcharsize(ggi_visual *vis, int *width, int *height)
{
	TrueemuHook *th = TRUEEMU_PRIV(vis);

	return ggiGetCharSize(th->parent, width, height);
}
#endif
