/* $Id: visual.c,v 1.20 1998/10/24 04:03:47 marcus Exp $
***************************************************************************

   Display-multi: initialization

   Copyright (C) 1995 Andreas Beck    [becka@ggi-project.org]
   Copyright (C) 1997 Jason McMullan  [jmcc@ggi-project.org]
   Copyright (C) 1998 Andrew Apted    [andrew@ggi-project.org]

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

***************************************************************************
*/

#include <stdlib.h>
#include <string.h>
#include <ctype.h>

#include <ggi/internal/ggi-dl.h>

#include "multi_defs.h"

/*
 * We are guaranteed to have been checked already...
 */

int GGIdlinit(ggi_visual *vis,const char *args,void *argptr)
{
	MultiHook *mm;
	char target[1024];

	LIBGGI_FD(vis)=-1;

	if (! args) {
		fprintf(stderr, "display-multi: missing target names.\n");
		return GGI_DL_ERROR;
	}

	LIBGGI_PRIVATE(vis) = mm = _ggi_malloc(sizeof(MultiHook));

	mm->vis_num  = 0;
	mm->vis_list = NULL;

	for (;;) {
		MultiVis *cur;

		args = ggParseTarget((char *) args, target, 1024);

		if (args == NULL) {
			/* error occurred */
			free(mm);
			return GGI_DL_ERROR;
		}

		cur = _ggi_malloc(sizeof(MultiVis));

		DPRINT("display-multi: opening sub #%d: %s\n",
			mm->vis_num+1, target);

		cur->vis = ggiOpen(target, NULL);

		if (cur->vis == NULL) {
			fprintf(stderr, "display-multi: failed trying "
				"to open: %s\n", target);
			free(cur); free(mm);
			return GGI_DL_ERROR;
		}

		/* add to head */

		cur->next = mm->vis_list;
		mm->vis_list = cur;
		mm->vis_num++;

		/* Add giiInputs, if we have them. */
		if (cur->vis->input)
		{
			vis->input=giiJoinInputs(vis->input,cur->vis->input);
			cur->vis->input=NULL;	/* Destroy old reference */
		}

		while (*args && isspace((int)*args)) args++;

		if (*args == 0) {
			break;
		}

		if (*args != ':') {
			fprintf(stderr, "display-multi: expecting ':' "
				"between targets.\n");
			free(mm);
			return GGI_DL_ERROR;
		}

		args++;  /* skip ':' */
	}

	LIBGGI_GC(vis) = _ggi_malloc(sizeof(ggi_gc));

	/* Has mode management */
	vis->opdisplay->getmode=GGI_multi_getmode;
	vis->opdisplay->setmode=GGI_multi_setmode;
	vis->opdisplay->checkmode=GGI_multi_checkmode;
	vis->opdisplay->flush=GGI_multi_flush;
	vis->opdisplay->setflags=GGI_multi_setflags;

	/* Has event management */
	vis->opdisplay->eventpoll=GGI_multi_eventpoll;
	vis->opdisplay->eventread=GGI_multi_eventread;

	vis->opgc->gcchanged=GGI_multi_gcchanged;

	vis->opdraw->fillscreen=GGI_multi_fillscreen;
	vis->opdraw->setorigin=GGI_multi_setorigin;

	vis->opdraw->putc=GGI_multi_putc;
	vis->opdraw->puts=GGI_multi_puts;
	vis->opdraw->getcharsize=GGI_multi_getcharsize;

	vis->opdraw->drawpixel_nc=GGI_multi_drawpixel;
	vis->opdraw->drawpixel=GGI_multi_drawpixel;
	vis->opdraw->putpixel_nc=GGI_multi_putpixel;
	vis->opdraw->putpixel=GGI_multi_putpixel;
	vis->opdraw->getpixel=GGI_multi_getpixel;

	vis->opdraw->drawline=GGI_multi_drawline;
	vis->opdraw->drawhline=GGI_multi_drawhline;
	vis->opdraw->puthline=GGI_multi_puthline;
	vis->opdraw->gethline=GGI_multi_gethline;

	vis->opdraw->drawvline=GGI_multi_drawvline;
	vis->opdraw->putvline=GGI_multi_putvline;
	vis->opdraw->getvline=GGI_multi_getvline;

	vis->opdraw->drawbox=GGI_multi_drawbox;
	vis->opdraw->putbox=GGI_multi_putbox;
	vis->opdraw->getbox=GGI_multi_getbox;
	vis->opdraw->copybox=GGI_multi_copybox;

	vis->opcolor->getgamma=GGI_multi_getgamma;
	vis->opcolor->setgamma=GGI_multi_setgamma;
	vis->opcolor->getgammamap=GGI_multi_getgammamap;
	vis->opcolor->setgammamap=GGI_multi_setgammamap;

	vis->opcolor->mapcolor=GGI_multi_mapcolor;
	vis->opcolor->unmappixel=GGI_multi_unmappixel;
	vis->opcolor->setpalvec=GGI_multi_setpalvec;
	vis->opcolor->getpalvec=GGI_multi_getpalvec;

	return GGI_DL_OPDISPLAY | GGI_DL_OPCOLOR |
	       GGI_DL_OPDRAW | GGI_DL_OPGC;
}

int GGIdlcleanup(ggi_visual *vis)
{
	MultiHook *mm = LIBGGI_PRIVATE(vis);
	MultiVis *cur;

	while (mm->vis_list != NULL) {

		/* remove head */

		cur = mm->vis_list;
		mm->vis_list = cur->next;
		mm->vis_num--;

		ggiClose(cur->vis);
		free(cur);
	}

	free(mm);
	free(LIBGGI_GC(vis));

	return 0;
}

#include <ggi/internal/ggidlinit.h>
