/* $Id: events.c,v 1.14 1998/10/26 04:11:06 ajapted Exp $
***************************************************************************

   Display-monotext: event management

   Copyright (C) 1998 Andrew Apted    [andrew@ggi-project.org]

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

***************************************************************************
*/

#include <string.h>
#include <stdlib.h>

#include "monotext.h"


static void cycle_accuracy(ggi_visual *vis)
{
	/* ... */

	/* monotextNewMode(vis); */
}


static int handle_special_events(ggi_visual *vis, ggi_event *ev)
{
	/* returns: 1 if swallows event, 0 otherwise */

	if (ev->any.type == evExpose) {

		_ggi_monotextUpdate(vis, 0, 0, 
				LIBGGI_MODE(vis)->virt.x,
				LIBGGI_MODE(vis)->virt.y);
		return 1;
	}

	/* handle hot-keys */
	
	if ((ev->any.type == evKeyPress) &&
	    ((ev->key.effect & GII_KM_CTRL) != 0) &&
	    ((ev->key.effect & GII_KM_ALT)  != 0)) {

		switch (ev->key.label) {
			case 'a':
				cycle_accuracy(vis);
				return 1;
		}
	}

	return 0;
}


/* ---------------------------------------------------------------------- */


#include "../common/evqueue.inc"

ggi_event_mask GGI_monotext_eventpoll(ggi_visual_t vis, ggi_event_mask mask,
			    struct timeval *t)
{
	MonotextHook *mt = LIBGGI_PRIVATE(vis);

	ggi_event_mask evmask;


	DPRINT("display-monotext: eventpoll mask=0x%08x ", mask);

	if (t == NULL) {
		DPRINT("timeout=NULL\n");
	} else {
		DPRINT("timeout=(%d,%d)\n", t->tv_sec, t->tv_usec);
	}


	for (evmask = _ggiEvQueueSeen(vis, mask);
	     evmask == 0;
	     evmask = _ggiEvQueueSeen(vis, mask)) {

		ggi_event ev;

		ggi_event_mask par_mask;


		/* !!!! FIXME: doesn't decrement timeout */

		par_mask = ggiEventPoll(mt->parent, emAll, t);

		if (par_mask == 0) {
			/* parent must have timed out */
			return 0;
		}

		ggiEventRead(mt->parent, &ev, emAll);

		if (handle_special_events(vis, &ev)) {
			continue;
		}

		_ggiEvQueueAdd(vis, &ev);
	}

	return evmask;
}

int GGI_monotext_eventread(ggi_visual_t vis, ggi_event *ev, ggi_event_mask mask)
{
	/* Block if we don't have anything queued... */
	
	GGI_monotext_eventpoll(vis, mask, NULL);

	return _ggiEvQueueRelease(vis, ev, mask);
}
