/* $Id: color.c,v 1.14 1998/09/24 01:24:18 marcus Exp $
***************************************************************************

   Display-FBDEV

   Copyright (C) 1998 Andrew Apted    [andrew@ggi-project.org]

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

***************************************************************************
*/

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <dlfcn.h>
#include <fcntl.h>
#include <errno.h>
#include <sys/ioctl.h>
#include <sys/mman.h>
#include <linux/fb.h>

#include <ggi/internal/ggi-dl.h>

#include "fbdev.h"


void _GGI_fbdev_save_palette(ggi_visual *vis)
{
	fbdev_hook *ff = LIBGGI_PRIVATE(vis);

	struct fb_cmap cmap;

	if ((ff->orig_var.bits_per_pixel < 1) || 
	    (ff->orig_var.bits_per_pixel > 8)) {
		return;
	}

	cmap.start  = 0;
	cmap.len    = 1 << ff->orig_var.bits_per_pixel;
	cmap.red    = ff->orig_reds;
	cmap.green  = ff->orig_greens;
	cmap.blue   = ff->orig_blues;
	cmap.transp = NULL;

	if (ioctl(LIBGGI_FD(vis), FBIOGETCMAP, &cmap) < 0) {
		DPRINT_COLOR("display-fbdev: GETCMAP failed.\n");
		return;
	}

	DPRINT_COLOR("display-fbdev: Saved palette (len=%d).\n", cmap.len);
}

void _GGI_fbdev_restore_palette(ggi_visual *vis)
{
	fbdev_hook *ff = LIBGGI_PRIVATE(vis);

	struct fb_cmap cmap;

	if ((ff->orig_var.bits_per_pixel < 1) || 
	    (ff->orig_var.bits_per_pixel > 8)) {
		return;
	}

	cmap.start  = 0;
	cmap.len    = 1 << ff->orig_var.bits_per_pixel;
	cmap.red    = ff->orig_reds;
	cmap.green  = ff->orig_greens;
	cmap.blue   = ff->orig_blues;
	cmap.transp = NULL;

	if (ioctl(LIBGGI_FD(vis), FBIOPUTCMAP, &cmap) < 0) {
		DPRINT_COLOR("display-fbdev: PUTCMAP failed.\n");
		return;
	}

	DPRINT_COLOR("display-fbdev: Restored palette (len=%d).\n", 
			cmap.len);
}


/* ---------------------------------------------------------------------- */


int GGI_fbdev_setpalvec(ggi_visual *vis, int start, int len, ggi_color *colormap)
{
	fbdev_hook *ff = LIBGGI_PRIVATE(vis);

	struct fb_cmap cmap;

	int nocols = 1 << GT_DEPTH(LIBGGI_GT(vis));


	DPRINT_COLOR("display-fbdev: SetPalVec(%d,%d)\n", start, len);
	
	if (start == GGI_PALETTE_DONTCARE) {
		start = 0;
	}

	if ((start < 0) || (len < 0) || (start+len > nocols)) {
		return -1;
	}

	memcpy(vis->palette+start, colormap, len*sizeof(ggi_color));

	cmap.start  = start;
	cmap.len    = len;
	cmap.red    = & ff->reds[start];
	cmap.green  = & ff->greens[start];
	cmap.blue   = & ff->blues[start];
	cmap.transp = NULL;

	for (; len > 0; start++, colormap++, len--) {
	
		ff->reds[start]   = colormap->r;
		ff->greens[start] = colormap->g;
		ff->blues[start]  = colormap->b;
	}

	if (ioctl(LIBGGI_FD(vis), FBIOPUTCMAP, &cmap) < 0) {
		DPRINT_COLOR("display-fbdev: PUTCMAP failed.");
		return -1;
	}

	return 0;
}
