/*
 * showaccel.c - (c) 1998 Andreas Beck   becka@ggi-project.org
 *
 * This is a demonstration of LibGGI's functions and can be used as a
 * reference programming example.
 *
 *   This software is placed in the public domain and can be used freely
 *   for any purpose. It comes without any kind of warranty, either
 *   expressed or implied, including, but not limited to the implied
 *   warranties of merchantability or fitness for a particular purpose.
 *   Use it at your own risk. the author is not responsible for any damage
 *   or consequences raised by use or inability to use this program.
 */

#include <unistd.h>
#include <stdlib.h>
#include <stdio.h>
#include <fcntl.h>
#include <sys/ioctl.h>
#include <sys/mman.h>
#include <sys/time.h>
#ifdef __linux__
#include <linux/vt.h>
#endif
#include <string.h>
#include <ggi/ggi.h>

ggi_color pal[256];
ggi_uint paletteval[256];

ggi_visual_t vis;

int randnum(int max)
{ return (rand()%max); }

#ifdef  __sgi
static int slow_drawbox(int x,int y,int w,int h)
{ while(h--) ggiDrawHLine(vis,x,y++,w); return 0; }
#else
static inline int slow_drawbox(int x,int y,int w,int h)
{ while(h--) ggiDrawHLine(vis,x,y++,w); return 0; }
#endif

int main(int argc, char *argv[])
{ int t,c,y;
  int sx[]={640,1600,1280,1280,1024,1024,800,640,640,640,640,640,320,320,320,160};
  int sy[]={400,1200,1280, 960,1024, 768,600,480,400,200,100, 50,240,200,100,120};
  struct timeval tv;
  int c1,c2;

  if (ggiInit() != 0) {
	  fprintf(stderr, "%s: unable to initialize libggi, exiting.\n",
		  argv[0]);
	  exit(1);
  }
  if ((vis=ggiOpen(NULL)) == NULL) {
	  fprintf(stderr,
		  "%s: unable to open default visual, exiting.\n",
		  argv[0]);
	  exit(1);
  }
         
  for(t=0;t<sizeof(sx)/sizeof(int);t++)
  {
   if (ggiSetGraphMode(vis,sx[t],sy[t],GGI_AUTO,GGI_AUTO,GT_AUTO)) continue;
   printf("Mode OK:%dx%d    ",sx[t],sy[t]);

   ggiSetGCForeground(vis,0);
   ggiFillscreen(vis);

   for(c=0;c<256;c++)
    { pal[c].r=c*256;pal[c].g=256*(255-c);pal[c].b=(128-abs(128-c))*7*64; }
   ggiSetPalette(vis,0,256,pal);
   
   for(c=0;c<256;c++)
     paletteval[c]=ggiMapColor(vis,&pal[c]);
     
   ggiSetGCForeground(vis,paletteval[255]);
   ggiPuts(vis,0,0,"Accelerated");
   ggiPuts(vis,sx[t]/2,0,"Mundane");
   c1=c2=0;
   
   for(y=0;y<500*500;y++)
   { 
     ggiSetGCForeground(vis,paletteval[randnum(256)]);
     gettimeofday(&tv,NULL);
     if ((tv.tv_usec/10000)&1)
     { ggiDrawBox(vis,randnum(sx[t]/4),randnum(sy[t]/2-10)+10,
      		      randnum(sx[t]/4),randnum(sy[t]/2-10));
       c1++;
     }
     else
     { slow_drawbox(randnum(sx[t]/4)+sx[t]/2,randnum(sy[t]/2-10)+10,
     		    randnum(sx[t]/4)        ,randnum(sy[t]/2-10));
       c2++;
     }

     if ((y&255)==0)
     { char str[20];
       ggiSetGCForeground(vis,paletteval[255]);
       sprintf(str,"%8d",c1);
       ggiPuts(vis,sx[t]  /4,0,str);
       sprintf(str,"%8d",c2);
       ggiPuts(vis,sx[t]*3/4,0,str);
       if (ggiKbhit(vis)) break;
     }
   }
   if (c2==0) c2=1;
   printf("Ratio : %8d : %8d = %2f\n",c1,c2,(double)c1/(double)c2);
   ggiGetc(vis);
  }
  ggiClose(vis);
  ggiExit();
  return(0);
}
