/* $Id: pixel.c,v 1.9 1998/09/20 21:23:28 marcus Exp $
***************************************************************************

   Graphics library for GGI. Pixels.

   Copyright (C) 1995 Andreas Beck     [becka@ggi-project.org]
   Copyright (C) 1997 Jason McMullan   [jmcc@ggi-project.org]
   Copyright (C) 1998 MenTaLguY        [mentalg@geocities.com]
   Copyright (C) 1998 Andrew Apted     [andrew@ggi-project.org]

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

***************************************************************************
*/

#include <ggi/internal/ggi-dl.h>

#define PIXEL_RADDR(vis, x, y)  \
	((uint16 *) LIBGGI_CURREAD(vis) + y*LIBGGI_FB_R_STRIDE(vis)/sizeof(uint16) + x)
#define PIXEL_WADDR(vis, x, y)  \
	((uint16 *) LIBGGI_CURWRITE(vis) + y*LIBGGI_FB_W_STRIDE(vis)/sizeof(uint16) + x)


int GGIdrawpixel(ggi_visual *vis, int x, int y)
{
	CHECKXY(vis, x, y);
 
	*PIXEL_WADDR(vis, x, y) = LIBGGI_GC_FGCOLOR(vis);

	return 0;
}

int GGIdrawpixel_nc(ggi_visual *vis, int x, int y)
{
	*PIXEL_WADDR(vis, x, y) = LIBGGI_GC_FGCOLOR(vis);

	return 0;
}

int GGIputpixel_nc(ggi_visual *vis, int x, int y, ggi_pixel col)
{ 
	*PIXEL_WADDR(vis, x, y) = col;

	return 0;
}

int GGIputpixel(ggi_visual *vis, int x, int y, ggi_pixel col)
{ 
	CHECKXY(vis, x, y);

	*PIXEL_WADDR(vis, x, y) = col;

	return 0;
}

int GGIgetpixel(ggi_visual *vis, int x, int y, ggi_pixel *pixel)
{ 
	*pixel = *PIXEL_RADDR(vis, x, y);

	return 0;
}
