/* $Id: fillscreen.c,v 1.8 1998/09/20 21:22:41 marcus Exp $
***************************************************************************

   Graphics library for GGI.

   Copyright (C) 1995 Andreas Beck [becka@ggi-project.org]
   Copyright (C) 1997 Jason McMullan [jmcc@ggi-project.org]

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

***************************************************************************
*/

#include <string.h>

#include <ggi/internal/ggi-dl.h>

/*************************************/
/* fill (erase) the (virtual) screen */
/*************************************/

#warning FIXME: LIBGGI_FB_W_STRIDE(vis)%12 != 0 case not supported
int GGIfillscreen(ggi_visual *vis)
{
  	if (LIBGGI_GC(vis)->cliptl.x==0 &&
	    LIBGGI_GC(vis)->cliptl.y==0 &&
	    LIBGGI_GC(vis)->clipbr.x==LIBGGI_VIRTX(vis) &&
	    LIBGGI_GC(vis)->clipbr.y==LIBGGI_VIRTY(vis)) {
		int col[3];
		uint32 *buf=LIBGGI_CURWRITE(vis);
		int x,y;
		uint8 *colp=(uint8 *)col;
		for (x=0;x<4;x++) {
			*colp++=(LIBGGI_GC_FGCOLOR(vis))&0xFF;
			*colp++=(LIBGGI_GC_FGCOLOR(vis)>>8)&0xFF;
			*colp++=(LIBGGI_GC_FGCOLOR(vis)>>16)&0xFF;
		}
		for (y=0; y < LIBGGI_VIRTY(vis); y++) {
			for (x=0; x < LIBGGI_VIRTX(vis); x += 3) {
				*buf++=col[0];
				*buf++=col[1];
				*buf++=col[2];
			}
			buf = (uint32 *)((uint8 *)buf
					 + (LIBGGI_FB_W_STRIDE(vis)
					    - LIBGGI_VIRTX(vis)*4));
		}
	} else
		ggiDrawBox(vis,
			   LIBGGI_GC(vis)->cliptl.x, LIBGGI_GC(vis)->cliptl.y,
			   LIBGGI_GC(vis)->clipbr.x,LIBGGI_GC(vis)->clipbr.y);
	return 0;
}
