/* 
   Linear 1 horizontal lines.

   Copyright (C) 1995 Andreas Beck   [becka@ggi-project.org]
   Copyright (C) 1998 Andrew Apted  [andrew@ggi-project.org]

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include <string.h>

#include <ggi/internal/ggi-dl.h>


int GGIdrawhline_nc(ggi_visual *vis,int x,int y,int w)
{
	uint8 *adr;
	int i,j,mask,color;

	color=(LIBGGI_GC_FGCOLOR(vis)&1)*0xFF;

	adr=((uint8 *)(LIBGGI_CURWRITE(vis)));
	adr+=(x/8+y*LIBGGI_FB_W_STRIDE(vis));

	/* Draw 'front' pixels */ 
	j=w;
	if ((i=x&7)) {
		if ((j=j+i-8)<=0) {
			mask=(0xff>>i)&(0xff<<-j); 
			*adr   = (*adr & ~mask) | (color & mask);
			return 0;
		} else {
			mask=(0xff>>i);
			*adr++ = (*adr & ~mask) | (color & mask);
		}
	}
	
	while ((j-=8)>=0) 
		*(adr++) = color;
    
	/* Draw `back` pixels if necessary */
	mask=~(0xff>>(j&7));
	*adr = (*adr & ~mask) | (color & mask);

	return 0;
}

int GGIputhline(ggi_visual *vis,int x,int y,int w,void *buffer)
{ 
	uint8 *adr,*buff=(uint8 *)buffer;
	int mask,i,j,diff=0;
	uint8 foo,color;

	/* Clipping */
	if (y<(LIBGGI_GC(vis)->cliptl.y) || y>=(LIBGGI_GC(vis)->clipbr.y)) return 0;
	if (x< (LIBGGI_GC(vis)->cliptl.x)) {
		diff=(LIBGGI_GC(vis)->cliptl.x)-x;
		x+=diff;w-=diff;
		buff+=(diff>>3);diff&=7;
	}
	if (x+w>(LIBGGI_GC(vis)->clipbr.x)) {
		w=(LIBGGI_GC(vis)->clipbr.x)-x;
	}
	if (w<=0) return 0;

	adr=((uint8 *)(LIBGGI_CURWRITE(vis)));
	adr+=(x/8+y*LIBGGI_FB_W_STRIDE(vis));

	color=buff[0];
	if ((i=x&7)) {
		if ((j=w+i-8)<0) {
			mask=(0xff>>i)&(0xff<<-j); 
		} else {
			mask=0xff>>i;
		}

		foo = (*adr & ~mask);
		*adr = foo | ((color >> (i+=diff)) & mask);

		if (j<0)
			return 0;
		else
			adr++;
	} else
		j=w;i+=diff;

	while ((j-=8)>=0) {
		color <<= (8-i);
		color |= *(++buff) >> i;
		*adr = color;
	}

    
	if (j&=7) {
		color <<= (8-i);
		color |= *(++buff) >> i;

		mask=~(0xff>>j);
		foo = (*adr & ~mask);
		*adr = foo | ((color >> i) & mask);
	}
  
	return 0;
}

int GGIgethline(ggi_visual *vis,int x,int y,int w,void *buffer)
{ 
	uint8 *adr,*buff=(uint8 *)buffer;
	int mask,i,j;
	uint8 color;

	adr=((uint8 *)(LIBGGI_CURREAD(vis)));
	adr+=(x/8+y*LIBGGI_FB_R_STRIDE(vis));

	if ((i=x&7)) {
		if ((j=w+i-8)<0) {
			mask=(0xff>>i)&(0xff<<-j); 
		} else {
			mask=0xff>>i;
		}

		*buff = (*adr & mask) << (8-i);

		if (j<0)
			return 0;
		else
			adr++;
	} else
		j=w;
	

	while ((j-=8)>=0) {
		color = *adr;
		*(buff++) |= color >> i;
		*(buff) = (color << (8-i));
	}

    
	if (j&=7) {
		mask=~(0xff>>j);
		*buff |= (*adr & mask) >> i;
	}
  
	return 0;
}
