// fl_font_enumerate.C

// Function to list all possible names that can be given to
// Fl::set_font(const char *).  You could use this to provide the
// user with a way to choose fonts to display.

// OBSOLETE!  Replaced with Fl::set_fonts()

#include <FL/Fl.H>
#include <FL/x.H>
#include <ctype.h>
#include <string.h>
#include <stdlib.h>

extern char *fl_find_fontsize(char *name);

static int compar(const void *aa, const void *bb) {
  // skip the foundry:
  const char *a = *(char **)aa;
  if (*a=='-') for (a++; *a && *a++!='-';);
  const char *b = *(char **)bb;
  if (*b=='-') for (b++; *b && *b++!='-';);
  // compare numerically:
  for (;;) {
    if (isdigit(*a) && isdigit(*b)) {
      int na = strtol(a, (char **)&a, 10);
      int nb = strtol(b, (char **)&b, 10);
      if (na != nb) return na-nb;
    } else if (*a == *b && *a) {
      a++; b++;
    } else
      return (*a-*b);
  }
}

static int xlistsize;
static char **xlist;

void Fl::font_enumerate(void (*cb)(const char *,const int *,int)) {
  if (!xlist) {
    fl_open_display();
    xlist = XListFonts(fl_display, "*", 10000, &xlistsize);
    qsort(xlist, xlistsize, sizeof(*xlist), compar);
  }
  for (int i=0; i<xlistsize;) {
    char *p = xlist[i++];
    char *c = fl_find_fontsize(p);
    int sizes[128];
    int numsizes = 0;
    char buf[1024];
    if (c) {
      int foundry = (*p=='-'); if (foundry) for (p++; *p && *p++!='-';);
      sizes[0] = atoi(c); numsizes = 1;
      for (;;) { // find all matching fonts:
	if (i >= xlistsize) break;
	char *q = xlist[i];
	char *d = fl_find_fontsize(q);
	if (foundry) {
	  if (*q!='-') break;
	  for (q++; *q && *q++!='-';);
	}
	if (d-q != c-p || strncmp(p,q,c-p)) break;
	p = q;
	c = d;
	i++;
	int s = atoi(c);
	// insert-sort the new size into list:
	int n;
	for (n = numsizes; n > 0; n--) if (sizes[n-1] < s) break;
	if (sizes[n] != s) {
	  for (int m = numsizes; m > n; m--) sizes[m] = sizes[m-1];
	  sizes[n] = s;
	  numsizes++;
	}
      }
      // replace fontsize with *:
      char *q = buf;
      if (foundry) {strcpy(buf,"-*-"); q = buf+3;}
      strncpy(q,p,c-p); q += c-p;
      *q++ = '*';
      *q++ = 0;
      p = buf;
    }
    cb(p,sizes,numsizes);
  }
}
