// fl_engraved_label.C

// Drawing code for XForms style engraved & embossed labels

#include <FL/Fl.H>
#include <FL/Fl_Widget.H>
#include <FL/fl_draw.H>

// data[] is dx, dy, color triples

static void innards(
    const Fl_Label* o, int X, int Y, int W, int H, uchar align,
    int data[][3], int n)
{
  uchar a1 = align;
  if (a1 & FL_ALIGN_CLIP) {fl_clip(X, Y, W, H); a1 = a1&~FL_ALIGN_CLIP;}
  fl_font(o->font, o->size);
  for (int i = 0; i < n; i++) {
    fl_color(i < n-1 ? data[i][2] : o->color);
    fl_draw(o->value, X+data[i][0], Y+data[i][1], W, H, a1);
  }
  if (align & FL_ALIGN_CLIP) fl_pop_clip();
}

static void fl_shadow_label(
    const Fl_Label* o, int X, int Y, int W, int H, uchar align)
{
  static int data[2][3] = {{2,2,FL_DARK3},{0,0,0}};
  innards(o, X, Y, W, H, align, data, 2);
}

static void fl_engraved_label(
    const Fl_Label* o, int X, int Y, int W, int H, uchar align)
{
  static int data[7][3] = {
    {1,0,FL_LIGHT3},{1,1,FL_LIGHT3},{0,1,FL_LIGHT3},
    {-1,0,FL_DARK3},{-1,-1,FL_DARK3},{0,-1,FL_DARK3},
    {0,0,0}};
  innards(o, X, Y, W, H, align, data, 7);
}

static void fl_embossed_label(
    const Fl_Label* o, int X, int Y, int W, int H, uchar align)
{
  static int data[7][3] = {
    {-1,0,FL_LIGHT3},{-1,-1,FL_LIGHT3},{0,-1,FL_LIGHT3},
    {1,0,FL_DARK3},{1,1,FL_DARK3},{0,1,FL_DARK3},
    {0,0,0}};
  innards(o, X, Y, W, H, align, data, 7);
}

uchar define_FL_SHADOW_LABEL() {
  return Fl::set_labeltype(_FL_SHADOW_LABEL, fl_shadow_label, 0);
}
uchar define_FL_ENGRAVED_LABEL() {
  return Fl::set_labeltype(_FL_ENGRAVED_LABEL, fl_engraved_label, 0);
}
uchar define_FL_EMBOSSED_LABEL() {
  return Fl::set_labeltype(_FL_EMBOSSED_LABEL, fl_embossed_label, 0);
}
