// Fl_Widget.H

// fltk (Fast Light Tool Kit) version 0.99
// Copyright (C) 1998 Bill Spitzak

#ifndef Fl_Widget_H
#define Fl_Widget_H

#include "Enumerations.H"

class Fl_Widget;
class Fl_Window;

typedef void (Fl_Callback )(Fl_Widget*, void*);
typedef void (Fl_Callback0)(Fl_Widget*);
typedef void (Fl_Callback1)(Fl_Widget*, long);

struct Fl_Label {
  const char* value;
  uchar type;
  uchar font;
  uchar size;
  uchar color;
  void draw(int,int,int,int, uchar align) const ;
  void measure(int&, int&) const ;
};

class Fl_Widget {
  friend class Fl_Group;

  Fl_Widget* parent_;
  Fl_Callback* callback_;
  void* user_data_;
  short x_,y_,w_,h_;
  short ix_,iy_,iw_,ih_;
  Fl_Label label_;
  uchar type_;
  uchar flags_;
  uchar damage_;
  uchar box_;
  uchar color_;
  uchar color2_;
  uchar align_;
  uchar when_;

  // "de-implement" the copy constructors:
  Fl_Widget & operator=(const Fl_Widget &);
  Fl_Widget(const Fl_Widget &);

protected:

  Fl_Widget(int,int,int,int,const char* =0);

  void x(int v) {x_ = v;}
  void y(int v) {y_ = v;}
  void w(int v) {w_ = v;}
  void h(int v) {h_ = v;}

  uchar flags() const {return flags_;}
  void set_flag(int c) {flags_ |= c;}
  void clear_flag(int c) {flags_ &= ~c;}
  enum {INACTIVE=1, INVISIBLE=2, SHORTCUT_LABEL=64, CHANGED=128};

  void draw_box() const;
  void draw_box(uchar b, uchar c) const;
  void draw_label() const;
  void draw_label(int, int, int, int) const;

public:

  virtual ~Fl_Widget();

  virtual void draw() = 0;
  virtual int handle(int);
  Fl_Widget* parent() const {return parent_;}
  void parent(Fl_Widget* w) {parent_ = w;} // for hacks only

  uchar type() const {return type_;}
  void type(uchar t) {type_ = t;}

  int x() const {return x_;}
  int y() const {return y_;}
  int w() const {return w_;}
  int h() const {return h_;}
  int ix() const {return ix_;}
  int iy() const {return iy_;}
  int iw() const {return iw_;}
  int ih() const {return ih_;}
  virtual void resize(int,int,int,int);
  void init_size(int,int,int,int);
  void position(int X,int Y) {resize(X,Y,w_,h_);}
  void size(int W,int H) {resize(x_,y_,W,H);}

  uchar align() const {return align_;}
  void align(uchar a) {align_ = a;}
  uchar box() const {return box_;}
  void box(uchar a) {box_ = a;}
  uchar color() const {return color_;}
  void color(uchar a) {color_ = a;}
  uchar color2() const {return color2_;}
  void color2(uchar a) {color2_ = a;}
  void color(uchar a,uchar b) {color_=a; color2_=b;}
  const char* label() const {return label_.value;}
  void label(const char* a) {label_.value=a;}
  void label(uchar a,const char* b) {label_.type = a; label_.value = b;}
  uchar labeltype() const {return label_.type;}
  void labeltype(uchar a) {label_.type = a;}
  uchar labelcolor() const {return label_.color;}
  void labelcolor(uchar a) {label_.color=a;}
  uchar labelfont() const {return label_.font;}
  void labelfont(uchar a) {label_.font=a;}
  uchar labelsize() const {return label_.size;}
  void labelsize(uchar a) {label_.size=a;}
  Fl_Callback* callback() const {return callback_;}
  void callback(Fl_Callback* c, void* p) {callback_=c; user_data_=p;}
  void callback(Fl_Callback* c) {callback_=c;}
  void callback(Fl_Callback0*c) {callback_=(Fl_Callback*)c;}
  void callback(Fl_Callback1*c, long p=0) {callback_=(Fl_Callback*)c; user_data_=(void*)p;}
  void* user_data() const {return user_data_;}
  void user_data(void* v) {user_data_ = v;}
  long argument() const {return (long)user_data_;}
  void argument(long v) {user_data_ = (void*)v;}
  uchar when() const {return when_;}
  void when(uchar i) {when_ = i;}

  int visible() const {return !(flags_&INVISIBLE);}
  void show();
  void hide();
  void set_visible() {flags_ &= ~INVISIBLE;}
  void clear_visible() {flags_ |= INVISIBLE;}
  int active() const {return !(flags_&INACTIVE);}
  void activate();
  void deactivate();
  int activevisible() const {return !(flags_&(INACTIVE|INVISIBLE));}
  int changed() const {return flags_&CHANGED;}
  void set_changed() {flags_ |= CHANGED;}
  void clear_changed() {flags_ &= ~CHANGED;}
  int take_focus();

  static void default_callback(Fl_Widget*, void*);
  void do_callback() {callback_(this,user_data_);}
  void do_callback(Fl_Widget* o,void* arg=0) {callback_(o,arg);}
  void do_callback(Fl_Widget* o,long arg) {callback_(o,(void*)arg);}
  int test_shortcut();
  static int test_shortcut(const char*);
  int contains(const Fl_Widget*) const ;
  int inside(const Fl_Widget* o) const {return o ? o->contains(this) : 0;}

  void redraw();
  uchar damage() const {return damage_;}
  void clear_damage(uchar c = 0) {damage_ = c;}
  void damage(uchar c);
  void damage(uchar c,int,int,int,int);
  void draw_label(int, int, int, int, uchar a) const;
  void measure_label(int& x, int& y) {label_.measure(x,y);}

  Fl_Window* window() const ;
};

// reserved type numbers (necessary for my cheapo RTTI) start here.
// grep the header files for "RESERVED_TYPE" to find the next available
// number.
#define FL_RESERVED_TYPE 100

#endif
