/*
	Audio File Library

	Copyright 1998, Michael Pruett <michael@68k.org>

	This library is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License as
	published by the Free Software Foundation; either version 2 of
	the License, or (at your option) any later version.

	This library is distributed in the hope that it will be
	useful, but WITHOUT ANY WARRANTY; without even the implied
	warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
	PURPOSE.  See the GNU General Public License for more details.

	You should have received a copy of the GNU General Public
	License along with this program; if not, write to the Free
	Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
	MA 02111-1307, USA.
*/

/*
	wave.h

	This file contains structures and constants pertinent to the RIFF
	WAVE file format.
*/

#ifndef WAVE_H
#define WAVE_H

enum
{
	WAVE_FORMAT_PCM = 0x0001,	/* Microsoft Pulse Code Modulation format */
	IBM_FORMAT_MULAW = 0x0101,	/* IBM mu-law format */
	IBM_FORMAT_ALAW = 0x0102,	/* IBM a-law format */
	IBM_FORMAT_ADPCM = 0x0103	/* IBM AVC Adaptive Differential Pulse Code
		Modulation format */
};

#endif
