%module _gtkxmhtml

%{
#include <gtk/gtk.h>
#include <gtk-xmhtml/gtk-xmhtml.h>
%}

%include glue.i

%typemap(python,in) GtkXmHTML * {
  if (PyGtk_Check($source))
    $target = GTK_XMHTML(PyGtk_Get($source));
  else {
    PyErr_SetString(PyExc_TypeError, "not a GtkObject");
    return NULL;
  }
}
%typemap(python,out) GtkXmHTML * {
  $target = PyGtk_New((GtkObject *)$source);
}

int gtk_xmhtml_get_type();
void pygtk_init();
GtkWidget *gtk_xmhtml_new();
void gtk_xmhtml_freeze(GtkXmHTML *html);
void gtk_xmhtml_thaw(GtkXmHTML *html);
void gtk_xmhtml_source(GtkXmHTML *html, char *source);
void gtk_xmhtml_set_string_direction(GtkXmHTML *html, int direction);
void gtk_xmhtml_set_alignment(GtkXmHTML *html, int alignment);
//void gtk_xmhtml_outline(GtkXmHTML *html, int flag);
//void gtk_xmhtml_set_font_family(GtkXmHTML *html, char *family, char *sizes);
//void gtk_xmhtml_set_font_family_fixed(GtkXmHTML *html, char *family,
//				      char *sizes);
void gtk_xmhtml_set_font_charset(GtkXmHTML *html, char *charset);
void gtk_xmhtml_set_allow_body_colors(GtkXmHTML *html, int enable);
void gtk_xmhtml_set_hilight_on_enter(GtkXmHTML *html, int flag);
void gtk_xmhtml_set_anchor_visited_underline_type(GtkXmHTML *html,
						  int underline_type);
void gtk_xmhtml_set_anchor_target_underline_type(GtkXmHTML *html,
						 int underline_type);
void gtk_xmhtml_set_allow_color_switching(GtkXmHTML *html, int flag);
void gtk_xmhtml_set_dithering(GtkXmHTML *html, int dither_type);
void gtk_xmhtml_set_allow_font_switching(GtkXmHTML *html, int flag);
void gtk_xmhtml_set_max_image_colors(GtkXmHTML *html, int max_colors);
void gtk_xmhtml_set_allow_images(GtkXmHTML *html, int flag);
void gtk_xmhtml_set_plc_intervals(GtkXmHTML *html, int min_delay,
				  int max_delay, int def_delay);
void gtk_xmhtml_set_def_body_image_url(GtkXmHTML *html, char *url);
void gtk_xmhtml_set_anchor_buttons(GtkXmHTML *html, int flag);
// gtk_xmhtml_set_anchor_cursor
void gtk_xmhtml_set_topline(GtkXmHTML *html, int line);
int gtk_xmhtml_get_topline(GtkXmHTML *html);
void gtk_xmhtml_set_freeze_animations(GtkXmHTML *html, int flag);
//char *gtk_xmhtml_get_source(GtkXmHTML *html);
void gtk_xmhtml_set_screen_gamma(GtkXmHTML *html, double gamma);
// gtk_xmhtml_set_image_procs
// gtk_xmhtml_set_event_proc
void gtk_xmhtml_set_perfect_colors(GtkXmHTML *html, int flag);
void gtk_xmhtml_set_uncompress_command(GtkXmHTML *html, char *cmd);
void gtk_xmhtml_set_strict_checking(GtkXmHTML *html, int flag);
void gtk_xmhtml_set_bad_html_warnings(GtkXmHTML *html, int flag);
void gtk_xmhtml_set_allow_form_coloring(GtkXmHTML *html, int flag);
void gtk_xmhtml_set_imagemap_draw(GtkXmHTML *html, int flag);
void gtk_xmhtml_set_mime_type(GtkXmHTML *html, char *mime_type);
void gtk_xmhtml_set_alpha_processing(GtkXmHTML *html, int flag);
void gtk_xmhtml_set_rgb_conv_mode(GtkXmHTML *html, int val);

%{
static PyObject *from_string(char *txt) {
  if (txt)
    return PyString_FromString(txt);
  else {
    Py_INCREF(Py_None);
    return Py_None;
  }
}
static PyObject *cobject_to_info(PyObject *self, PyObject *args) {
  PyObject *dict, *cobject, *list, *v;
  int i;
  gtk_xmhtml_callback_info *info;
  XmHTMLAnchorCallbackStruct *cb1;
  XmHTMLEventCallbackStruct *cb2;
  XmHTMLDocumentCallbackStruct *cb3;
  XmHTMLFormCallbackStruct *cb4;
  XmHTMLFrameCallbackStruct *cb5;
  XmHTMLImagemapCallbackStruct *cb6;
  XmHTMLLinkCallbackStruct *cb7;

  if (!PyArg_ParseTuple(args, "O!:cobject_to_info", &PyCObject_Type, &cobject))
    return NULL;
  info = PyCObject_AsVoidPtr(cobject);
  dict = PyDict_New();
  PyDict_SetItemString(dict, "reason", v=PyInt_FromLong(info->reason));
  Py_DECREF(v);
  switch (info->reason) {
  case 0:
  case XmCR_HTML_ANCHORTRACK:
    cb1 = (XmHTMLAnchorCallbackStruct *)info;
    PyDict_SetItemString(dict, "url_type", v=PyInt_FromLong(cb1->url_type));
    Py_DECREF(v);
    PyDict_SetItemString(dict, "line", v=PyInt_FromLong(cb1->line));
    Py_DECREF(v);
    PyDict_SetItemString(dict, "href", v=from_string(cb1->href));
    Py_DECREF(v);
    PyDict_SetItemString(dict, "target", v=from_string(cb1->target));
    Py_DECREF(v);
    PyDict_SetItemString(dict, "rel", v=from_string(cb1->rel));
    Py_DECREF(v);
    PyDict_SetItemString(dict, "rev", v=from_string(cb1->rev));
    Py_DECREF(v);
    PyDict_SetItemString(dict, "title", v=from_string(cb1->title));
    Py_DECREF(v);
    PyDict_SetItemString(dict, "is_frame", v=PyInt_FromLong(cb1->is_frame));
    Py_DECREF(v);
    PyDict_SetItemString(dict, "doit", v=PyInt_FromLong(cb1->doit));
    Py_DECREF(v);
    PyDict_SetItemString(dict, "visited", v=PyInt_FromLong(cb1->visited));
    Py_DECREF(v);
    break;
  case XmCR_HTML_EVENT:
  case XmCR_HTML_EVENTDESTROY:
    cb2 = (XmHTMLEventCallbackStruct *)info;
    PyDict_SetItemString(dict, "type", v=PyInt_FromLong(cb2->type));
    Py_DECREF(v);
    break;
  case XmCR_HTML_DOCUMENT:
    cb3 = (XmHTMLDocumentCallbackStruct *)info;
    PyDict_SetItemString(dict, "html32", v=PyInt_FromLong(cb3->html32));
    Py_DECREF(v);
    PyDict_SetItemString(dict, "verified", v=PyInt_FromLong(cb3->verified));
    Py_DECREF(v);
    PyDict_SetItemString(dict, "balanced", v=PyInt_FromLong(cb3->balanced));
    Py_DECREF(v);
    PyDict_SetItemString(dict, "terminated",v=PyInt_FromLong(cb3->terminated));
    Py_DECREF(v);
    PyDict_SetItemString(dict, "pass_level",v=PyInt_FromLong(cb3->pass_level));
    Py_DECREF(v);
    PyDict_SetItemString(dict, "redo", v=PyInt_FromLong(cb3->redo));
    Py_DECREF(v);
    break;
  case XmCR_HTML_FORM:
    cb4 = (XmHTMLFormCallbackStruct *)info;
    PyDict_SetItemString(dict, "action", v=from_string(cb4->action));
    Py_DECREF(v);
    PyDict_SetItemString(dict, "enctype", v=from_string(cb4->enctype));
    Py_DECREF(v);
    PyDict_SetItemString(dict, "method", v=PyInt_FromLong(cb4->method));
    Py_DECREF(v);
    /* XmHTMLFormDataRec XXXX */
    break;
  case XmCR_HTML_FRAMECREATE:
  case XmCR_HTML_FRAMEDESTROY:
  case XmCR_HTML_FRAME:
    cb5 = (XmHTMLFrameCallbackStruct *)info;
    PyDict_SetItemString(dict, "src", v=from_string(cb5->src));
    Py_DECREF(v);
    PyDict_SetItemString(dict, "name", v=from_string(cb5->name));
    Py_DECREF(v);
    PyDict_SetItemString(dict, "html", v=PyGtk_New((GtkObject *)cb5->html));
    Py_DECREF(v);
    PyDict_SetItemString(dict, "doit", v=PyInt_FromLong(cb5->doit));
    Py_DECREF(v);
    break;
  case XmCR_HTML_IMAGEMAPACTIVATE:
  case XmCR_HTML_IMAGEMAP:
    cb6 = (XmHTMLImagemapCallbackStruct *)info;
    PyDict_SetItemString(dict, "x", v=PyInt_FromLong(cb6->x));
    Py_DECREF(v);
    PyDict_SetItemString(dict, "y", v=PyInt_FromLong(cb6->y));
    Py_DECREF(v);
    PyDict_SetItemString(dict, "image_name",
			 v=from_string(cb6->image_name));
    Py_DECREF(v);
    PyDict_SetItemString(dict, "map_name", v=from_string(cb6->map_name));
    Py_DECREF(v);
    PyDict_SetItemString(dict, "map_contents",
			 v=from_string(cb6->map_contents));
    Py_DECREF(v);
    /* XXXX XmImageInfo *image */
    break;
  case XmCR_HTML_LINK:
    cb7 = (XmHTMLLinkCallbackStruct *)info;
    list = PyList_New(cb7->num_link);
    for (i = 0; i < cb7->num_link; i++)
      PyList_SetItem(list, i, Py_BuildValue("(ssss)", cb7->link[i].url,
					    cb7->link[i].rel,
					    cb7->link[i].rev,
					    cb7->link[i].title));
    PyDict_SetItemString(dict, "link", list);
    Py_DECREF(list);
    break;
  }
  return dict;
}
%}
%native(cobject_to_info) PyObject *cobject_to_info(PyObject *self,
						   PyObject *args);
