// These bindings are for the gnome canvas

/* the actual canvas */
int gnome_canvas_get_type();
GtkWidget *gnome_canvas_new();
GnomeCanvasItem *gnome_canvas_root(GnomeCanvas *canvas);
void gnome_canvas_set_scroll_region(GnomeCanvas *canvas, double x1, double y1,
				    double x2, double y2);
%{
static PyObject *gnome__canvas_get_scroll_region(PyObject *self,
						 PyObject *args) {
  PyObject *obj;
  double x1, y1, x2, y2;
  if (!PyArg_ParseTuple(args, "O!:gnome_canvas_get_scroll_region", PyGtk_Type,
			&obj))
    return NULL;
  gnome_canvas_get_scroll_region(GNOME_CANVAS(PyGtk_Get(obj)), &x1, &y1,
				 &x2,&y2);
  return Py_BuildValue("(dddd)", x1, y1, x2, y2);
}
%}
%native(gnome_canvas_get_scroll_region) PyObject *
        gnome__canvas_get_scroll_region(PyObject *self, PyObject *args);
void gnome_canvas_set_pixels_per_unit(GnomeCanvas *canvas, double n);
void gnome_canvas_set_size(GnomeCanvas *canvas, int width, int height);
void gnome_canvas_scroll_to(GnomeCanvas *canvas, int cx, int cy);
%{
static PyObject *gnome__canvas_get_scroll_offsets(PyObject *self,
						  PyObject *args) {
  PyObject *obj;
  int cx, cy;
  if (!PyArg_ParseTuple(args, "O!:gnome_canvas_get_scroll_offsets", PyGtk_Type,
			&obj))
    return NULL;
  gnome_canvas_get_scroll_offsets(GNOME_CANVAS(PyGtk_Get(obj)), &cx, &cy);
  return Py_BuildValue("(ii)", cx, cy);
}
%}
%native(gnome_canvas_get_scroll_offsets) PyObject *
        gnome__canvas_get_scroll_offsets(PyObject *self, PyObject *args);
void gnome_canvas_update_now(GnomeCanvas *canvas);
%{
static PyObject *gnome__canvas_w2c(PyObject *self, PyObject *args) {
  PyObject *obj;
  int cx, cy;
  double wx, wy;
  if (!PyArg_ParseTuple(args, "O!dd:gnome_canvas_w2c", PyGtk_Type, &obj,wx,wy))
    return NULL;
  gnome_canvas_w2c(GNOME_CANVAS(PyGtk_Get(obj)), wx, wy, &cx, &cy);
  return Py_BuildValue("(ii)", cx, cy);
}
static PyObject *gnome__canvas_c2w(PyObject *self, PyObject *args) {
  PyObject *obj;
  int cx, cy;
  double wx, wy;
  if (!PyArg_ParseTuple(args, "O!ii:gnome_canvas_w2c", PyGtk_Type, &obj,cx,cy))
    return NULL;
  gnome_canvas_c2w(GNOME_CANVAS(PyGtk_Get(obj)), cx, cy, &wx, &wy);
  return Py_BuildValue("(dd)", wx, wy);
}
static PyObject *gnome__canvas_get_color(PyObject *self, PyObject *args) {
  PyObject *obj;
  char *spec;
  GdkColor color;
  if (!PyArg_ParseTuple(args, "O!s:gnome_canvas_get_color", PyGtk_Type, &obj,
			&spec));
  if (gnome_canvas_get_color(GNOME_CANVAS(PyGtk_Get(obj)), spec, &color))
    return PyGdkColor_New(&color);
  PyErr_SetString(PyExc_TypeError, "invalid colour specification");
  return NULL;
} 
%}
%native(gnome_canvas_w2c) PyObject *gnome__canvas_w2c(PyObject *self,
						      PyObject *args);
%native(gnome_canvas_c2w) PyObject *gnome__canvas_c2w(PyObject *self,
						      PyObject *args);
%native(gnome_canvas_get_color) PyObject *gnome__canvas_get_color(
					PyObject *self, PyObject *args);

/* the canvas item type */
%{
static PyObject *gnome__canvas_item_new(PyObject *self, PyObject *args) {
  PyObject *parent, *dict, *ret;
  GtkType type;
  gint nargs;
  GtkArg *arg;
  if (!PyArg_ParseTuple(args, "O!iO!:gnome_canvas_item_new", PyGtk_Type,
			&parent, &type, &PyDict_Type, &dict))
    return NULL;
  arg = PyDict_AsGtkArgs(dict, type, &nargs);
  if (arg == NULL && nargs != 0)
    return NULL;
  ret = PyGtk_New((GtkObject *)gnome_canvas_item_newv(
				GNOME_CANVAS_GROUP(PyGtk_Get(parent)),
				type, nargs, arg));
  g_free(arg);
  return ret;
}
static PyObject *gnome__canvas_item_set(PyObject *self, PyObject *args) {
  PyObject *obj, *dict;
  GtkType type;
  gint nargs;
  GtkArg *arg;
  if (!PyArg_ParseTuple(args, "O!O!:gnome_canvas_item_new", PyGtk_Type,
			&obj, &PyDict_Type, &dict))
    return NULL;
  type = GTK_OBJECT_TYPE(PyGtk_Get(obj));
  arg = PyDict_AsGtkArgs(dict, type, &nargs);
  if (arg == NULL && nargs != 0)
    return NULL;
  gnome_canvas_item_setv(GNOME_CANVAS_ITEM(PyGtk_Get(obj)), nargs, arg);
  g_free(arg);
  Py_INCREF(Py_None);
  return Py_None;
}
%}
%native(gnome_canvas_item_new) PyObject *gnome__canvas_item_new(PyObject *self,
							PyObject *args);
%native(gnome_canvas_item_set) PyObject *gnome__canvas_item_set(PyObject *self,
							PyObject *args);
void gnome_canvas_item_move(GnomeCanvasItem *item, double dx, double dy);
void gnome_canvas_item_raise(GnomeCanvasItem *item, int positions);
void gnome_canvas_item_lower(GnomeCanvasItem *item, int positions);
void gnome_canvas_item_raise_to_top(GnomeCanvasItem *item);
void gnome_canvas_item_lower_to_bottom(GnomeCanvasItem *item);

/* gnome canvas item types */
int gnome_canvas_item_get_type();
int gnome_canvas_group_get_type();
int gnome_canvas_image_get_type();
int gnome_canvas_line_get_type();
int gnome_canvas_re_get_type();
int gnome_canvas_rect_get_type();
int gnome_canvas_ellipse_get_type();
int gnome_canvas_text_get_type();
int gnome_canvas_widget_get_type();
