/* This file is part of PyApache.
 * Copyright (C) 1996,97,98 by Lele Gaifax.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public License
 * as published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */

/*
 * RCSfile:  mod_pyapache.h,v
 * Revision: 4.5
 * Date:     1998/07/24 21:38:23
 *
 * Created Thu Aug 14 09:11:48 1997.
 */

#ifndef _pyapache_H
#define _pyapache_H

/* Apache includes */
#include "httpd.h"
#include "http_core.h"
#include "http_main.h"
#include "http_config.h"
#include "http_log.h"
#include "http_protocol.h"
#include "http_request.h"
#include "util_script.h"

/* Python includes */
#include <python1.5/Python.h>
#include <python1.5/compile.h>
#include <python1.5/eval.h>
#include <python1.5/structmember.h>

/* This is the structure that holds the per-directory configuration
   of this module. */
typedef struct pyapache_dir_config
{
  char *path;                   /* set with PythonPath new-path */
  int debug;                    /* set with PythonDebug On|Off */
  int verbose;                  /* set with PythonVerbose On|Off */
} pyapache_dir_config;

/* This is the structure that holds the per-server configuration
   of this module. */
typedef struct pyapache_server_config
{
  char *path;                   /* set with PyApachePath new-path */  
  char *startup;                /* set with PyApacheStartupScript filename */
  PyObject *server_dict;        /* Server-wide NameSpace */
} pyapache_server_config;


module PyApache_module;

/* XXX Is this right? Am I correctly understanding the form of the type? Or
   maybe "application/python-httpd-cgi" is a better choice? Any HTTP guru
   out there?*/
#define PYTHON_MAGIC_TYPE       "python/x-httpd-cgi"
#define ALT_PYTHON_MAGIC_TYPE   "python-cgi-script"

#endif /* _pyapache_H */

/*
** Local Variables:
** change-log-default-name: "ChangeLog"
** eval: (add-hook 'write-contents-hooks '(lambda () (untabify 0 (point-max)) nil) t nil)
** End:
*/
