/* Copyright (C) 1994 Guido Vattrodt DL3BZN
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

/* file.c	filefunctions for xconvers
 */

#include <stdio.h>     
#include <string.h>
#include <unistd.h>

#include <Xm/Xm.h>		
#include <Xm/FileSB.h>		

#include "xconvers.h" 
#include "misc.h"
#include "file.h"

/* globals */
extern FILE	*log_stream;


/*---------------------------------------------------------------------------
 * FileCancelCB  close File-Box
 */
void FileCancelCB(button, client_data, call_data)
	Widget	button;
	caddr_t	client_data;
	caddr_t	call_data;
{
  AppWidgets *app_w = (AppWidgets*) client_data;

  XtUnmanageChild(app_w->file_box);
}

/*---------------------------------------------------------------------------
 * StopRecordingCB  close open logfile
 */

void StopRecordingCB(button, client_data, call_data)
	Widget	button;
	caddr_t	client_data;
	caddr_t	call_data;
{
  if(log_stream != NULL) fclose(log_stream);
  XtSetSensitive(button, False);  
}


/*---------------------------------------------------------------------------
 * StartRecordingCB  open selected file for writing
 */

void StartRecordingCB(button, client_data, call_data)
	Widget	button;
	caddr_t	client_data;
	caddr_t	call_data;
{
  XmFileSelectionBoxCallbackStruct *select_data = (XmFileSelectionBoxCallbackStruct*)call_data;
  AppWidgets *app_w = (AppWidgets*) client_data;
 
  char		*filename;

  XtUnmanageChild(app_w->file_box);

  /* wandle XmString select_data->value in C-String um */
  XmStringGetLtoR(select_data->value, XmSTRING_DEFAULT_CHARSET, &filename);

  if(log_stream != NULL) fclose(log_stream);

  if(!strlen(filename)) InfoMsg("NO file", app_w);
  else if((log_stream=fopen(filename, "w+")) == NULL) 
		InfoMsg("Unable to open file", app_w);
       else   XtSetSensitive(app_w->button_stop_recording, True);  
}


/*---------------------------------------------------------------------------
 * DisplayFileBoxCB  show FileSelectionBox 
 */
void DisplayFileBoxCB(button, client_data, call_data)
	Widget	button;
	caddr_t	client_data;
	caddr_t	call_data;
{
  AppWidgets *app_w = (AppWidgets*) client_data;
  Widget	help_button;
  Arg		arg[4];
  Cardinal	n;
  XmString	tcs;

  if(app_w->file_box == NULL) {
     n = 0;
     tcs = XmStringLtoRCreate ("*.log", XmSTRING_DEFAULT_CHARSET);
     XtSetArg(arg[n], XmNdirMask, tcs); n++;
     app_w->file_box = XmCreateFileSelectionDialog(button, "fileBox", arg, n);
     XmStringFree(tcs);
     XtAddCallback(app_w->file_box, XmNokCallback, (XtCallbackProc)StartRecordingCB, client_data);
     XtAddCallback(app_w->file_box, XmNcancelCallback, (XtCallbackProc)FileCancelCB, client_data);
     help_button = XmFileSelectionBoxGetChild(app_w->file_box, XmDIALOG_HELP_BUTTON);
     XtUnmanageChild(help_button);
  }
  XtManageChild(app_w->file_box);
}

