/* Zgv v3.0 - GIF, JPEG and PBM/PGM/PPM viewer, for VGA PCs running Linux.
 * Copyright (C) 1993-1998 Russell Marks. See README for license details.
 *
 * readnbkey.c - reads a non-blocking key. Header file provides #defines
 *		 for weirdo keys and such.
 */

#include <stdio.h>
#include <unistd.h>
#include <string.h>
#include "readnbkey.h"


int getnbkey(int ttyfd)
{
unsigned char c;

c=0;
read(ttyfd,&c,1);
return((int)c);
}


/* returns a 'normal' ASCII value, or one of the values in readnbkey.h,
 * or zero if no key was pressed.
 */
int readnbkey(int ttyfd)
{
int f,left;
char keybuf[1024];

/* this gets all the characters sent by the key into an ASCIIZ string.
 * the no-waiting-for-keys approach depends on the way Linux dumps
 * the string into our input all at once; this is kind of nasty,
 * but zgv *is* Linux-specific, right? :-)
 */
f=0;
for(left=sizeof(keybuf);left>0 && (keybuf[f++]=getnbkey(ttyfd))!=0;left--) ;

/* this relies on a minimum-unique string approach rather than
 * checking for the trailing ~ (on function keys) or NUL (on everything :-)).
 */
if(keybuf[0]==27 && keybuf[1]=='[')
  {
  switch(keybuf[2])
    {
    case 'A':	return(RK_CURSOR_UP);
    case 'B':	return(RK_CURSOR_DOWN);
    case 'C':	return(RK_CURSOR_RIGHT);
    case 'D':	return(RK_CURSOR_LEFT);
    case '[':
      switch(keybuf[3])
        {
        case 'A':	return(RK_F1);
        case 'B':	return(RK_F2);
        case 'C':	return(RK_F3);
        case 'D':	return(RK_F4);
        case 'E':	return(RK_F5);
        }
      break;
    case '1':
      switch(keybuf[3])
        {
        case '~':	return(RK_HOME);
        case '7':	return(RK_F6);
        case '8':	return(RK_F7);
        case '9':	return(RK_F8);
        }
      break;
    case '2':
      switch(keybuf[3])
        {
        case '~':	return(RK_INSERT);
        case '0':	return(RK_F9);
        case '1':	return(RK_F10);
        case '3':	return(RK_F11);	/* can be shift F1 or F11 too */
        case '4':	return(RK_F12);	/* can be shift F2 of F12 too */
        case '5':	return(RK_SHIFT_F3);
        case '6':	return(RK_SHIFT_F4);
        case '8':	return(RK_SHIFT_F5);
        case '9':	return(RK_SHIFT_F6);
        }
      break;
    case '3':
      switch(keybuf[3])
        {
        case '~':	return(RK_DELETE);
        case '1':	return(RK_SHIFT_F7);
        case '2':	return(RK_SHIFT_F8);
        case '3':	return(RK_SHIFT_F9);
        case '4':	return(RK_SHIFT_F10);
        }
      break;
    case '4':	return(RK_END);
    case '5':	return(RK_PAGE_UP);
    case '6':	return(RK_PAGE_DOWN);
    }
  }

/* otherwise... */
return(*keybuf);
}
