/*****************************************************************************
 *                                                                           *
 * Programm:  paul                                                           *
 *            (P)rogramm zur (A)uswertung und (U)mformung von                *
 *            (L)aserbildern                                                 *
 * Modul:     rotate.c                                                       *
 *            rotate images at 90, 180 or 270 degrees clockwise              *
 * Autor:     Andreas Tille                                                  *
 * Datum:     30.09.1998                                                     *
 *                                                                           *
 *****************************************************************************/

#include <assert.h>
#include <stdlib.h>

#include "paul.h" 

#ifdef __DMALLOC__
#include <dmalloc.h>
#endif

static void RotateForeward(GList *piclist)
/* rotate all images in list 90 degrees clockwise
 * --- Parameter: ---
 * GList *piclist: list of images
 * --- Return: ---
 * GList *piclist: list of images 
 */
{
   GList                   *pl;
   PICTURE                 *bild;
   register  unsigned char *op, *np, *fip;
   unsigned  char          *data, *ozp, *nsp, *fzp;
   int                      old_width, new_width;

   if ( !NBILDER(piclist) ) return;

   for ( bild = BILD(pl = piclist); pl; bild = BILD(pl = pl->next) ) {
      register  int  storepix = bild->storepix;

      assert ( (data = malloc(bild->size*storepix)) );
      old_width = bild->W * storepix;
      new_width = bild->H * storepix;
      for ( fzp = (ozp = bild->DATA) + bild->size * storepix, 
            nsp = data + (bild->H - 1) * storepix; ozp < fzp;
            ozp += old_width, nsp -= storepix )
         for ( fip = (op = ozp) + old_width, np = nsp; op < fip;
               op++, np += new_width ) {
            *np = *op;
            if ( storepix != 1 ) {
               *(np+1) = *++op;
	       *(np+2) = *++op;
	    }
	 }
      NewImage(bild, bild->H, bild->W, data);
   }
}

static void RotateBackward(GList *piclist)
/* rotate all images in list 90 degrees counter clockwise (= 270 degrees)
 * --- Parameter: ---
 * GList *piclist: list of images
 * --- Return: ---
 * GList *piclist: list of images 
 */
{
   GList                   *pl;
   PICTURE                 *bild;
   register  unsigned char *op, *np, *fip;
   unsigned  char          *data, *ozp, *nsp, *fzp;
   int                      old_width, new_width;

   if ( !NBILDER(piclist) ) return;

   for ( bild = BILD(pl = piclist); pl; bild = BILD(pl = pl->next) ) {
      register  int  storepix = bild->storepix;

      assert ( (data = malloc(bild->size*storepix)) );
      old_width = bild->W * storepix;
      new_width = bild->H * storepix;
      for ( fzp = (nsp = data) + bild->size * storepix, 
            ozp = bild->DATA + (bild->W - 1) * storepix; nsp < fzp;
            nsp += new_width, ozp -= storepix )
         for ( fip = (np = nsp) + new_width, op = ozp; np < fip;
               op += old_width, np++ ) {
            *np = *op;
            if ( storepix != 1 ) {
               *++np = *(op+1);
	       *++np = *(op+2);
	    }
	 }
      NewImage(bild, bild->H, bild->W, data);
   }
   
}

int MakeRotate(PAUL *p)
/* rotate images at 90, 180 or 270 degrees clockwise
 * --- Parameter: ---
 * PAUL   *p            : list of images
 * --- Return: ---
 * int     MakeMirror() : 0 if OK
 */
{
   PICTURE *bild;
   GList   *pl;
   long flag = p->opt->f;

   if ( !NBILDER(p->piclist) ) return 0;

   if ( Rotate90(flag) ) RotateForeward(p->piclist);
   else if ( Rotate180(flag) ) {
      p->opt->f |= (MIRROR_H | MIRROR_V);
      MakeMirror(p);
      p->opt->f = flag;
   }
   else if ( Rotate270(flag) ) RotateBackward(p->piclist);
   else return -1;
   
   for ( bild = BILD(pl = p->piclist); pl; bild = BILD(pl = pl->next) ) {
      CopySpec(bild->spec, ChunkNameTyp, TypRotate);
      NewFileName(bild, APPROTATE);
      bild->flag |= Rotate(flag);;
   }

   p->opt->f &= ~(ROT_90 | ROT_180);
   return 0;
}

