/*****************************************************************************
 *                                                                           *
 * Programm:  paul                                                           *
 *            (P)rogramm zur (A)uswertung und (U)mformung von                *
 *            (L)aserbildern                                                 *
 * Modul:     parameter.c                                                    *
 *            Callback functions to adjust parameters                        *
 * Autor:     Andreas Tille                                                  *
 * Datum:     14.06.1998                                                     *
 *                                                                           *
 *****************************************************************************/

#include <unistd.h>
#include <assert.h>
#include <gdk/gdkkeysyms.h>
#include "paul.h"
#include "callback.h"

/*****************************************************************************************
 * Callbacks to for border deletion                                                      *
 * related to: this/mark/all images                                                      *
 *****************************************************************************************/

void DelBorderParameterCallback(GtkWidget *widget, PAUL *p)
{
   PARA_IN *para_in;
   ITEM    *para;
   
   assert ( (para_in = malloc(sizeof(PARA_IN))) );
   
   para_in->title = "Parameters for border deletion";
   para_in->frame = "Delete border levels";
   para_in->np    = 2;
   
   assert ( (para   = malloc(para_in->np*sizeof(ITEM))) );
   para->name       = "Maximum gray value for border:";
   para->typ        = P_UCHAR;
   para->val        = &(p->opt->thresh);
   para->upper      = 255.0;
   para->lower      =   0.0;
   para->valchg     = NULL;
   para->adj        = NULL;
   (para+1)->name   = "Allowed error for one pixel:";
   (para+1)->typ    = P_UCHAR;
   (para+1)->val    = &(p->opt->terr);
   (para+1)->upper  = 255.0;
   (para+1)->lower  =   0.0;
   (para+1)->valchg = NULL;
   (para+1)->adj    = NULL;

   para_in->para = para;
   
   BuildParameterInput(para_in, p, NULL);
}

/*****************************************************************************************
 * Callback to build difference images                                                   *
 * related to: all images                                                                *
 * remark: the scale parameters influence building differences too                       *
 *****************************************************************************************/

void DifferenceParameterCallback(GtkWidget *widget, PAUL *p)
{
   PARA_IN *para_in;
   ITEM    *para;
   
   assert ( (para    = malloc(sizeof(ITEM))) );
   assert ( (para_in = malloc(sizeof(PARA_IN))) );
   
   para_in->title = "Parameter for difference images";
   para_in->frame = "Errorlevel";
   para_in->np    = 1;
   
   para->name     = "Level to set difference equal 0:";
   para->typ      = P_UCHAR;
   para->val      = &(p->opt->eps);
   para->upper    = 255.0;
   para->lower    =   0.0;
   para->valchg   = NULL;
   para->adj      = NULL;

   para_in->para = para;
   
   BuildParameterInput(para_in, p, NULL);
}

/*****************************************************************************************
 * Callback to change contrast or brightness of an image                                 *
 * related to: this/all images                                                           *
 *****************************************************************************************/

void ScaleParameterCallback(GtkWidget *widget, PAUL *p)
{
   PARA_IN *para_in;
   ITEM    *para;
   
   assert ( (para_in = malloc(sizeof(PARA_IN))) );
   
   para_in->title   = "Contrast / brightness";
   para_in->frame   = "Contrast and Brightness parameters";
   para_in->np      = 2;
   
   assert ( (para   = malloc(para_in->np*sizeof(ITEM))) );
   para->name       = "Contrast factor:";
   para->typ        = P_DOUBLE;
   para->val        = &(p->opt->scale);
   para->upper      = 255.0;
   para->lower      = 0.0;
   para->valchg     = NULL;
   para->adj        = NULL;
   
   (para+1)->name   = "Brightness Offset:";
   (para+1)->typ    = P_INT;
   (para+1)->val    = &(p->opt->offset);
   (para+1)->upper  =  255.0;
   (para+1)->lower  = -255.0;
   (para+1)->valchg = NULL;
   (para+1)->adj    = NULL;

   para_in->para = para;
   
   BuildParameterInput(para_in, p, NULL);
}

/*****************************************************************************************
 * Callback to make monochrome images (visualisation of paul in green)                   *
 * related to: this/mark/all images                                                      *
 *****************************************************************************************/

void GrayParameterCallback(GtkWidget *widget, PAUL *p)
{
   RADIO_PARA_IN *para_in;
   RADIO         *para;

   assert ( (para_in = malloc(sizeof(RADIO_PARA_IN))) );

   para_in->title = "Make monochrome from RGB";
   para_in->frame = "Use channel or all";
   para_in->np    = 4;
   para_in->val   = &(p->opt->greps);
   if ( p->opt->greps > 3 ) para_in->def = 3;
   else                     para_in->def = p->opt->greps;

   assert ( (para    = malloc(para_in->np * sizeof(RADIO))) );
   para->name      = "Use red channel";
   para->val       = 0;
   (para+1)->name  = "Use green channel";
   (para+1)->val   = 1;
   (para+2)->name  = "Use blue channel";
   (para+2)->val   = 2;
   (para+3)->name  = "Use all channels";
   (para+3)->val   = 3;
 
   para_in->radio = para;
   RadioButtonParameter(para_in);
}

/*****************************************************************************************
 * Callback to filter images (dummy at this moment)                                      *
 * related to: this/mark/all images                                                      *
 *****************************************************************************************/

void FilterParameterCallback(GtkWidget *widget, PAUL *p)
{
   PARA_IN *para_in;
   ITEM    *para;
   
   assert ( (para_in = malloc(sizeof(PARA_IN))) );
   
   para_in->title = "Parameter for Filter";
   para_in->frame = "Medianfilter";
   para_in->np    = 1;
   
   assert ( (para = malloc(para_in->np*sizeof(ITEM))) );
   para->name     = "Filter size (has to be odd number):";
   para->typ      = P_UCHAR;
   para->val      = &(p->opt->fordn);
   para->upper    = 11.0;
   para->lower    =  3.0;
   para->valchg   = NULL;
   para->adj      = NULL;

   para_in->para = para;
   
   BuildParameterInput(para_in, p, NULL);
}

/*****************************************************************************************
 * Callback to set type of matching pictures                                             *
 * related to: all images                                                                *
 *****************************************************************************************/

void MoveParameterCallback(GtkWidget *widget, PAUL *p)
{
   RADIO_PARA_IN *para_in;
   RADIO         *para;

   if ( DoMatchPictures(p->opt->f) ) {
      g_warning("Please don't change the moving method while moving images");
      return;
   }

   assert ( (para_in = malloc(sizeof(RADIO_PARA_IN))) );

   para_in->title = "Move images against first";
   para_in->frame = "Type of movement";
   para_in->np    = 3;
   para_in->val   = &(p->opt->mov);
   if ( !(p->opt->mov) ) p->opt->mov = MATCHDIF;
   para_in->def   = p->opt->mov - MATCHCOL;

   assert ( (para    = malloc(para_in->np * sizeof(RADIO))) );
   para->name      = "Use different colors";
   para->val       = MATCHCOL;
   (para+1)->name  = "Difference";
   (para+1)->val   = MATCHDIF;
   (para+2)->name  = "Flash first image";
   (para+2)->val   = MATCHFLASH;
 
   para_in->radio = para;
   RadioButtonParameter(para_in);
}

