// This file is part of Moonlight Creator
//   Copyright (C) 1996-1998  Stephane Rehel
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU Library General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Library General Public License for more details.
//
// You should have received a copy of the GNU Library General Public
// License along with this library; if not, write to the Free
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

/*
  HRCModel.C

  Stephane Rehel
  June 18th, 1996
*/

#include "tools/mathcls.h"
#include "tools/ilist.h"

#include "HRCModel.h"

/////////////////////////////////////////////////////////////////////////////

HRCModel::HRCModel()
{
  name= MLString("");
  scaling= Vector(1,1,1);
  rotation= Vector(0,0,0);
  translation= Vector(0,0,0);
  discontinuity= 60.;

  nVertices= 0;
  vertices= 0;

  nPolygons= 0;
  polygons= 0;
}

/////////////////////////////////////////////////////////////////////////////

HRCModel::~HRCModel()
{
  delete vertices; vertices= 0;

  for( int i= 0; i < nPolygons; ++i )
    {
    assert( polygons != 0 );
    Polygon& p= polygons[i];
    delete p.nodes;
    p.nodes= 0;
    p.nNodes= 0;
    }

  delete polygons;
  nPolygons= 0;

  children.destroyElements();
}

/////////////////////////////////////////////////////////////////////////////

void HRCModel::purge()
{
  IListIterator<HRCModel> li(children);
  while( ! li.eol() )
    {
    HRCModel* child= li.next();
    child->purge();
    }

  for(;;)
    {
    boolean reloop= false;
    li.reset();
    while( ! li.eol() )
      {
      HRCModel* child= li.next();
      if( child->children.empty() &&
          child->nVertices == 0 )
        {
        children.remove(child);
        reloop= true;
        break;
        }
      }
    if( ! reloop )
      break;
    }
}

/////////////////////////////////////////////////////////////////////////////

int HRCModel::getNPolygons()
{
  int n= nPolygons;

  IListIterator<HRCModel> li(children);
  while( ! li.eol() )
    n+= li.next()->getNPolygons();

  return n;
}

/////////////////////////////////////////////////////////////////////////////
